/****************************************************************************
 * arch/risc-v/src/mpfs/hardware/mpfs_ddr.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_MPFS_HARDWARE_MPFS_DDR_H
#define __ARCH_RISCV_SRC_MPFS_HARDWARE_MPFS_DDR_H

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define MPFS_DDR_CSR_APB_CFG_MANUAL_ADDRESS_MAP_OFFSET             0x2400
#define MPFS_DDR_CSR_APB_CFG_CHIPADDR_MAP_OFFSET                   0x2404
#define MPFS_DDR_CSR_APB_CFG_CIDADDR_MAP_OFFSET                    0x2408
#define MPFS_DDR_CSR_APB_CFG_MB_AUTOPCH_COL_BIT_POS_LOW_OFFSET     0x240c
#define MPFS_DDR_CSR_APB_CFG_MB_AUTOPCH_COL_BIT_POS_HIGH_OFFSET    0x2410
#define MPFS_DDR_CSR_APB_CFG_BANKADDR_MAP_0_OFFSET                 0x2414
#define MPFS_DDR_CSR_APB_CFG_BANKADDR_MAP_1_OFFSET                 0x2418
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_0_OFFSET                  0x241c
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_1_OFFSET                  0x2420
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_2_OFFSET                  0x2424
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_3_OFFSET                  0x2428
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_0_OFFSET                  0x242c
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_1_OFFSET                  0x2430
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_2_OFFSET                  0x2434

#define MPFS_DDR_CSR_APB_CFG_VRCG_ENABLE_OFFSET                    0x2800
#define MPFS_DDR_CSR_APB_CFG_VRCG_DISABLE_OFFSET                   0x2804
#define MPFS_DDR_CSR_APB_CFG_WRITE_LATENCY_SET_OFFSET              0x2808
#define MPFS_DDR_CSR_APB_CFG_THERMAL_OFFSET_OFFSET                 0x280c
#define MPFS_DDR_CSR_APB_CFG_SOC_ODT_OFFSET                        0x2810
#define MPFS_DDR_CSR_APB_CFG_ODTE_CK_OFFSET                        0x2814
#define MPFS_DDR_CSR_APB_CFG_ODTE_CS_OFFSET                        0x2818
#define MPFS_DDR_CSR_APB_CFG_ODTD_CA_OFFSET                        0x281c
#define MPFS_DDR_CSR_APB_CFG_LPDDR4_FSP_OP_OFFSET                  0x2820
#define MPFS_DDR_CSR_APB_CFG_GENERATE_REFRESH_ON_SRX_OFFSET        0x2824
#define MPFS_DDR_CSR_APB_CFG_DBI_CL_OFFSET                         0x2828
#define MPFS_DDR_CSR_APB_CFG_NON_DBI_CL_OFFSET                     0x282c
#define MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_DATA_0_OFFSET            0x2830

#define MPFS_DDR_CSR_APB_CFG_WRITE_CRC_OFFSET                      0x3c00
#define MPFS_DDR_CSR_APB_CFG_MPR_READ_FORMAT_OFFSET                0x3c04
#define MPFS_DDR_CSR_APB_CFG_WR_CMD_LAT_CRC_DM_OFFSET              0x3c08
#define MPFS_DDR_CSR_APB_CFG_FINE_GRAN_REF_MODE_OFFSET             0x3c0c
#define MPFS_DDR_CSR_APB_CFG_TEMP_SENSOR_READOUT_OFFSET            0x3c10
#define MPFS_DDR_CSR_APB_CFG_PER_DRAM_ADDR_EN_OFFSET               0x3c14
#define MPFS_DDR_CSR_APB_CFG_GEARDOWN_MODE_OFFSET                  0x3c18
#define MPFS_DDR_CSR_APB_CFG_WR_PREAMBLE_OFFSET                    0x3c1c
#define MPFS_DDR_CSR_APB_CFG_RD_PREAMBLE_OFFSET                    0x3c20
#define MPFS_DDR_CSR_APB_CFG_RD_PREAMB_TRN_MODE_OFFSET             0x3c24
#define MPFS_DDR_CSR_APB_CFG_SR_ABORT_OFFSET                       0x3c28
#define MPFS_DDR_CSR_APB_CFG_CS_TO_CMDADDR_LATENCY_OFFSET          0x3c2c
#define MPFS_DDR_CSR_APB_CFG_INT_VREF_MON_OFFSET                   0x3c30
#define MPFS_DDR_CSR_APB_CFG_TEMP_CTRL_REF_MODE_OFFSET             0x3c34
#define MPFS_DDR_CSR_APB_CFG_TEMP_CTRL_REF_RANGE_OFFSET            0x3c38
#define MPFS_DDR_CSR_APB_CFG_MAX_PWR_DOWN_MODE_OFFSET              0x3c3c
#define MPFS_DDR_CSR_APB_CFG_READ_DBI_OFFSET                       0x3c40
#define MPFS_DDR_CSR_APB_CFG_WRITE_DBI_OFFSET                      0x3c44
#define MPFS_DDR_CSR_APB_CFG_DATA_MASK_OFFSET                      0x3c48
#define MPFS_DDR_CSR_APB_CFG_CA_PARITY_PERSIST_ERR_OFFSET          0x3c4c
#define MPFS_DDR_CSR_APB_CFG_RTT_PARK_OFFSET                       0x3c50
#define MPFS_DDR_CSR_APB_CFG_ODT_INBUF_4_PD_OFFSET                 0x3c54
#define MPFS_DDR_CSR_APB_CFG_CA_PARITY_ERR_STATUS_OFFSET           0x3c58
#define MPFS_DDR_CSR_APB_CFG_CRC_ERROR_CLEAR_OFFSET                0x3c5c
#define MPFS_DDR_CSR_APB_CFG_CA_PARITY_LATENCY_OFFSET              0x3c60
#define MPFS_DDR_CSR_APB_CFG_CCD_S_OFFSET                          0x3c64
#define MPFS_DDR_CSR_APB_CFG_CCD_L_OFFSET                          0x3c68
#define MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_ENABLE_OFFSET              0x3c6c
#define MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_RANGE_OFFSET               0x3c70
#define MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_VALUE_OFFSET               0x3c74
#define MPFS_DDR_CSR_APB_CFG_RRD_S_OFFSET                          0x3c78
#define MPFS_DDR_CSR_APB_CFG_RRD_L_OFFSET                          0x3c7c
#define MPFS_DDR_CSR_APB_CFG_WTR_S_OFFSET                          0x3c80
#define MPFS_DDR_CSR_APB_CFG_WTR_L_OFFSET                          0x3c84
#define MPFS_DDR_CSR_APB_CFG_WTR_S_CRC_DM_OFFSET                   0x3c88
#define MPFS_DDR_CSR_APB_CFG_WTR_L_CRC_DM_OFFSET                   0x3c8c
#define MPFS_DDR_CSR_APB_CFG_WR_CRC_DM_OFFSET                      0x3c90
#define MPFS_DDR_CSR_APB_CFG_RFC1_OFFSET                           0x3c94
#define MPFS_DDR_CSR_APB_CFG_RFC2_OFFSET                           0x3c98
#define MPFS_DDR_CSR_APB_CFG_RFC4_OFFSET                           0x3c9c
#define MPFS_DDR_CSR_APB_CFG_UNUSED_SPACE0                         0x3ca0
#define MPFS_DDR_CSR_APB_CFG_NIBBLE_DEVICES_OFFSET                 0x3cc4
#define MPFS_DDR_CSR_APB_CFG_UNUSED_SPACE1                         0x3cc8
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS0_0_OFFSET            0x3ce0
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS0_1_OFFSET            0x3ce4
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS1_0_OFFSET            0x3ce8
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS1_1_OFFSET            0x3cec
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS2_0_OFFSET            0x3cf0
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS2_1_OFFSET            0x3cf4
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS3_0_OFFSET            0x3cf8
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS3_1_OFFSET            0x3cfc
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS4_0_OFFSET            0x3d00
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS4_1_OFFSET            0x3d04
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS5_0_OFFSET            0x3d08
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS5_1_OFFSET            0x3d0c
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS6_0_OFFSET            0x3d10
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS6_1_OFFSET            0x3d14
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS7_0_OFFSET            0x3d18
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS7_1_OFFSET            0x3d1c
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS8_0_OFFSET            0x3d20
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS8_1_OFFSET            0x3d24
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS9_0_OFFSET            0x3d28
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS9_1_OFFSET            0x3d2c
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS10_0_OFFSET           0x3d30
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS10_1_OFFSET           0x3d34
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS11_0_OFFSET           0x3d38
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS11_1_OFFSET           0x3d3c
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS12_0_OFFSET           0x3d40
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS12_1_OFFSET           0x3d44
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS13_0_OFFSET           0x3d48
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS13_1_OFFSET           0x3d4c
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS14_0_OFFSET           0x3d50
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS14_1_OFFSET           0x3d54
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS15_0_OFFSET           0x3d58
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS15_1_OFFSET           0x3d5c
#define MPFS_DDR_CSR_APB_CFG_NUM_LOGICAL_RANKS_PER_3DS_OFFSET      0x3d60
#define MPFS_DDR_CSR_APB_CFG_RFC_DLR1_OFFSET                       0x3d64
#define MPFS_DDR_CSR_APB_CFG_RFC_DLR2_OFFSET                       0x3d68
#define MPFS_DDR_CSR_APB_CFG_RFC_DLR4_OFFSET                       0x3d6c
#define MPFS_DDR_CSR_APB_CFG_RRD_DLR_OFFSET                        0x3d70
#define MPFS_DDR_CSR_APB_CFG_FAW_DLR_OFFSET                        0x3d74
#define MPFS_DDR_CSR_APB_CFG_ADVANCE_ACTIVATE_READY_OFFSET         0x3d98
#define MPFS_DDR_CSR_APB_CTRLR_SOFT_RESET_N_OFFSET                 0x4000
#define MPFS_DDR_CSR_APB_CFG_LOOKAHEAD_PCH_OFFSET                  0x4008
#define MPFS_DDR_CSR_APB_CFG_LOOKAHEAD_ACT_OFFSET                  0x400c
#define MPFS_DDR_CSR_APB_INIT_AUTOINIT_DISABLE_OFFSET              0x4010
#define MPFS_DDR_CSR_APB_INIT_FORCE_RESET_OFFSET                   0x4014
#define MPFS_DDR_CSR_APB_INIT_GEARDOWN_EN_OFFSET                   0x4018
#define MPFS_DDR_CSR_APB_INIT_DISABLE_CKE_OFFSET                   0x401c
#define MPFS_DDR_CSR_APB_INIT_CS_OFFSET                            0x4020
#define MPFS_DDR_CSR_APB_INIT_PRECHARGE_ALL_OFFSET                 0x4024
#define MPFS_DDR_CSR_APB_INIT_REFRESH_OFFSET                       0x4028
#define MPFS_DDR_CSR_APB_INIT_ZQ_CAL_REQ_OFFSET                    0x402c
#define MPFS_DDR_CSR_APB_INIT_ACK_OFFSET                           0x4030
#define MPFS_DDR_CSR_APB_CFG_BL_OFFSET                             0x4034
#define MPFS_DDR_CSR_APB_CTRLR_INIT_OFFSET                         0x4038
#define MPFS_DDR_CSR_APB_CTRLR_INIT_DONE_OFFSET                    0x403c
#define MPFS_DDR_CSR_APB_CFG_AUTO_REF_EN_OFFSET                    0x4040
#define MPFS_DDR_CSR_APB_CFG_RAS_OFFSET                            0x4044
#define MPFS_DDR_CSR_APB_CFG_RCD_OFFSET                            0x4048
#define MPFS_DDR_CSR_APB_CFG_RRD_OFFSET                            0x404c
#define MPFS_DDR_CSR_APB_CFG_RP_OFFSET                             0x4050
#define MPFS_DDR_CSR_APB_CFG_RC_OFFSET                             0x4054
#define MPFS_DDR_CSR_APB_CFG_FAW_OFFSET                            0x4058
#define MPFS_DDR_CSR_APB_CFG_RFC_OFFSET                            0x405c
#define MPFS_DDR_CSR_APB_CFG_RTP_OFFSET                            0x4060
#define MPFS_DDR_CSR_APB_CFG_WR_OFFSET                             0x4064
#define MPFS_DDR_CSR_APB_CFG_WTR_OFFSET                            0x4068
#define MPFS_DDR_CSR_APB_CFG_PASR_OFFSET                           0x4070
#define MPFS_DDR_CSR_APB_CFG_XP_OFFSET                             0x4074
#define MPFS_DDR_CSR_APB_CFG_XSR_OFFSET                            0x4078
#define MPFS_DDR_CSR_APB_CFG_CL_OFFSET                             0x4080
#define MPFS_DDR_CSR_APB_CFG_READ_TO_WRITE_OFFSET                  0x4088
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_WRITE_OFFSET                 0x408c
#define MPFS_DDR_CSR_APB_CFG_READ_TO_READ_OFFSET                   0x4090
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_READ_OFFSET                  0x4094
#define MPFS_DDR_CSR_APB_CFG_READ_TO_WRITE_ODT_OFFSET              0x4098
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_WRITE_ODT_OFFSET             0x409c
#define MPFS_DDR_CSR_APB_CFG_READ_TO_READ_ODT_OFFSET               0x40a0
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_READ_ODT_OFFSET              0x40a4
#define MPFS_DDR_CSR_APB_CFG_MIN_READ_IDLE_OFFSET                  0x40a8
#define MPFS_DDR_CSR_APB_CFG_MRD_OFFSET                            0x40ac
#define MPFS_DDR_CSR_APB_CFG_BT_OFFSET                             0x40b0
#define MPFS_DDR_CSR_APB_CFG_DS_OFFSET                             0x40b4
#define MPFS_DDR_CSR_APB_CFG_QOFF_OFFSET                           0x40b8
#define MPFS_DDR_CSR_APB_CFG_RTT_OFFSET                            0x40c4
#define MPFS_DDR_CSR_APB_CFG_DLL_DISABLE_OFFSET                    0x40c8
#define MPFS_DDR_CSR_APB_CFG_REF_PER_OFFSET                        0x40cc
#define MPFS_DDR_CSR_APB_CFG_STARTUP_DELAY_OFFSET                  0x40d0
#define MPFS_DDR_CSR_APB_CFG_MEM_COLBITS_OFFSET                    0x40d4
#define MPFS_DDR_CSR_APB_CFG_MEM_ROWBITS_OFFSET                    0x40d8
#define MPFS_DDR_CSR_APB_CFG_MEM_BANKBITS_OFFSET                   0x40dc
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS0_OFFSET                 0x40e0
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS1_OFFSET                 0x40e4
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS2_OFFSET                 0x40e8
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS3_OFFSET                 0x40ec
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS4_OFFSET                 0x40f0
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS5_OFFSET                 0x40f4
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS6_OFFSET                 0x40f8
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS7_OFFSET                 0x40fc
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS0_OFFSET                 0x4120
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS1_OFFSET                 0x4124
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS2_OFFSET                 0x4128
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS3_OFFSET                 0x412c
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS4_OFFSET                 0x4130
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS5_OFFSET                 0x4134
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS6_OFFSET                 0x4138
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS7_OFFSET                 0x413c
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_TURN_ON_OFFSET                 0x4160
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_TURN_ON_OFFSET                 0x4164
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_TURN_OFF_OFFSET                0x4168
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_TURN_OFF_OFFSET                0x416c
#define MPFS_DDR_CSR_APB_CFG_EMR3_OFFSET                           0x4178
#define MPFS_DDR_CSR_APB_CFG_TWO_T_OFFSET                          0x417c
#define MPFS_DDR_CSR_APB_CFG_TWO_T_SEL_CYCLE_OFFSET                0x4180
#define MPFS_DDR_CSR_APB_CFG_REGDIMM_OFFSET                        0x4184
#define MPFS_DDR_CSR_APB_CFG_MOD_OFFSET                            0x4188
#define MPFS_DDR_CSR_APB_CFG_XS_OFFSET                             0x418c
#define MPFS_DDR_CSR_APB_CFG_XSDLL_OFFSET                          0x4190
#define MPFS_DDR_CSR_APB_CFG_XPR_OFFSET                            0x4194
#define MPFS_DDR_CSR_APB_CFG_AL_MODE_OFFSET                        0x4198
#define MPFS_DDR_CSR_APB_CFG_CWL_OFFSET                            0x419c
#define MPFS_DDR_CSR_APB_CFG_BL_MODE_OFFSET                        0x41a0
#define MPFS_DDR_CSR_APB_CFG_TDQS_OFFSET                           0x41a4
#define MPFS_DDR_CSR_APB_CFG_RTT_WR_OFFSET                         0x41a8
#define MPFS_DDR_CSR_APB_CFG_LP_ASR_OFFSET                         0x41ac
#define MPFS_DDR_CSR_APB_CFG_AUTO_SR_OFFSET                        0x41b0
#define MPFS_DDR_CSR_APB_CFG_SRT_OFFSET                            0x41b4
#define MPFS_DDR_CSR_APB_CFG_ADDR_MIRROR_OFFSET                    0x41b8
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_TYPE_OFFSET                    0x41bc
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_PER_OFFSET                     0x41c0
#define MPFS_DDR_CSR_APB_CFG_AUTO_ZQ_CAL_EN_OFFSET                 0x41c4
#define MPFS_DDR_CSR_APB_CFG_MEMORY_TYPE_OFFSET                    0x41c8
#define MPFS_DDR_CSR_APB_CFG_ONLY_SRANK_CMDS_OFFSET                0x41cc
#define MPFS_DDR_CSR_APB_CFG_NUM_RANKS_OFFSET                      0x41d0
#define MPFS_DDR_CSR_APB_CFG_QUAD_RANK_OFFSET                      0x41d4
#define MPFS_DDR_CSR_APB_CFG_EARLY_RANK_TO_WR_START_OFFSET         0x41dc
#define MPFS_DDR_CSR_APB_CFG_EARLY_RANK_TO_RD_START_OFFSET         0x41e0
#define MPFS_DDR_CSR_APB_CFG_PASR_BANK_OFFSET                      0x41e4
#define MPFS_DDR_CSR_APB_CFG_PASR_SEG_OFFSET                       0x41e8
#define MPFS_DDR_CSR_APB_INIT_MRR_MODE_OFFSET                      0x41ec
#define MPFS_DDR_CSR_APB_INIT_MR_W_REQ_OFFSET                      0x41f0
#define MPFS_DDR_CSR_APB_INIT_MR_ADDR_OFFSET                       0x41f4
#define MPFS_DDR_CSR_APB_INIT_MR_WR_DATA_OFFSET                    0x41f8
#define MPFS_DDR_CSR_APB_INIT_MR_WR_MASK_OFFSET                    0x41fc
#define MPFS_DDR_CSR_APB_INIT_NOP_OFFSET                           0x4200
#define MPFS_DDR_CSR_APB_CFG_INIT_DURATION_OFFSET                  0x4204
#define MPFS_DDR_CSR_APB_CFG_ZQINIT_CAL_DURATION_OFFSET            0x4208
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_L_DURATION_OFFSET              0x420c
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_S_DURATION_OFFSET              0x4210
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_R_DURATION_OFFSET              0x4214
#define MPFS_DDR_CSR_APB_CFG_MRR_OFFSET                            0x4218
#define MPFS_DDR_CSR_APB_CFG_MRW_OFFSET                            0x421c
#define MPFS_DDR_CSR_APB_CFG_ODT_POWERDOWN_OFFSET                  0x4220
#define MPFS_DDR_CSR_APB_CFG_WL_OFFSET                             0x4224
#define MPFS_DDR_CSR_APB_CFG_RL_OFFSET                             0x4228
#define MPFS_DDR_CSR_APB_CFG_CAL_READ_PERIOD_OFFSET                0x422c
#define MPFS_DDR_CSR_APB_CFG_NUM_CAL_READS_OFFSET                  0x4230
#define MPFS_DDR_CSR_APB_INIT_SELF_REFRESH_OFFSET                  0x4234
#define MPFS_DDR_CSR_APB_INIT_SELF_REFRESH_STATUS_OFFSET           0x4238
#define MPFS_DDR_CSR_APB_INIT_POWER_DOWN_OFFSET                    0x423c
#define MPFS_DDR_CSR_APB_INIT_POWER_DOWN_STATUS_OFFSET             0x4240
#define MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_OFFSET                   0x4244
#define MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_CS_OFFSET                0x4248
#define MPFS_DDR_CSR_APB_CFG_CTRLR_INIT_DISABLE_OFFSET             0x424c
#define MPFS_DDR_CSR_APB_CTRLR_READY_OFFSET                        0x4250
#define MPFS_DDR_CSR_APB_INIT_RDIMM_READY_OFFSET                   0x4254
#define MPFS_DDR_CSR_APB_INIT_RDIMM_COMPLETE_OFFSET                0x4258
#define MPFS_DDR_CSR_APB_CFG_RDIMM_LAT_OFFSET                      0x425c
#define MPFS_DDR_CSR_APB_CFG_RDIMM_BSIDE_INVERT_OFFSET             0x4260
#define MPFS_DDR_CSR_APB_CFG_LRDIMM_OFFSET                         0x4264
#define MPFS_DDR_CSR_APB_INIT_MEMORY_RESET_MASK_OFFSET             0x4268
#define MPFS_DDR_CSR_APB_CFG_RD_PREAMB_TOGGLE_OFFSET               0x426c
#define MPFS_DDR_CSR_APB_CFG_RD_POSTAMBLE_OFFSET                   0x4270
#define MPFS_DDR_CSR_APB_CFG_PU_CAL_OFFSET                         0x4274
#define MPFS_DDR_CSR_APB_CFG_DQ_ODT_OFFSET                         0x4278
#define MPFS_DDR_CSR_APB_CFG_CA_ODT_OFFSET                         0x427c
#define MPFS_DDR_CSR_APB_CFG_ZQLATCH_DURATION_OFFSET               0x4280
#define MPFS_DDR_CSR_APB_INIT_CAL_SELECT_OFFSET                    0x4284
#define MPFS_DDR_CSR_APB_INIT_CAL_L_R_REQ_OFFSET                   0x4288
#define MPFS_DDR_CSR_APB_INIT_CAL_L_B_SIZE_OFFSET                  0x428c
#define MPFS_DDR_CSR_APB_INIT_CAL_L_R_ACK_OFFSET                   0x4290
#define MPFS_DDR_CSR_APB_INIT_CAL_L_READ_COMPLETE_OFFSET           0x4294
#define MPFS_DDR_CSR_APB_INIT_RWFIFO_OFFSET                        0x42a0
#define MPFS_DDR_CSR_APB_INIT_RD_DQCAL_OFFSET                      0x42a4
#define MPFS_DDR_CSR_APB_INIT_START_DQSOSC_OFFSET                  0x42a8
#define MPFS_DDR_CSR_APB_INIT_STOP_DQSOSC_OFFSET                   0x42ac
#define MPFS_DDR_CSR_APB_INIT_ZQ_CAL_START_OFFSET                  0x42b0
#define MPFS_DDR_CSR_APB_CFG_WR_POSTAMBLE_OFFSET                   0x42b4
#define MPFS_DDR_CSR_APB_INIT_CAL_L_ADDR_0_OFFSET                  0x42b8
#define MPFS_DDR_CSR_APB_INIT_CAL_L_ADDR_1_OFFSET                  0x42bc
#define MPFS_DDR_CSR_APB_CFG_CTRLUPD_TRIG_OFFSET                   0x42c0
#define MPFS_DDR_CSR_APB_CFG_CTRLUPD_START_DELAY_OFFSET            0x42c4
#define MPFS_DDR_CSR_APB_CFG_DFI_T_CTRLUPD_MAX_OFFSET              0x42c8
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_SEL_OFFSET                 0x42d0
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_VALUE_OFFSET               0x42d4
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_TURN_OFF_DELAY_OFFSET      0x42d8
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_SLOW_RESTART_WINDOW_OFFSET 0x42dc
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_RESTART_HOLDOFF_OFFSET     0x42e0
#define MPFS_DDR_CSR_APB_CFG_PARITY_RDIMM_DELAY_OFFSET             0x42e4
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_ENABLE_OFFSET              0x42e8
#define MPFS_DDR_CSR_APB_CFG_ASYNC_ODT_OFFSET                      0x42ec
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_DURATION_OFFSET                0x42f0
#define MPFS_DDR_CSR_APB_CFG_MRRI_OFFSET                           0x42f4
#define MPFS_DDR_CSR_APB_INIT_ODT_FORCE_EN_OFFSET                  0x42f8
#define MPFS_DDR_CSR_APB_INIT_ODT_FORCE_RANK_OFFSET                0x42fc
#define MPFS_DDR_CSR_APB_CFG_PHYUPD_ACK_DELAY_OFFSET               0x4300
#define MPFS_DDR_CSR_APB_CFG_MIRROR_X16_BG0_BG1_OFFSET             0x4304
#define MPFS_DDR_CSR_APB_INIT_PDA_MR_W_REQ_OFFSET                  0x4308
#define MPFS_DDR_CSR_APB_INIT_PDA_NIBBLE_SELECT_OFFSET             0x430c
#define MPFS_DDR_CSR_APB_CFG_DRAM_CLK_DISABLE_IN_SELF_REFRESH_OFFSET 0x4310
#define MPFS_DDR_CSR_APB_CFG_CKSRE_OFFSET                          0x4314
#define MPFS_DDR_CSR_APB_CFG_CKSRX_OFFSET                          0x4318
#define MPFS_DDR_CSR_APB_CFG_RCD_STAB_OFFSET                       0x431c
#define MPFS_DDR_CSR_APB_CFG_DFI_T_CTRL_DELAY_OFFSET               0x4320
#define MPFS_DDR_CSR_APB_CFG_DFI_T_DRAM_CLK_ENABLE_OFFSET          0x4324
#define MPFS_DDR_CSR_APB_CFG_IDLE_TIME_TO_SELF_REFRESH_OFFSET      0x4328
#define MPFS_DDR_CSR_APB_CFG_IDLE_TIME_TO_POWER_DOWN_OFFSET        0x432c
#define MPFS_DDR_CSR_APB_CFG_BURST_RW_REFRESH_HOLDOFF_OFFSET       0x4330
#define MPFS_DDR_CSR_APB_INIT_REFRESH_COUNT_OFFSET                 0x4334
#define MPFS_DDR_CSR_APB_CFG_BG_INTERLEAVE_OFFSET                  0x4384
#define MPFS_DDR_CSR_APB_CFG_REFRESH_DURING_PHY_TRAINING_OFFSET    0x43fc
#define MPFS_DDR_CSR_APB_MT_EN_OFFSET                              0x4400
#define MPFS_DDR_CSR_APB_MT_EN_SINGLE_OFFSET                       0x4404
#define MPFS_DDR_CSR_APB_MT_STOP_ON_ERROR_OFFSET                   0x4408
#define MPFS_DDR_CSR_APB_MT_RD_ONLY_OFFSET                         0x440c
#define MPFS_DDR_CSR_APB_MT_WR_ONLY_OFFSET                         0x4410
#define MPFS_DDR_CSR_APB_MT_DATA_PATTERN_OFFSET                    0x4414
#define MPFS_DDR_CSR_APB_MT_ADDR_PATTERN_OFFSET                    0x4418
#define MPFS_DDR_CSR_APB_MT_DATA_INVERT_OFFSET                     0x441c
#define MPFS_DDR_CSR_APB_MT_ADDR_BITS_OFFSET                       0x4420
#define MPFS_DDR_CSR_APB_MT_ERROR_STS_OFFSET                       0x4424
#define MPFS_DDR_CSR_APB_MT_DONE_ACK_OFFSET                        0x4428
#define MPFS_DDR_CSR_APB_MT_START_ADDR_0_OFFSET                    0x44b4
#define MPFS_DDR_CSR_APB_MT_START_ADDR_1_OFFSET                    0x44b8
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_0_OFFSET                    0x44bc
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_1_OFFSET                    0x44c0
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_2_OFFSET                    0x44c4
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_3_OFFSET                    0x44c8
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_4_OFFSET                    0x44cc
#define MPFS_DDR_CSR_APB_MT_USER_DATA_PATTERN_OFFSET               0x4670
#define MPFS_DDR_CSR_APB_MT_ALG_AUTO_PCH_OFFSET                    0x467c
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P0_OFFSET              0x4c00
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P1_OFFSET              0x4c04
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P2_OFFSET              0x4c08
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P3_OFFSET              0x4c0c
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P4_OFFSET              0x4c10
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P5_OFFSET              0x4c14
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P6_OFFSET              0x4c18
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P7_OFFSET              0x4c1c

#define MPFS_DDR_CSR_APB_CFG_REORDER_EN_OFFSET                     0x5000
#define MPFS_DDR_CSR_APB_CFG_REORDER_QUEUE_EN_OFFSET               0x5004
#define MPFS_DDR_CSR_APB_CFG_INTRAPORT_REORDER_EN_OFFSET           0x5008
#define MPFS_DDR_CSR_APB_CFG_MAINTAIN_COHERENCY_OFFSET             0x500c
#define MPFS_DDR_CSR_APB_CFG_Q_AGE_LIMIT_OFFSET                    0x5010
#define MPFS_DDR_CSR_APB_CFG_RO_CLOSED_PAGE_POLICY_OFFSET          0x5018
#define MPFS_DDR_CSR_APB_CFG_REORDER_RW_ONLY_OFFSET                0x501c
#define MPFS_DDR_CSR_APB_CFG_RO_PRIORITY_EN_OFFSET                 0x5020
#define MPFS_DDR_CSR_APB_CFG_DM_EN_OFFSET                          0x5400
#define MPFS_DDR_CSR_APB_CFG_RMW_EN_OFFSET                         0x5404
#define MPFS_DDR_CSR_APB_CFG_ECC_CORRECTION_EN_OFFSET              0x5800
#define MPFS_DDR_CSR_APB_CFG_ECC_BYPASS_OFFSET                     0x5840
#define MPFS_DDR_CSR_APB_INIT_WRITE_DATA_1B_ECC_ERROR_GEN_OFFSET   0x5844
#define MPFS_DDR_CSR_APB_INIT_WRITE_DATA_2B_ECC_ERROR_GEN_OFFSET   0x5848
#define MPFS_DDR_CSR_APB_CFG_ECC_1BIT_INT_THRESH_OFFSET            0x585c
#define MPFS_DDR_CSR_APB_STAT_INT_ECC_1BIT_THRESH_OFFSET           0x5860
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_ADDR_OFFSET             0x5c00
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_0_OFFSET           0x5c04
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_1_OFFSET           0x5c08
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_2_OFFSET           0x5c0c
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_3_OFFSET           0x5c10
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_4_OFFSET           0x5c14
#define MPFS_DDR_CSR_APB_CFG_ERROR_GROUP_SEL_OFFSET                0x6400
#define MPFS_DDR_CSR_APB_CFG_DATA_SEL_OFFSET                       0x6404
#define MPFS_DDR_CSR_APB_CFG_TRIG_MODE_OFFSET                      0x6408
#define MPFS_DDR_CSR_APB_CFG_POST_TRIG_CYCS_OFFSET                 0x640c
#define MPFS_DDR_CSR_APB_CFG_TRIG_MASK_OFFSET                      0x6410
#define MPFS_DDR_CSR_APB_CFG_EN_MASK_OFFSET                        0x6414
#define MPFS_DDR_CSR_APB_MTC_ACQ_ADDR_OFFSET                       0x6418
#define MPFS_DDR_CSR_APB_MTC_ACQ_CYCS_STORED_OFFSET                0x641c
#define MPFS_DDR_CSR_APB_MTC_ACQ_TRIG_DETECT_OFFSET                0x6420
#define MPFS_DDR_CSR_APB_MTC_ACQ_MEM_TRIG_ADDR_OFFSET              0x6424
#define MPFS_DDR_CSR_APB_MTC_ACQ_MEM_LAST_ADDR_OFFSET              0x6428
#define MPFS_DDR_CSR_APB_MTC_ACK_OFFSET                            0x642c
#define MPFS_DDR_CSR_APB_CFG_TRIG_MT_ADDR_0_OFFSET                 0x6430
#define MPFS_DDR_CSR_APB_CFG_TRIG_MT_ADDR_1_OFFSET                 0x6434
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_0_OFFSET                0x6438
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_1_OFFSET                0x643c
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_2_OFFSET                0x6440
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_3_OFFSET                0x6444
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_4_OFFSET                0x6448
#define MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_0_OFFSET                  0x644c
#define MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_1_OFFSET                  0x6450
#define MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_2_OFFSET                  0x6454
#define MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_0_OFFSET                  0x6458
#define MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_1_OFFSET                  0x645c
#define MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_2_OFFSET                  0x6460
#define MPFS_DDR_CSR_APB_CFG_PRE_TRIG_CYCS_OFFSET                  0x652c
#define MPFS_DDR_CSR_APB_MTC_ACQ_ERROR_CNT_OFFSET                  0x6538
#define MPFS_DDR_CSR_APB_MTC_ACQ_ERROR_CNT_OVFL_OFFSET             0x6544
#define MPFS_DDR_CSR_APB_CFG_DATA_SEL_FIRST_ERROR_OFFSET           0x6550
#define MPFS_DDR_CSR_APB_CFG_DQ_WIDTH_OFFSET                       0x7c00
#define MPFS_DDR_CSR_APB_CFG_ACTIVE_DQ_SEL_OFFSET                  0x7c04

#define MPFS_DDR_CSR_APB_STAT_CA_PARITY_ERROR_OFFSET               0x8000
#define MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_REQ_OFFSET       0x800c
#define MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_CMD_OFFSET       0x8010
#define MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_ACK_OFFSET       0x8014

#define MPFS_DDR_CSR_APB_CFG_DFI_T_RDDATA_EN_OFFSET                0x10000
#define MPFS_DDR_CSR_APB_CFG_DFI_T_PHY_RDLAT_OFFSET                0x10004
#define MPFS_DDR_CSR_APB_CFG_DFI_T_PHY_WRLAT_OFFSET                0x10008
#define MPFS_DDR_CSR_APB_CFG_DFI_PHYUPD_EN_OFFSET                  0x1000c
#define MPFS_DDR_CSR_APB_INIT_DFI_LP_DATA_REQ_OFFSET               0x10010
#define MPFS_DDR_CSR_APB_INIT_DFI_LP_CTRL_REQ_OFFSET               0x10014
#define MPFS_DDR_CSR_APB_STAT_DFI_LP_ACK_OFFSET                    0x10018
#define MPFS_DDR_CSR_APB_INIT_DFI_LP_WAKEUP_OFFSET                 0x1001c
#define MPFS_DDR_CSR_APB_INIT_DFI_DRAM_CLK_DISABLE_OFFSET          0x10020
#define MPFS_DDR_CSR_APB_STAT_DFI_TRAINING_ERROR_OFFSET            0x10024
#define MPFS_DDR_CSR_APB_STAT_DFI_ERROR_OFFSET                     0x10028
#define MPFS_DDR_CSR_APB_STAT_DFI_ERROR_INFO_OFFSET                0x1002c
#define MPFS_DDR_CSR_APB_CFG_DFI_DATA_BYTE_DISABLE_OFFSET          0x10030
#define MPFS_DDR_CSR_APB_STAT_DFI_INIT_COMPLETE_OFFSET             0x10034
#define MPFS_DDR_CSR_APB_STAT_DFI_TRAINING_COMPLETE_OFFSET         0x10038
#define MPFS_DDR_CSR_APB_CFG_DFI_LVL_SEL_OFFSET                    0x1003c
#define MPFS_DDR_CSR_APB_CFG_DFI_LVL_PERIODIC_OFFSET               0x10040
#define MPFS_DDR_CSR_APB_CFG_DFI_LVL_PATTERN_OFFSET                0x10044
#define MPFS_DDR_CSR_APB_PHY_DFI_INIT_START_OFFSET                 0x10050

#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI1_0_OFFSET       0x12c18
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI1_1_OFFSET       0x12c1c
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI2_0_OFFSET       0x12c20
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI2_1_OFFSET       0x12c24
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI1_0_OFFSET         0x12f18
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI1_1_OFFSET         0x12f1c
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI2_0_OFFSET         0x12f20
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI2_1_OFFSET         0x12f24

#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI1_0_OFFSET       0x13218
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI1_1_OFFSET       0x1321c
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI2_0_OFFSET       0x13220
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI2_1_OFFSET       0x13224
#define MPFS_DDR_CSR_APB_CFG_ENABLE_BUS_HOLD_AXI1_OFFSET           0x13514
#define MPFS_DDR_CSR_APB_CFG_ENABLE_BUS_HOLD_AXI2_OFFSET           0x13518
#define MPFS_DDR_CSR_APB_CFG_AXI_AUTO_PCH_OFFSET                   0x13690

#define MPFS_DDR_CSR_APB_PHY_RESET_CONTROL_OFFSET                  0x3c000
#define MPFS_DDR_CSR_APB_PHY_PC_RANK_OFFSET                        0x3c004
#define MPFS_DDR_CSR_APB_PHY_RANKS_TO_TRAIN_OFFSET                 0x3c008
#define MPFS_DDR_CSR_APB_PHY_WRITE_REQUEST_OFFSET                  0x3c00c
#define MPFS_DDR_CSR_APB_PHY_WRITE_REQUEST_DONE_OFFSET             0x3c010
#define MPFS_DDR_CSR_APB_PHY_READ_REQUEST_OFFSET                   0x3c014
#define MPFS_DDR_CSR_APB_PHY_READ_REQUEST_DONE_OFFSET              0x3c018
#define MPFS_DDR_CSR_APB_PHY_WRITE_LEVEL_DELAY_OFFSET              0x3c01c
#define MPFS_DDR_CSR_APB_PHY_GATE_TRAIN_DELAY_OFFSET               0x3c020
#define MPFS_DDR_CSR_APB_PHY_EYE_TRAIN_DELAY_OFFSET                0x3c024
#define MPFS_DDR_CSR_APB_PHY_EYE_PAT_OFFSET                        0x3c028
#define MPFS_DDR_CSR_APB_PHY_START_RECAL_OFFSET                    0x3c02c
#define MPFS_DDR_CSR_APB_PHY_CLR_DFI_LVL_PERIODIC_OFFSET           0x3c030
#define MPFS_DDR_CSR_APB_PHY_TRAIN_STEP_ENABLE_OFFSET              0x3c034
#define MPFS_DDR_CSR_APB_PHY_LPDDR_DQ_CAL_PAT_OFFSET               0x3c038
#define MPFS_DDR_CSR_APB_PHY_INDPNDT_TRAINING_OFFSET               0x3c03c
#define MPFS_DDR_CSR_APB_PHY_ENCODED_QUAD_CS_OFFSET                0x3c040
#define MPFS_DDR_CSR_APB_PHY_HALF_CLK_DLY_ENABLE_OFFSET            0x3c044

/* DDR configuration registers */

#define MPFS_DDR_CSR_APB_CTRLR_INIT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CTRLR_INIT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MANUAL_ADDRESS_MAP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MANUAL_ADDRESS_MAP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CHIPADDR_MAP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CHIPADDR_MAP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CIDADDR_MAP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CIDADDR_MAP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MB_AUTOPCH_COL_BIT_POS_LOW (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MB_AUTOPCH_COL_BIT_POS_LOW_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MB_AUTOPCH_COL_BIT_POS_HIGH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MB_AUTOPCH_COL_BIT_POS_HIGH_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BANKADDR_MAP_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BANKADDR_MAP_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BANKADDR_MAP_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BANKADDR_MAP_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ROWADDR_MAP_3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_COLADDR_MAP_3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_VRCG_ENABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_VRCG_ENABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_VRCG_DISABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_VRCG_DISABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_LATENCY_SET (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_LATENCY_SET_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_THERMAL_OFFSET (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_THERMAL_OFFSET_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_SOC_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_SOC_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODTE_CK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODTE_CK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODTE_CS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODTE_CS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODTD_CA (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODTD_CA_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_LPDDR4_FSP_OP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_LPDDR4_FSP_OP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_GENERATE_REFRESH_ON_SRX (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_GENERATE_REFRESH_ON_SRX_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DBI_CL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DBI_CL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_NON_DBI_CL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_NON_DBI_CL_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_DATA_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_DATA_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_CRC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_CRC_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MPR_READ_FORMAT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MPR_READ_FORMAT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WR_CMD_LAT_CRC_DM (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WR_CMD_LAT_CRC_DM_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_FINE_GRAN_REF_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_FINE_GRAN_REF_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TEMP_SENSOR_READOUT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TEMP_SENSOR_READOUT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PER_DRAM_ADDR_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PER_DRAM_ADDR_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_GEARDOWN_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_GEARDOWN_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WR_PREAMBLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WR_PREAMBLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RD_PREAMBLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RD_PREAMBLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RD_PREAMB_TRN_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RD_PREAMB_TRN_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_SR_ABORT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_SR_ABORT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CS_TO_CMDADDR_LATENCY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CS_TO_CMDADDR_LATENCY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_INT_VREF_MON (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_INT_VREF_MON_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TEMP_CTRL_REF_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TEMP_CTRL_REF_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TEMP_CTRL_REF_RANGE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TEMP_CTRL_REF_RANGE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MAX_PWR_DOWN_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MAX_PWR_DOWN_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_READ_DBI (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_READ_DBI_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_DBI (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_DBI_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DATA_MASK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DATA_MASK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CA_PARITY_PERSIST_ERR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CA_PARITY_PERSIST_ERR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RTT_PARK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RTT_PARK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_INBUF_4_PD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_INBUF_4_PD_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CA_PARITY_ERR_STATUS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CA_PARITY_ERR_STATUS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CRC_ERROR_CLEAR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CRC_ERROR_CLEAR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CA_PARITY_LATENCY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CA_PARITY_LATENCY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CCD_S (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CCD_S_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CCD_L (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CCD_L_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_ENABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_ENABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_RANGE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_RANGE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_VALUE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_VREFDQ_TRN_VALUE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RRD_S (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RRD_S_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RRD_L (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RRD_L_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WTR_S (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WTR_S_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WTR_L (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WTR_L_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WTR_S_CRC_DM (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WTR_S_CRC_DM_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WTR_L_CRC_DM (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WTR_L_CRC_DM_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WR_CRC_DM (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WR_CRC_DM_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC4_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_NIBBLE_DEVICES (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_NIBBLE_DEVICES_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS0_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS0_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS0_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS0_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS1_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS1_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS1_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS1_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS2_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS2_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS2_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS2_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS3_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS3_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS3_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS3_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS4_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS4_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS4_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS4_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS5_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS5_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS5_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS5_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS6_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS6_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS6_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS6_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS7_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS7_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS7_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS7_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS8_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS8_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS8_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS8_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS9_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS9_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS9_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS9_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS10_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS10_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS10_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS10_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS11_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS11_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS11_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS11_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS12_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS12_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS12_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS12_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS13_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS13_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS13_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS13_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS14_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS14_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS14_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS14_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS15_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS15_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS15_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BIT_MAP_INDEX_CS15_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_NUM_LOGICAL_RANKS_PER_3DS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_NUM_LOGICAL_RANKS_PER_3DS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC_DLR1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC_DLR1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC_DLR2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC_DLR2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC_DLR4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC_DLR4_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RRD_DLR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RRD_DLR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_FAW_DLR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_FAW_DLR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ADVANCE_ACTIVATE_READY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ADVANCE_ACTIVATE_READY_OFFSET)
#define MPFS_DDR_CSR_APB_CTRLR_SOFT_RESET_N (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CTRLR_SOFT_RESET_N_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_LOOKAHEAD_PCH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_LOOKAHEAD_PCH_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_LOOKAHEAD_ACT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_LOOKAHEAD_ACT_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_AUTOINIT_DISABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_AUTOINIT_DISABLE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_FORCE_RESET (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_FORCE_RESET_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_GEARDOWN_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_GEARDOWN_EN_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_DISABLE_CKE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_DISABLE_CKE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CS_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_PRECHARGE_ALL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_PRECHARGE_ALL_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_REFRESH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_REFRESH_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_ZQ_CAL_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_ZQ_CAL_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_ACK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_ACK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BL_OFFSET)
#define MPFS_DDR_CSR_APB_CTRLR_INIT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CTRLR_INIT_OFFSET)
#define MPFS_DDR_CSR_APB_CTRLR_INIT_DONE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CTRLR_INIT_DONE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AUTO_REF_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AUTO_REF_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RAS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RAS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RCD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RCD_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RRD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RRD_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RC_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_FAW (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_FAW_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RFC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RFC_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RTP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RTP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WTR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WTR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PASR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PASR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_XP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_XP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_XSR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_XSR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_READ_TO_WRITE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_READ_TO_WRITE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_WRITE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_TO_WRITE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_READ_TO_READ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_READ_TO_READ_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_READ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_TO_READ_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_READ_TO_WRITE_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_READ_TO_WRITE_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_WRITE_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_TO_WRITE_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_READ_TO_READ_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_READ_TO_READ_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WRITE_TO_READ_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WRITE_TO_READ_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MIN_READ_IDLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MIN_READ_IDLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MRD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MRD_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_QOFF (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_QOFF_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RTT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RTT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DLL_DISABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DLL_DISABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_REF_PER (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_REF_PER_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARTUP_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARTUP_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_COLBITS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_COLBITS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_ROWBITS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_ROWBITS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_BANKBITS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_BANKBITS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS4_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS5 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS5_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS6 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS6_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS7 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_MAP_CS7_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS4_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS5 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS5_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS6 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS6_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS7 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_MAP_CS7_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_TURN_ON (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_TURN_ON_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_TURN_ON (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_TURN_ON_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_RD_TURN_OFF (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_RD_TURN_OFF_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_WR_TURN_OFF (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_WR_TURN_OFF_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_EMR3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_EMR3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TWO_T (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TWO_T_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TWO_T_SEL_CYCLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TWO_T_SEL_CYCLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_REGDIMM (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_REGDIMM_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MOD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MOD_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_XS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_XS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_XSDLL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_XSDLL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_XPR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_XPR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AL_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AL_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CWL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CWL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BL_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BL_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TDQS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TDQS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RTT_WR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RTT_WR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_LP_ASR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_LP_ASR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AUTO_SR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AUTO_SR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_SRT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_SRT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ADDR_MIRROR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ADDR_MIRROR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_TYPE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQ_CAL_TYPE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_PER (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQ_CAL_PER_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AUTO_ZQ_CAL_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AUTO_ZQ_CAL_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEMORY_TYPE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEMORY_TYPE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ONLY_SRANK_CMDS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ONLY_SRANK_CMDS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_NUM_RANKS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_NUM_RANKS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_QUAD_RANK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_QUAD_RANK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_EARLY_RANK_TO_WR_START (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_EARLY_RANK_TO_WR_START_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_EARLY_RANK_TO_RD_START (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_EARLY_RANK_TO_RD_START_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PASR_BANK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PASR_BANK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PASR_SEG (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PASR_SEG_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_MRR_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_MRR_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_MR_W_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_MR_W_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_MR_ADDR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_MR_ADDR_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_MR_WR_DATA (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_MR_WR_DATA_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_MR_WR_MASK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_MR_WR_MASK_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_NOP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_NOP_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_INIT_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_INIT_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQINIT_CAL_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQINIT_CAL_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_L_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQ_CAL_L_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_S_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQ_CAL_S_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_R_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQ_CAL_R_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MRR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MRR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MRW (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MRW_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ODT_POWERDOWN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ODT_POWERDOWN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CAL_READ_PERIOD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CAL_READ_PERIOD_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_NUM_CAL_READS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_NUM_CAL_READS_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_SELF_REFRESH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_SELF_REFRESH_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_SELF_REFRESH_STATUS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_SELF_REFRESH_STATUS_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_POWER_DOWN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_POWER_DOWN_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_POWER_DOWN_STATUS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_POWER_DOWN_STATUS_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_FORCE_WRITE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_CS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_FORCE_WRITE_CS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_INIT_DISABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_INIT_DISABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CTRLR_READY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CTRLR_READY_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_RDIMM_READY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_RDIMM_READY_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_RDIMM_COMPLETE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_RDIMM_COMPLETE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RDIMM_LAT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RDIMM_LAT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RDIMM_BSIDE_INVERT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RDIMM_BSIDE_INVERT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_LRDIMM (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_LRDIMM_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_MEMORY_RESET_MASK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_MEMORY_RESET_MASK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RD_PREAMB_TOGGLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RD_PREAMB_TOGGLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RD_POSTAMBLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RD_POSTAMBLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PU_CAL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PU_CAL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DQ_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DQ_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CA_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CA_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQLATCH_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQLATCH_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_SELECT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_SELECT_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_L_R_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_L_R_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_L_B_SIZE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_L_B_SIZE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_L_R_ACK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_L_R_ACK_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_L_READ_COMPLETE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_L_READ_COMPLETE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_RWFIFO (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_RWFIFO_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_RD_DQCAL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_RD_DQCAL_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_START_DQSOSC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_START_DQSOSC_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_STOP_DQSOSC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_STOP_DQSOSC_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_ZQ_CAL_START (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_ZQ_CAL_START_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_WR_POSTAMBLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_WR_POSTAMBLE_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_L_ADDR_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_L_ADDR_0_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CAL_L_ADDR_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CAL_L_ADDR_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLUPD_TRIG (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLUPD_TRIG_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLUPD_START_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLUPD_START_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_T_CTRLUPD_MAX (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_T_CTRLUPD_MAX_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_SEL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_SEL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_VALUE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_VALUE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_TURN_OFF_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_TURN_OFF_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_SLOW_RESTART_WINDOW (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_SLOW_RESTART_WINDOW_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_RESTART_HOLDOFF (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_RESTART_HOLDOFF_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PARITY_RDIMM_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PARITY_RDIMM_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_ENABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CTRLR_BUSY_ENABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ASYNC_ODT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ASYNC_ODT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ZQ_CAL_DURATION (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ZQ_CAL_DURATION_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MRRI (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MRRI_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_ODT_FORCE_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_ODT_FORCE_EN_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_ODT_FORCE_RANK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_ODT_FORCE_RANK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PHYUPD_ACK_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PHYUPD_ACK_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MIRROR_X16_BG0_BG1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MIRROR_X16_BG0_BG1_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_PDA_MR_W_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_PDA_MR_W_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_PDA_NIBBLE_SELECT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_PDA_NIBBLE_SELECT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DRAM_CLK_DISABLE_IN_SELF_REFRESH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DRAM_CLK_DISABLE_IN_SELF_REFRESH_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CKSRE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CKSRE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_CKSRX (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_CKSRX_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RCD_STAB (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RCD_STAB_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_T_CTRL_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_T_CTRL_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_T_DRAM_CLK_ENABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_T_DRAM_CLK_ENABLE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_IDLE_TIME_TO_SELF_REFRESH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_IDLE_TIME_TO_SELF_REFRESH_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_IDLE_TIME_TO_POWER_DOWN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_IDLE_TIME_TO_POWER_DOWN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BURST_RW_REFRESH_HOLDOFF (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BURST_RW_REFRESH_HOLDOFF_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_REFRESH_COUNT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_REFRESH_COUNT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_BG_INTERLEAVE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_BG_INTERLEAVE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_REFRESH_DURING_PHY_TRAINING (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_REFRESH_DURING_PHY_TRAINING_OFFSET)
#define MPFS_DDR_CSR_APB_MT_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_EN_OFFSET)
#define MPFS_DDR_CSR_APB_MT_EN_SINGLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_EN_SINGLE_OFFSET)
#define MPFS_DDR_CSR_APB_MT_STOP_ON_ERROR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_STOP_ON_ERROR_OFFSET)
#define MPFS_DDR_CSR_APB_MT_RD_ONLY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_RD_ONLY_OFFSET)
#define MPFS_DDR_CSR_APB_MT_WR_ONLY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_WR_ONLY_OFFSET)
#define MPFS_DDR_CSR_APB_MT_DATA_PATTERN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_DATA_PATTERN_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ADDR_PATTERN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ADDR_PATTERN_OFFSET)
#define MPFS_DDR_CSR_APB_MT_DATA_INVERT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_DATA_INVERT_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ADDR_BITS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ADDR_BITS_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ERROR_STS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ERROR_STS_OFFSET)
#define MPFS_DDR_CSR_APB_MT_DONE_ACK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_DONE_ACK_OFFSET)
#define MPFS_DDR_CSR_APB_MT_START_ADDR_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_START_ADDR_0_OFFSET)
#define MPFS_DDR_CSR_APB_MT_START_ADDR_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_START_ADDR_1_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ERROR_MASK_0_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ERROR_MASK_1_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ERROR_MASK_2_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ERROR_MASK_3_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ERROR_MASK_4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ERROR_MASK_4_OFFSET)
#define MPFS_DDR_CSR_APB_MT_USER_DATA_PATTERN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_USER_DATA_PATTERN_OFFSET)
#define MPFS_DDR_CSR_APB_MT_ALG_AUTO_PCH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MT_ALG_AUTO_PCH_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P4_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P5 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P5_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P6 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P6_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P7 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_STARVE_TIMEOUT_P7_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_REORDER_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_REORDER_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_REORDER_QUEUE_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_REORDER_QUEUE_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_INTRAPORT_REORDER_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_INTRAPORT_REORDER_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MAINTAIN_COHERENCY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MAINTAIN_COHERENCY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_Q_AGE_LIMIT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_Q_AGE_LIMIT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RO_CLOSED_PAGE_POLICY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RO_CLOSED_PAGE_POLICY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_REORDER_RW_ONLY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_REORDER_RW_ONLY_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RO_PRIORITY_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RO_PRIORITY_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DM_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DM_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_RMW_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_RMW_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ECC_CORRECTION_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ECC_CORRECTION_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ECC_BYPASS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ECC_BYPASS_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_WRITE_DATA_1B_ECC_ERROR_GEN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_WRITE_DATA_1B_ECC_ERROR_GEN_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_WRITE_DATA_2B_ECC_ERROR_GEN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_WRITE_DATA_2B_ECC_ERROR_GEN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ECC_1BIT_INT_THRESH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ECC_1BIT_INT_THRESH_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_INT_ECC_1BIT_THRESH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_INT_ECC_1BIT_THRESH_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_ADDR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_ADDR_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_0_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_1_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_2_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_3_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_READ_CAPTURE_DATA_4_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ERROR_GROUP_SEL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ERROR_GROUP_SEL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DATA_SEL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DATA_SEL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_MODE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_MODE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_POST_TRIG_CYCS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_POST_TRIG_CYCS_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_MASK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_MASK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_EN_MASK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_EN_MASK_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_ADDR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_ADDR_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_CYCS_STORED (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_CYCS_STORED_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_TRIG_DETECT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_TRIG_DETECT_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_MEM_TRIG_ADDR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_MEM_TRIG_ADDR_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_MEM_LAST_ADDR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_MEM_LAST_ADDR_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_MT_ADDR_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_MT_ADDR_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_MT_ADDR_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_MT_ADDR_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_3 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_3_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_4 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_TRIG_ERR_MASK_4_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_0_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_1_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_WR_DATA_2_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_0_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_1_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_RD_DATA_2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_PRE_TRIG_CYCS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_PRE_TRIG_CYCS_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_ERROR_CNT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_ERROR_CNT_OFFSET)
#define MPFS_DDR_CSR_APB_MTC_ACQ_ERROR_CNT_OVFL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_MTC_ACQ_ERROR_CNT_OVFL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DATA_SEL_FIRST_ERROR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DATA_SEL_FIRST_ERROR_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DQ_WIDTH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DQ_WIDTH_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ACTIVE_DQ_SEL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ACTIVE_DQ_SEL_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_CA_PARITY_ERROR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_CA_PARITY_ERROR_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_CMD (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_CMD_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_ACK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_CA_PARITY_ERROR_GEN_ACK_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_T_RDDATA_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_T_RDDATA_EN_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_T_PHY_RDLAT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_T_PHY_RDLAT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_T_PHY_WRLAT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_T_PHY_WRLAT_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_PHYUPD_EN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_PHYUPD_EN_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_DFI_LP_DATA_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_DFI_LP_DATA_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_DFI_LP_CTRL_REQ (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_DFI_LP_CTRL_REQ_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_DFI_LP_ACK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_DFI_LP_ACK_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_DFI_LP_WAKEUP (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_DFI_LP_WAKEUP_OFFSET)
#define MPFS_DDR_CSR_APB_INIT_DFI_DRAM_CLK_DISABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_INIT_DFI_DRAM_CLK_DISABLE_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_DFI_TRAINING_ERROR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_DFI_TRAINING_ERROR_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_DFI_ERROR (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_DFI_ERROR_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_DFI_ERROR_INFO (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_DFI_ERROR_INFO_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_DATA_BYTE_DISABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_DATA_BYTE_DISABLE_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_DFI_INIT_COMPLETE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_DFI_INIT_COMPLETE_OFFSET)
#define MPFS_DDR_CSR_APB_STAT_DFI_TRAINING_COMPLETE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_STAT_DFI_TRAINING_COMPLETE_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_LVL_SEL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_LVL_SEL_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_LVL_PERIODIC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_LVL_PERIODIC_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_DFI_LVL_PATTERN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_DFI_LVL_PATTERN_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_DFI_INIT_START (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_DFI_INIT_START_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI1_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI1_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI1_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI1_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI2_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI2_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI2_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_START_ADDRESS_AXI2_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI1_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI1_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI1_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI1_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI2_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI2_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI2_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_END_ADDRESS_AXI2_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI1_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI1_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI1_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI1_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI2_0 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI2_0_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI2_1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_MEM_START_ADDRESS_AXI2_1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ENABLE_BUS_HOLD_AXI1 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ENABLE_BUS_HOLD_AXI1_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_ENABLE_BUS_HOLD_AXI2 (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_ENABLE_BUS_HOLD_AXI2_OFFSET)
#define MPFS_DDR_CSR_APB_CFG_AXI_AUTO_PCH (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_CFG_AXI_AUTO_PCH_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_RESET_CONTROL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_RESET_CONTROL_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_PC_RANK (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_PC_RANK_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_RANKS_TO_TRAIN (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_RANKS_TO_TRAIN_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_WRITE_REQUEST (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_WRITE_REQUEST_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_WRITE_REQUEST_DONE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_WRITE_REQUEST_DONE_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_READ_REQUEST (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_READ_REQUEST_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_READ_REQUEST_DONE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_READ_REQUEST_DONE_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_WRITE_LEVEL_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_WRITE_LEVEL_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_GATE_TRAIN_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_GATE_TRAIN_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_EYE_TRAIN_DELAY (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_EYE_TRAIN_DELAY_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_EYE_PAT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_EYE_PAT_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_START_RECAL (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_START_RECAL_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_CLR_DFI_LVL_PERIODIC (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_CLR_DFI_LVL_PERIODIC_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_TRAIN_STEP_ENABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_TRAIN_STEP_ENABLE_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_LPDDR_DQ_CAL_PAT (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_LPDDR_DQ_CAL_PAT_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_INDPNDT_TRAINING (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_INDPNDT_TRAINING_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_ENCODED_QUAD_CS (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_ENCODED_QUAD_CS_OFFSET)
#define MPFS_DDR_CSR_APB_PHY_HALF_CLK_DLY_ENABLE (MPFS_DDRCFG_BASE + MPFS_DDR_CSR_APB_PHY_HALF_CLK_DLY_ENABLE_OFFSET)

#endif /* __ARCH_RISCV_SRC_MPFS_HARDWARE_MPFS_DDR_H */
