/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.operation.AbstractNamedSerializableOperation;
import com.hazelcast.replicatedmap.impl.operation.ReplicateUpdateOperation;
import com.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.hazelcast.replicatedmap.impl.record.RecordMigrationInfo;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutAllWithMetadataOperation
extends AbstractNamedSerializableOperation
implements PartitionAwareOperation,
MutatingOperation {
    private String name;
    private final List<ReplicatedMapEntryViewHolder> entryViewHolders;

    public PutAllWithMetadataOperation() {
        this.entryViewHolders = new ArrayList<ReplicatedMapEntryViewHolder>();
    }

    public PutAllWithMetadataOperation(String name, List<ReplicatedMapEntryViewHolder> entryViewHolders, int partitionId) {
        this.name = name;
        this.entryViewHolders = entryViewHolders;
        this.setPartitionId(partitionId);
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore store = service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        int partitionId = this.getPartitionId();
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        for (ReplicatedMapEntryViewHolder entryViewHolder : this.entryViewHolders) {
            Data key = entryViewHolder.getKey();
            if (partitionId != partitionService.getPartitionId(key)) continue;
            Data value = entryViewHolder.getValue();
            RecordMigrationInfo record = new RecordMigrationInfo(entryViewHolder.getKey(), value, entryViewHolder.getTtlMillis());
            record.setCreationTime(entryViewHolder.getCreationTime());
            record.setHits(entryViewHolder.getHits());
            record.setLastAccessTime(entryViewHolder.getLastAccessTime());
            record.setLastUpdateTime(entryViewHolder.getLastUpdateTime());
            ReplicatedRecord oldRecord = store.putRecord(record);
            Object putResult = oldRecord != null ? oldRecord.getValue() : null;
            Data oldValue = this.getNodeEngine().toData(putResult);
            eventPublishingService.fireEntryListenerEvent(key, oldValue, value, this.name, this.getCallerAddress());
            VersionResponsePair response = new VersionResponsePair(putResult, store.getVersion());
            this.publishReplicationMessage(key, value, response, entryViewHolder.getTtlMillis());
        }
    }

    private void publishReplicationMessage(Data key, Data value, VersionResponsePair response, long ttl) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Collection<Member> members = this.getNodeEngine().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        for (Member member : members) {
            Address address = member.getAddress();
            if (address.equals(this.getNodeEngine().getThisAddress())) continue;
            Operation op = new ReplicateUpdateOperation(this.name, key, value, ttl, response, false, this.getCallerAddress()).setPartitionId(this.getPartitionId()).setValidateTarget(false);
            operationService.invokeOnTarget(this.getServiceName(), op, address);
        }
    }

    @Override
    public int getClassId() {
        return 27;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.entryViewHolders.size());
        for (ReplicatedMapEntryViewHolder entryViewHolder : this.entryViewHolders) {
            out.writeObject(entryViewHolder);
        }
        out.writeInt(this.getPartitionId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            ReplicatedMapEntryViewHolder entryViewHolder = (ReplicatedMapEntryViewHolder)in.readObject(ReplicatedMapEntryViewHolder.class);
            this.entryViewHolders.add(entryViewHolder);
        }
        this.setPartitionId(in.readInt());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

