/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.jwarc.WarcFilterException;

class WarcFilterLexer {
    private static Pattern REGEX = Pattern.compile("([a-zA-Z0-9:_-]+)|(&&|[|][|]|!=|==|!~|=~|[<>]=?|!?[(]|[)])|\"([^\"]*)\"|(\\s+)");
    private static final int TOKEN = 1;
    private static final int OPERATOR = 2;
    private static final int STRING = 3;
    private static final int WHITESPACE = 4;
    private final String input;
    private final Matcher matcher;

    WarcFilterLexer(String input) {
        this.input = input;
        this.matcher = REGEX.matcher(input);
    }

    Object stringOrNumber() {
        String token;
        Object value = this.peek().group(3);
        if (value == null && (token = this.matcher.group(1)) != null) {
            try {
                value = Long.parseLong(this.matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value == null) {
            throw this.error("expected string or integer");
        }
        this.advance();
        return value;
    }

    String string() {
        String str = this.peek().group(3);
        if (str == null) {
            throw this.error("expected string");
        }
        this.advance();
        return str;
    }

    String token() {
        String field = this.peek().group(1);
        if (field == null) {
            throw this.error("expected field name");
        }
        this.advance();
        return field;
    }

    String operator() {
        String operator = this.peekOperator();
        if (operator == null) {
            throw this.error("expected operator");
        }
        this.advance();
        return operator;
    }

    String peekOperator() {
        return this.peek().group(2);
    }

    private Matcher peek() {
        while (true) {
            if (this.atEnd()) {
                throw this.error("unexpected end of input");
            }
            if (!this.matcher.lookingAt()) {
                throw this.error("syntax error");
            }
            if (this.matcher.group(4) == null) {
                return this.matcher;
            }
            this.advance();
        }
    }

    void advance() {
        this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
    }

    WarcFilterException error(String message) {
        return new WarcFilterException(message, this.matcher.regionStart(), this.input);
    }

    boolean atEnd() {
        return this.matcher.regionStart() == this.matcher.regionEnd();
    }
}

