/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.omid.metrics.Counter;
import org.apache.omid.metrics.Gauge;
import org.apache.omid.metrics.Histogram;
import org.apache.omid.metrics.Meter;
import org.apache.omid.metrics.Metric;
import org.apache.omid.metrics.Timer;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;

public class MetricsRegistryMap {
    private final ConcurrentMap<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();

    public Optional<? extends Metric> get(String name, MetricBuilder<? extends Metric> builder, Class<? extends Metric> type) {
        Metric metric = (Metric)this.metrics.get(name);
        if (builder.isInstance(metric)) {
            return Optional.of((Object)type.cast(metric));
        }
        return Optional.absent();
    }

    public <T extends Metric, U extends Number> List<Gauge<U>> getGauges() {
        ArrayList<Gauge<U>> gaugesList = new ArrayList<Gauge<U>>();
        for (Metric metric : this.metrics.values()) {
            if (!(metric instanceof Gauge)) continue;
            gaugesList.add((Gauge)metric);
        }
        return gaugesList;
    }

    public void register(String name, Metric metric) throws IllegalArgumentException {
        Metric existing = this.metrics.putIfAbsent(name, metric);
        if (existing != null) {
            throw new IllegalArgumentException("A metric named " + name + " of class " + metric.getClass().getCanonicalName() + " already exists");
        }
    }

    static interface MetricBuilder<T extends Metric> {
        public static final MetricBuilder<Gauge<? extends Number>> GAUGES = new MetricBuilder<Gauge<? extends Number>>(){

            @Override
            public boolean isInstance(Metric metric) {
                return Gauge.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Counter> COUNTERS = new MetricBuilder<Counter>(){

            @Override
            public boolean isInstance(Metric metric) {
                return Counter.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Timer> TIMERS = new MetricBuilder<Timer>(){

            @Override
            public boolean isInstance(Metric metric) {
                return Timer.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }
        };
        public static final MetricBuilder<Histogram> HISTOGRAMS = new MetricBuilder<Histogram>(){

            @Override
            public boolean isInstance(Metric metric) {
                return Histogram.class.isInstance(metric);
            }
        };

        public boolean isInstance(Metric var1);
    }
}

