/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.phoenix.expression.Expression;

public class ExpressionManager {
    private final Map<Expression, Expression> expressionMap = Maps.newHashMap();

    public Expression addIfAbsent(Expression expression) {
        Expression existingExpression = this.expressionMap.get(expression);
        if (existingExpression == null) {
            this.expressionMap.put(expression, expression);
            return expression;
        }
        return existingExpression;
    }

    public int getExpressionCount() {
        return this.expressionMap.size();
    }

    public Iterator<Expression> getExpressions() {
        return this.expressionMap.keySet().iterator();
    }
}

