/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.OrderPreservingTracker;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.schema.SortOrder;

public class OrderByExpression
implements Writable {
    private Expression expression;
    private boolean isNullsLast;
    private boolean isAscending;

    public OrderByExpression() {
    }

    private OrderByExpression(Expression expression, boolean isNullsLast, boolean isAcending) {
        Preconditions.checkNotNull((Object)expression);
        this.expression = expression;
        this.isNullsLast = isNullsLast;
        this.isAscending = isAcending;
    }

    public static OrderByExpression convertIfExpressionSortOrderDesc(OrderByExpression orderByExpression) {
        return OrderByExpression.createByCheckIfExpressionSortOrderDesc(orderByExpression.getExpression(), orderByExpression.isNullsLast(), orderByExpression.isAscending());
    }

    public static OrderByExpression createByCheckIfExpressionSortOrderDesc(Expression expression, boolean isNullsLast, boolean isAscending) {
        if (expression.getSortOrder() == SortOrder.DESC) {
            isAscending = !isAscending;
        }
        return new OrderByExpression(expression, isNullsLast, isAscending);
    }

    public static OrderByExpression createByCheckIfOrderByReverse(Expression expression, boolean isNullsLast, boolean isAscending, boolean orderByReverse) {
        if (orderByReverse) {
            isNullsLast = !isNullsLast;
            isAscending = !isAscending;
        }
        return new OrderByExpression(expression, isNullsLast, isAscending);
    }

    public static OrderByExpression convertExpressionToOrderByExpression(Expression expression, boolean orderByReverse) {
        return OrderByExpression.convertExpressionToOrderByExpression(expression, null, orderByReverse);
    }

    public static OrderByExpression convertExpressionToOrderByExpression(Expression expression, OrderPreservingTracker.Info orderPreservingTrackInfo, boolean orderByReverse) {
        boolean isAscending;
        boolean isNullsLast = false;
        boolean bl = isAscending = expression.getSortOrder() == SortOrder.ASC;
        if (orderPreservingTrackInfo != null) {
            isNullsLast = orderPreservingTrackInfo.isNullsLast();
            isAscending = orderPreservingTrackInfo.isAscending();
        }
        return OrderByExpression.createByCheckIfOrderByReverse(expression, isNullsLast, isAscending, orderByReverse);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isNullsLast() {
        return this.isNullsLast;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrderByExpression that = (OrderByExpression)o;
            return this.isNullsLast == that.isNullsLast && this.isAscending == that.isAscending && this.expression.equals(that.expression);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNullsLast ? 0 : 1);
        result = 31 * result + (this.isAscending ? 0 : 1);
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public String toString() {
        Expression e = this.getExpression();
        boolean isNullsLast = this.isNullsLast;
        boolean isAscending = this.isAscending;
        if (e.getSortOrder() == SortOrder.DESC) {
            isAscending = !isAscending;
        }
        return e + (isAscending ? "" : " DESC") + (isNullsLast ? " NULLS LAST" : "");
    }

    public void readFields(DataInput input) throws IOException {
        this.isNullsLast = input.readBoolean();
        this.isAscending = input.readBoolean();
        this.expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
        this.expression.readFields(input);
    }

    public void write(DataOutput output) throws IOException {
        output.writeBoolean(this.isNullsLast);
        output.writeBoolean(this.isAscending);
        WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(this.expression).ordinal());
        this.expression.write(output);
    }
}

