/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.Date;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public abstract class RoundJodaDateExpression
extends RoundDateExpression {
    public RoundJodaDateExpression() {
    }

    public RoundJodaDateExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType dataType = this.getDataType();
            long time = dataType.getCodec().decodeLong(ptr, ((Expression)this.children.get(0)).getSortOrder());
            DateTime dt = new DateTime(time, (Chronology)ISOChronology.getInstanceUTC());
            long value = this.roundDateTime(dt);
            Date d = new Date(value);
            byte[] byteValue = dataType.toBytes(d);
            ptr.set(byteValue);
            return true;
        }
        return false;
    }

    public abstract long roundDateTime(DateTime var1);
}

