/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexImportMapper
extends Mapper<NullWritable, PhoenixIndexDBWritable, ImmutableBytesWritable, KeyValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixIndexImportMapper.class);
    private final PhoenixIndexDBWritable indxWritable = new PhoenixIndexDBWritable();
    private List<ColumnInfo> indxTblColumnMetadata;
    private Connection connection;
    private String indexTableName;
    private ImportPreUpsertKeyValueProcessor preUpdateProcessor;
    private PreparedStatement pStatement;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        try {
            this.indxTblColumnMetadata = PhoenixConfigurationUtil.getUpsertColumnMetadataList(context.getConfiguration());
            this.indxWritable.setColumnMetadata(this.indxTblColumnMetadata);
            this.preUpdateProcessor = PhoenixConfigurationUtil.loadPreUpsertProcessor(configuration);
            this.indexTableName = PhoenixConfigurationUtil.getPhysicalTableName(configuration);
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            String txScnValue = configuration.get("phoenix.mr.txscn.value");
            if (txScnValue == null) {
                overrideProps.put("BuildIndexAt", scn);
            }
            this.connection = ConnectionUtil.getOutputConnection(configuration, overrideProps);
            this.connection.setAutoCommit(false);
            String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
            this.pStatement = this.connection.prepareStatement(upsertQuery);
        }
        catch (SQLException e) {
            this.tryClosingConnection();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void map(NullWritable key, PhoenixIndexDBWritable record, Mapper.Context context) throws IOException, InterruptedException {
        context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
        PhoenixTransactionProvider provider = null;
        Configuration conf = context.getConfiguration();
        long ts = Long.MAX_VALUE;
        String txnIdStr = conf.get("phoenix.mr.txscn.value");
        if (txnIdStr != null) {
            ts = Long.parseLong(txnIdStr);
            provider = TransactionFactory.Provider.getDefault().getTransactionProvider();
            String txnProviderStr = conf.get("phoenix.mr.txprovider");
            if (txnProviderStr != null) {
                provider = TransactionFactory.Provider.valueOf(txnProviderStr).getTransactionProvider();
            }
        }
        try {
            ImmutableBytesWritable outputKey = new ImmutableBytesWritable();
            List<Object> values = record.getValues();
            this.indxWritable.setValues(values);
            this.indxWritable.write(this.pStatement);
            this.pStatement.execute();
            PhoenixConnection pconn = this.connection.unwrap(PhoenixConnection.class);
            Iterator<Pair<byte[], List<Mutation>>> iterator = pconn.getMutationState().toMutations(true);
            while (iterator.hasNext()) {
                Pair<byte[], List<Mutation>> pair = iterator.next();
                if (Bytes.compareTo((byte[])Bytes.toBytes((String)this.indexTableName), (byte[])((byte[])pair.getFirst())) != 0) continue;
                ArrayList keyValues = Lists.newArrayListWithExpectedSize((int)(((List)pair.getSecond()).size() * 5));
                for (Mutation mutation : (List)pair.getSecond()) {
                    if (!(mutation instanceof Put)) continue;
                    if (provider != null) {
                        mutation = provider.markPutAsCommitted((Put)mutation, ts, ts);
                    }
                    for (List cellList : mutation.getFamilyCellMap().values()) {
                        List<KeyValue> keyValueList = this.preUpdateProcessor.preUpsert(mutation.getRow(), KeyValueUtil.ensureKeyValues((List)cellList));
                        keyValues.addAll(keyValueList);
                    }
                }
                keyValues.sort(pconn.getKeyValueBuilder().getKeyValueComparator());
                for (KeyValue kv : keyValues) {
                    outputKey.set(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength());
                    context.write((Object)outputKey, (Object)kv);
                }
                context.getCounter((Enum)PhoenixJobCounters.OUTPUT_RECORDS).increment(1L);
            }
            this.connection.rollback();
        }
        catch (SQLException e) {
            LOGGER.error("Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        this.tryClosingConnection();
    }

    private void tryClosingConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error while closing connection in the PhoenixIndexMapper class ", (Throwable)e);
            }
        }
    }
}

