/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;

public class JoinTableNode
extends TableNode {
    private final JoinType type;
    private final TableNode lhs;
    private final TableNode rhs;
    private final ParseNode onNode;
    private final boolean singleValueOnly;

    JoinTableNode(JoinType type, TableNode lhs, TableNode rhs, ParseNode onNode, boolean singleValueOnly) {
        super(null);
        this.type = type;
        this.lhs = lhs;
        this.rhs = rhs;
        this.onNode = onNode;
        this.singleValueOnly = singleValueOnly;
    }

    public JoinType getType() {
        return this.type;
    }

    public TableNode getLHS() {
        return this.lhs;
    }

    public TableNode getRHS() {
        return this.rhs;
    }

    public ParseNode getOnNode() {
        return this.onNode;
    }

    public boolean isSingleValueOnly() {
        return this.singleValueOnly;
    }

    @Override
    public <T> T accept(TableNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(this.lhs);
        buf.append(' ');
        if (this.onNode == null) {
            buf.append(',');
            buf.append(this.rhs);
        } else {
            buf.append((Object)this.type);
            buf.append(" JOIN ");
            buf.append(this.rhs);
            buf.append(" ON (");
            this.onNode.toSQL(resolver, buf);
            buf.append(')');
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
        result = 31 * result + (this.onNode == null ? 0 : this.onNode.hashCode());
        result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
        result = 31 * result + (this.singleValueOnly ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinTableNode other = (JoinTableNode)obj;
        if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
            return false;
        }
        if (this.onNode == null ? other.onNode != null : !this.onNode.equals(other.onNode)) {
            return false;
        }
        if (this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs)) {
            return false;
        }
        if (this.singleValueOnly != other.singleValueOnly) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum JoinType {
        Inner,
        Left,
        Right,
        Full,
        Semi,
        Anti;

    }
}

