/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.twill.api.EventHandlerSpecification;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.ResourceSpecification;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.internal.json.LocalFileCodec;
import org.apache.twill.internal.json.ResourceSpecificationCodec;
import org.apache.twill.internal.json.RuntimeSpecificationCodec;
import org.apache.twill.internal.json.TwillRunnableSpecificationCodec;
import org.apache.twill.internal.json.TwillSpecificationCodec;

public final class TwillSpecificationAdapter {
    private final Gson gson = new GsonBuilder().serializeNulls().registerTypeAdapter((Type)((Object)TwillSpecification.class), new TwillSpecificationCodec()).registerTypeAdapter((Type)((Object)TwillSpecification.Order.class), new TwillSpecificationCodec.TwillSpecificationOrderCoder()).registerTypeAdapter((Type)((Object)TwillSpecification.PlacementPolicy.class), new TwillSpecificationCodec.TwillSpecificationPlacementPolicyCoder()).registerTypeAdapter((Type)((Object)EventHandlerSpecification.class), new TwillSpecificationCodec.EventHandlerSpecificationCoder()).registerTypeAdapter((Type)((Object)RuntimeSpecification.class), new RuntimeSpecificationCodec()).registerTypeAdapter((Type)((Object)TwillRunnableSpecification.class), new TwillRunnableSpecificationCodec()).registerTypeAdapter((Type)((Object)ResourceSpecification.class), new ResourceSpecificationCodec()).registerTypeAdapter((Type)((Object)LocalFile.class), new LocalFileCodec()).registerTypeAdapterFactory(new TwillSpecificationTypeAdapterFactory()).create();

    public static TwillSpecificationAdapter create() {
        return new TwillSpecificationAdapter();
    }

    private TwillSpecificationAdapter() {
    }

    public String toJson(TwillSpecification spec) {
        return this.gson.toJson((Object)spec, (Type)((Object)TwillSpecification.class));
    }

    public void toJson(TwillSpecification spec, Writer writer) {
        this.gson.toJson((Object)spec, (Type)((Object)TwillSpecification.class), writer);
    }

    public void toJson(TwillSpecification spec, File file) throws IOException {
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
            this.toJson(spec, writer);
        }
    }

    public TwillSpecification fromJson(String json) {
        return this.gson.fromJson(json, TwillSpecification.class);
    }

    public TwillSpecification fromJson(Reader reader) {
        return this.gson.fromJson(reader, TwillSpecification.class);
    }

    public TwillSpecification fromJson(File file) throws IOException {
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            TwillSpecification twillSpecification = this.fromJson(reader);
            return twillSpecification;
        }
    }

    private static final class TwillSpecificationTypeAdapterFactory
    implements TypeAdapterFactory {
        private TwillSpecificationTypeAdapterFactory() {
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class<T> rawType = type.getRawType();
            if (!Map.class.isAssignableFrom(rawType)) {
                return null;
            }
            Type[] typeArgs = ((ParameterizedType)type.getType()).getActualTypeArguments();
            TypeToken<?> keyType = TypeToken.get(typeArgs[0]);
            TypeToken<?> valueType = TypeToken.get(typeArgs[1]);
            if (keyType.getRawType() != String.class) {
                return null;
            }
            return this.mapAdapter(gson, valueType);
        }

        private <V> TypeAdapter<Map<String, V>> mapAdapter(Gson gson, TypeToken<V> valueType) {
            final TypeAdapter<V> valueAdapter = gson.getAdapter(valueType);
            return new TypeAdapter<Map<String, V>>(){

                @Override
                public void write(JsonWriter writer, Map<String, V> map) throws IOException {
                    if (map == null) {
                        writer.nullValue();
                        return;
                    }
                    writer.beginObject();
                    for (Map.Entry entry : map.entrySet()) {
                        writer.name(entry.getKey());
                        valueAdapter.write(writer, entry.getValue());
                    }
                    writer.endObject();
                }

                @Override
                public Map<String, V> read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                        return null;
                    }
                    HashMap map = Maps.newHashMap();
                    reader.beginObject();
                    while (reader.peek() != JsonToken.END_OBJECT) {
                        map.put(reader.nextName(), valueAdapter.read(reader));
                    }
                    reader.endObject();
                    return map;
                }
            };
        }
    }
}

