/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.metrics;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.phoenix.hbase.index.metrics.GlobalIndexCheckerSource;

public class GlobalIndexCheckerSourceImpl
extends BaseSourceImpl
implements GlobalIndexCheckerSource {
    private final MutableFastCounter indexInspections = this.getMetricsRegistry().newCounter("indexInspections", "The number of index rows inspected for verified status", 0L);
    private final MutableFastCounter indexRepairs = this.getMetricsRegistry().newCounter("indexRepairs", "The number of index row repairs", 0L);
    private final MutableFastCounter indexRepairFailures = this.getMetricsRegistry().newCounter("indexRepairFailures", "The number of index row repair failures", 0L);
    private final MetricHistogram indexRepairTimeHisto = this.getMetricsRegistry().newHistogram("indexRepairTime", "Histogram for the time in milliseconds for index row repairs");
    private final MetricHistogram indexRepairFailureTimeHisto = this.getMetricsRegistry().newHistogram("indexRepairFailureTime", "Histogram for the time in milliseconds for index row repair failures");
    private final MetricHistogram unverifiedIndexRowAge = this.getMetricsRegistry().newHistogram("unverifiedIndexRowAge", "Histogram for the age in milliseconds for unverified row soon after it is repaired");

    public GlobalIndexCheckerSourceImpl() {
        this("GlobalIndexChecker", "Metrics about the Phoenix Global Index Checker", "phoenix", "RegionServer,sub=GlobalIndexChecker");
    }

    public GlobalIndexCheckerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void incrementIndexInspections(String indexName) {
        this.incrementIndexSpecificCounter("indexInspections", indexName);
        this.indexInspections.incr();
    }

    @Override
    public void incrementIndexRepairs(String indexName) {
        this.incrementIndexSpecificCounter("indexRepairs", indexName);
        this.indexRepairs.incr();
    }

    @Override
    public void incrementIndexRepairFailures(String indexName) {
        this.incrementIndexSpecificCounter("indexRepairFailures", indexName);
        this.indexRepairFailures.incr();
    }

    @Override
    public void updateUnverifiedIndexRowAge(String indexName, long time) {
        this.incrementIndexSpecificHistogram("unverifiedIndexRowAge", indexName, time);
        this.unverifiedIndexRowAge.add(time);
    }

    @Override
    public void updateIndexRepairTime(String indexName, long t) {
        this.incrementIndexSpecificHistogram("indexRepairTime", indexName, t);
        this.indexRepairTimeHisto.add(t);
    }

    @Override
    public void updateIndexRepairFailureTime(String indexName, long t) {
        this.incrementIndexSpecificHistogram("indexRepairFailureTime", indexName, t);
        this.indexRepairFailureTimeHisto.add(t);
    }

    private void incrementIndexSpecificCounter(String baseCounterName, String indexName) {
        MutableFastCounter indexSpecificCounter = this.getMetricsRegistry().getCounter(this.getCounterName(baseCounterName, indexName), 0L);
        indexSpecificCounter.incr();
    }

    private void incrementIndexSpecificHistogram(String baseCounterName, String indexName, long t) {
        MutableHistogram indexSpecificHistogram = this.getMetricsRegistry().getHistogram(this.getCounterName(baseCounterName, indexName));
        indexSpecificHistogram.add(t);
    }

    private String getCounterName(String baseCounterName, String indexName) {
        return baseCounterName + "." + indexName;
    }
}

