/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.joni.BitSet;
import org.joni.BitStatus;
import org.joni.CaptureTreeNode;
import org.joni.Config;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.StackEntry;
import org.joni.StackMachine;
import org.joni.ast.CClassNode;
import org.joni.exception.InternalException;

class ByteCodeMachine
extends StackMachine {
    private static final int INTERRUPT_CHECK_EVERY = 30000;
    int interruptCheckCounter = 0;
    private int bestLen;
    private int s = 0;
    private int range;
    private int sprev;
    private int sstart;
    private int sbegin;
    private final int[] code;
    private int ip;
    protected int stkp;
    private byte[] cfbuf;
    private byte[] cfbuf2;

    ByteCodeMachine(Regex regex, byte[] bytes, int p, int end) {
        super(regex, bytes, p, end);
        this.code = regex.code;
    }

    private boolean makeCaptureHistoryTree(CaptureTreeNode node) {
        int k = this.stkp;
        while (k < this.stk) {
            StackEntry e = this.stack[k];
            if (e.type == 256) {
                int n = e.getMemNum();
                if (n > 31 || !BitStatus.bsAt(this.regex.captureHistory, n)) continue;
                CaptureTreeNode child = new CaptureTreeNode();
                child.group = n;
                child.beg = e.getMemPStr() - this.str;
                node.addChild(child);
                this.stkp = k + 1;
                if (this.makeCaptureHistoryTree(child)) {
                    return true;
                }
                k = this.stkp;
                child.end = e.getMemPStr() - this.str;
                continue;
            }
            if (e.type != 33280 || e.getMemNum() != node.group) continue;
            node.end = e.getMemPStr() - this.str;
            this.stkp = k;
            return false;
        }
        return true;
    }

    private void checkCaptureHistory(Region region) {
        CaptureTreeNode node;
        if (region.historyRoot == null) {
            node = region.historyRoot = new CaptureTreeNode();
        } else {
            node = region.historyRoot;
            node.clear();
        }
        node.group = 0;
        node.beg = this.sstart - this.str;
        node.end = this.s - this.str;
        this.stkp = 0;
        this.makeCaptureHistoryTree(region.historyRoot);
    }

    protected final byte[] cfbuf() {
        return this.cfbuf == null ? (this.cfbuf = new byte[18]) : this.cfbuf;
    }

    protected final byte[] cfbuf2() {
        return this.cfbuf2 == null ? (this.cfbuf2 = new byte[18]) : this.cfbuf2;
    }

    private boolean stringCmpIC(int caseFlodFlag, int s1, IntHolder ps2, int mbLen, int textEnd) {
        byte[] buf1 = this.cfbuf();
        byte[] buf2 = this.cfbuf2();
        int s2 = ps2.value;
        int end1 = s1 + mbLen;
        while (s1 < end1) {
            this.value = s1;
            int len1 = this.enc.mbcCaseFold(caseFlodFlag, this.bytes, this, textEnd, buf1);
            s1 = this.value;
            this.value = s2;
            int len2 = this.enc.mbcCaseFold(caseFlodFlag, this.bytes, this, textEnd, buf2);
            s2 = this.value;
            if (len1 != len2) {
                return false;
            }
            int p1 = 0;
            int p2 = 0;
            while (len1-- > 0) {
                if (buf1[p1] != buf2[p2]) {
                    return false;
                }
                ++p1;
                ++p2;
            }
        }
        ps2.value = s2;
        return true;
    }

    private void debugMatchBegin() {
        Config.log.println("match_at: str: " + this.str + ", end: " + this.end + ", start: " + this.sstart + ", sprev: " + this.sprev);
        Config.log.println("size: " + (this.end - this.str) + ", start offset: " + (this.sstart - this.str));
    }

    private void debugMatchLoop() {
    }

    protected final int matchAt(int range, int sstart, int sprev) throws InterruptedException {
        this.range = range;
        this.sstart = sstart;
        this.sprev = sprev;
        this.stk = 0;
        this.ip = 0;
        this.init();
        this.bestLen = -1;
        this.s = sstart;
        Thread currentThread = Thread.currentThread();
        int[] code = this.code;
        block107: while (true) {
            if (this.interruptCheckCounter++ % 30000 == 0 && currentThread.isInterrupted()) {
                currentThread.interrupted();
                throw new InterruptedException();
            }
            this.sbegin = this.s;
            switch (code[this.ip++]) {
                case 1: {
                    if (!this.opEnd()) continue block107;
                    return this.finish();
                }
                case 2: {
                    this.opExact1();
                    continue block107;
                }
                case 3: {
                    this.opExact2();
                    continue block107;
                }
                case 4: {
                    this.opExact3();
                    continue block107;
                }
                case 5: {
                    this.opExact4();
                    continue block107;
                }
                case 6: {
                    this.opExact5();
                    continue block107;
                }
                case 7: {
                    this.opExactN();
                    continue block107;
                }
                case 8: {
                    this.opExactMB2N1();
                    continue block107;
                }
                case 9: {
                    this.opExactMB2N2();
                    continue block107;
                }
                case 10: {
                    this.opExactMB2N3();
                    continue block107;
                }
                case 11: {
                    this.opExactMB2N();
                    continue block107;
                }
                case 12: {
                    this.opExactMB3N();
                    continue block107;
                }
                case 13: {
                    this.opExactMBN();
                    continue block107;
                }
                case 14: {
                    this.opExact1IC();
                    continue block107;
                }
                case 15: {
                    this.opExactNIC();
                    continue block107;
                }
                case 16: {
                    this.opCClass();
                    continue block107;
                }
                case 17: {
                    this.opCClassMB();
                    continue block107;
                }
                case 18: {
                    this.opCClassMIX();
                    continue block107;
                }
                case 19: {
                    this.opCClassNot();
                    continue block107;
                }
                case 20: {
                    this.opCClassMBNot();
                    continue block107;
                }
                case 21: {
                    this.opCClassMIXNot();
                    continue block107;
                }
                case 22: {
                    this.opCClassNode();
                    continue block107;
                }
                case 23: {
                    this.opAnyChar();
                    continue block107;
                }
                case 24: {
                    this.opAnyCharML();
                    continue block107;
                }
                case 25: {
                    this.opAnyCharStar();
                    continue block107;
                }
                case 26: {
                    this.opAnyCharMLStar();
                    continue block107;
                }
                case 27: {
                    this.opAnyCharStarPeekNext();
                    continue block107;
                }
                case 28: {
                    this.opAnyCharMLStarPeekNext();
                    continue block107;
                }
                case 84: {
                    this.opStateCheckAnyCharStar();
                    continue block107;
                }
                case 85: {
                    this.opStateCheckAnyCharMLStar();
                    continue block107;
                }
                case 29: {
                    this.opWord();
                    continue block107;
                }
                case 30: {
                    this.opNotWord();
                    continue block107;
                }
                case 31: {
                    this.opWordBound();
                    continue block107;
                }
                case 32: {
                    this.opNotWordBound();
                    continue block107;
                }
                case 33: {
                    this.opWordBegin();
                    continue block107;
                }
                case 34: {
                    this.opWordEnd();
                    continue block107;
                }
                case 35: {
                    this.opBeginBuf();
                    continue block107;
                }
                case 36: {
                    this.opEndBuf();
                    continue block107;
                }
                case 37: {
                    this.opBeginLine();
                    continue block107;
                }
                case 38: {
                    this.opEndLine();
                    continue block107;
                }
                case 39: {
                    this.opSemiEndBuf();
                    continue block107;
                }
                case 40: {
                    this.opBeginPosition();
                    continue block107;
                }
                case 49: {
                    this.opMemoryStartPush();
                    continue block107;
                }
                case 48: {
                    this.opMemoryStart();
                    continue block107;
                }
                case 50: {
                    this.opMemoryEndPush();
                    continue block107;
                }
                case 52: {
                    this.opMemoryEnd();
                    continue block107;
                }
                case 51: {
                    this.opMemoryEndPushRec();
                    continue block107;
                }
                case 53: {
                    this.opMemoryEndRec();
                    continue block107;
                }
                case 41: {
                    this.opBackRef1();
                    continue block107;
                }
                case 42: {
                    this.opBackRef2();
                    continue block107;
                }
                case 43: {
                    this.opBackRefN();
                    continue block107;
                }
                case 44: {
                    this.opBackRefNIC();
                    continue block107;
                }
                case 45: {
                    this.opBackRefMulti();
                    continue block107;
                }
                case 46: {
                    this.opBackRefMultiIC();
                    continue block107;
                }
                case 47: {
                    this.opBackRefAtLevel();
                    continue block107;
                }
                case 66: {
                    this.opNullCheckStart();
                    continue block107;
                }
                case 67: {
                    this.opNullCheckEnd();
                    continue block107;
                }
                case 68: {
                    this.opNullCheckEndMemST();
                    continue block107;
                }
                case 69: {
                    this.opNullCheckEndMemSTPush();
                    continue block107;
                }
                case 55: {
                    this.opJump();
                    continue block107;
                }
                case 56: {
                    this.opPush();
                    continue block107;
                }
                case 81: {
                    this.opStateCheckPush();
                    continue block107;
                }
                case 82: {
                    this.opStateCheckPushOrJump();
                    continue block107;
                }
                case 83: {
                    this.opStateCheck();
                    continue block107;
                }
                case 57: {
                    this.opPop();
                    continue block107;
                }
                case 58: {
                    this.opPushOrJumpExact1();
                    continue block107;
                }
                case 59: {
                    this.opPushIfPeekNext();
                    continue block107;
                }
                case 60: {
                    this.opRepeat();
                    continue block107;
                }
                case 61: {
                    this.opRepeatNG();
                    continue block107;
                }
                case 62: {
                    this.opRepeatInc();
                    continue block107;
                }
                case 64: {
                    this.opRepeatIncSG();
                    continue block107;
                }
                case 63: {
                    this.opRepeatIncNG();
                    continue block107;
                }
                case 65: {
                    this.opRepeatIncNGSG();
                    continue block107;
                }
                case 70: {
                    this.opPushPos();
                    continue block107;
                }
                case 71: {
                    this.opPopPos();
                    continue block107;
                }
                case 72: {
                    this.opPushPosNot();
                    continue block107;
                }
                case 73: {
                    this.opFailPos();
                    continue block107;
                }
                case 74: {
                    this.opPushStopBT();
                    continue block107;
                }
                case 75: {
                    this.opPopStopBT();
                    continue block107;
                }
                case 76: {
                    this.opLookBehind();
                    continue block107;
                }
                case 77: {
                    this.opPushLookBehindNot();
                    continue block107;
                }
                case 78: {
                    this.opFailLookBehindNot();
                    continue block107;
                }
                case 79: {
                    this.opCall();
                    continue block107;
                }
                case 80: {
                    this.opReturn();
                    continue block107;
                }
                case 96: {
                    this.opCClassSb();
                    continue block107;
                }
                case 97: {
                    this.opCClassNotSb();
                    continue block107;
                }
                case 88: {
                    this.opAnyCharSb();
                    continue block107;
                }
                case 89: {
                    this.opAnyCharMLSb();
                    continue block107;
                }
                case 90: {
                    this.opAnyCharStarSb();
                    continue block107;
                }
                case 91: {
                    this.opAnyCharMLStarSb();
                    continue block107;
                }
                case 92: {
                    this.opAnyCharStarPeekNextSb();
                    continue block107;
                }
                case 93: {
                    this.opAnyCharMLStarPeekNextSb();
                    continue block107;
                }
                case 94: {
                    this.opStateCheckAnyCharStarSb();
                    continue block107;
                }
                case 95: {
                    this.opStateCheckAnyCharMLStarSb();
                    continue block107;
                }
                case 98: {
                    this.opWordSb();
                    continue block107;
                }
                case 99: {
                    this.opNotWordSb();
                    continue block107;
                }
                case 100: {
                    this.opWordBoundSb();
                    continue block107;
                }
                case 101: {
                    this.opNotWordBoundSb();
                    continue block107;
                }
                case 102: {
                    this.opWordBeginSb();
                    continue block107;
                }
                case 103: {
                    this.opWordEndSb();
                    continue block107;
                }
                case 104: {
                    this.opLookBehindSb();
                    continue block107;
                }
                case 105: {
                    this.opExact1ICSb();
                    continue block107;
                }
                case 106: {
                    this.opExactNICSb();
                    continue block107;
                }
                case 0: {
                    return this.finish();
                }
                case 54: {
                    this.opFail();
                    continue block107;
                }
            }
            break;
        }
        throw new InternalException("undefined bytecode (bug)");
    }

    private boolean opEnd() {
        int n = this.s - this.sstart;
        if (n > this.bestLen) {
            if (Option.isFindLongest(this.regex.options)) {
                if (n > this.msaBestLen) {
                    this.msaBestLen = n;
                    this.msaBestS = this.sstart;
                } else {
                    return this.endBestLength();
                }
            }
            this.bestLen = n;
            Region region = this.msaRegion;
            if (region != null) {
                region.beg[0] = this.msaBegin = this.sstart - this.str;
                region.end[0] = this.msaEnd = this.s - this.str;
                for (int i = 1; i <= this.regex.numMem; ++i) {
                    if (this.repeatStk[this.memEndStk + i] != -1) {
                        region.beg[i] = BitStatus.bsAt(this.regex.btMemStart, i) ? this.stack[this.repeatStk[this.memStartStk + i]].getMemPStr() - this.str : this.repeatStk[this.memStartStk + i] - this.str;
                        region.end[i] = BitStatus.bsAt(this.regex.btMemEnd, i) ? this.stack[this.repeatStk[this.memEndStk + i]].getMemPStr() : this.repeatStk[this.memEndStk + i] - this.str;
                        continue;
                    }
                    region.end[i] = -1;
                    region.beg[i] = -1;
                }
            } else {
                this.msaBegin = this.sstart - this.str;
                this.msaEnd = this.s - this.str;
            }
        } else {
            Region region = this.msaRegion;
            if (!Option.isPosixRegion(this.regex.options)) {
                if (region != null) {
                    region.clear();
                } else {
                    this.msaEnd = 0;
                    this.msaBegin = 0;
                }
            }
        }
        return this.endBestLength();
    }

    private boolean endBestLength() {
        if (Option.isFindCondition(this.regex.options)) {
            if (Option.isFindNotEmpty(this.regex.options) && this.s == this.sstart) {
                this.bestLen = -1;
                this.opFail();
                return false;
            }
            if (Option.isFindLongest(this.regex.options) && this.s < this.range) {
                this.opFail();
                return false;
            }
        }
        return true;
    }

    private void opExact1() {
        if (this.s >= this.range || this.code[this.ip] != this.bytes[this.s++]) {
            this.opFail();
            return;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opExact2() {
        if (this.s + 2 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExact3() {
        if (this.s + 3 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExact4() {
        if (this.s + 4 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExact5() {
        if (this.s + 5 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        this.sprev = this.s++;
        ++this.ip;
    }

    private void opExactN() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        byte[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        while (tlen-- > 0) {
            if (bs[ps++] == this.bytes[this.s++]) continue;
            this.opFail();
            return;
        }
        this.sprev = this.s - 1;
    }

    private void opExactMB2N1() {
        if (this.s + 2 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opExactMB2N2() {
        if (this.s + 4 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactMB2N3() {
        if (this.s + 6 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        this.sprev = this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.bytes[this.s]) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactMB2N() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) * 2 > this.range) {
            this.opFail();
            return;
        }
        byte[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        while (tlen-- > 0) {
            if (bs[ps] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.s;
            if (bs[++ps] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++ps;
            ++this.s;
        }
        this.sprev = this.s - 2;
    }

    private void opExactMB3N() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) * 3 > this.range) {
            this.opFail();
            return;
        }
        byte[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        while (tlen-- > 0) {
            if (bs[ps] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.s;
            if (bs[++ps] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++this.s;
            if (bs[++ps] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++ps;
            ++this.s;
        }
        this.sprev = this.s - 3;
    }

    private void opExactMBN() {
        int tlen = this.code[this.ip++];
        int tlen2 = this.code[this.ip++];
        if (this.s + (tlen2 *= tlen) > this.range) {
            this.opFail();
            return;
        }
        byte[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        while (tlen2-- > 0) {
            if (bs[ps] != this.bytes[this.s]) {
                this.opFail();
                return;
            }
            ++ps;
            ++this.s;
        }
        this.sprev = this.s - tlen;
    }

    private void opExact1IC() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        byte[] lowbuf = this.cfbuf();
        this.value = this.s;
        int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, lowbuf);
        this.s = this.value;
        if (this.s > this.range) {
            this.opFail();
            return;
        }
        int q = 0;
        while (len-- > 0) {
            if (this.code[this.ip] != lowbuf[q]) {
                this.opFail();
                return;
            }
            ++this.ip;
            ++q;
        }
        this.sprev = this.sbegin;
    }

    private void opExact1ICSb() {
        if (this.s >= this.range || this.code[this.ip] != this.enc.toLowerCaseTable()[this.bytes[this.s++] & 0xFF]) {
            this.opFail();
            return;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opExactNIC() {
        int tlen = this.code[this.ip++];
        byte[] lowbuf = this.cfbuf();
        byte[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        int endp = ps + tlen;
        while (ps < endp) {
            this.sprev = this.s;
            if (this.s >= this.range) {
                this.opFail();
                return;
            }
            this.value = this.s;
            int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, this.bytes, this, this.end, lowbuf);
            this.s = this.value;
            if (this.s > this.range) {
                this.opFail();
                return;
            }
            int q = 0;
            while (len-- > 0) {
                if (bs[ps] != lowbuf[q]) {
                    this.opFail();
                    return;
                }
                ++ps;
                ++q;
            }
        }
    }

    private void opExactNICSb() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        byte[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        byte[] toLowerTable = this.enc.toLowerCaseTable();
        while (tlen-- > 0) {
            if (bs[ps++] == toLowerTable[this.bytes[this.s++] & 0xFF]) continue;
            this.opFail();
            return;
        }
        this.sprev = this.s - 1;
    }

    private boolean isInBitSet() {
        int c = this.bytes[this.s] & 0xFF;
        return (this.code[this.ip + (c >>> BitSet.ROOM_SHIFT)] & 1 << c) != 0;
    }

    private void opCClass() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        this.s += this.enc.length(this.bytes, this.s, this.end);
        if (this.s > this.end) {
            this.s = this.end;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassSb() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private boolean isInClassMB() {
        int tlen = this.code[this.ip++];
        if (this.s >= this.range) {
            return false;
        }
        int mbLen = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + mbLen > this.range) {
            return false;
        }
        int ss = this.s;
        this.s += mbLen;
        int c = this.enc.mbcToCode(this.bytes, ss, this.s);
        if (!CodeRange.isInCodeRange(this.code, this.ip, c)) {
            return false;
        }
        this.ip += tlen;
        return true;
    }

    private void opCClassMB() {
        if (this.s >= this.range || !this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        if (!this.isInClassMB()) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMIX() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.ip += 8;
            if (!this.isInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (!this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            ++this.s;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNot() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        this.s += this.enc.length(this.bytes, this.s, this.end);
        if (this.s > this.end) {
            this.s = this.end;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNotSb() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
        this.sprev = this.sbegin;
    }

    private boolean isNotInClassMB() {
        int tlen = this.code[this.ip++];
        int mbLen = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + mbLen > this.range) {
            if (this.s >= this.range) {
                return false;
            }
            this.s = this.end;
            this.ip += tlen;
            return true;
        }
        int ss = this.s;
        this.s += mbLen;
        int c = this.enc.mbcToCode(this.bytes, ss, this.s);
        if (CodeRange.isInCodeRange(this.code, this.ip, c)) {
            return false;
        }
        this.ip += tlen;
        return true;
    }

    private void opCClassMBNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (!this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            ++this.s;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            this.sprev = this.sbegin;
            return;
        }
        if (!this.isNotInClassMB()) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassMIXNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isMbcHead(this.bytes, this.s, this.end)) {
            this.ip += 8;
            if (!this.isNotInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            ++this.s;
        }
        this.sprev = this.sbegin;
    }

    private void opCClassNode() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        CClassNode cc = (CClassNode)this.regex.operands[this.code[this.ip++]];
        int mbLen = this.enc.length(this.bytes, this.s, this.end);
        int ss = this.s;
        this.s += mbLen;
        if (this.s > this.range) {
            this.opFail();
            return;
        }
        int c = this.enc.mbcToCode(this.bytes, ss, this.s);
        if (!cc.isCodeInCCLength(mbLen, c)) {
            this.opFail();
            return;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyChar() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        int n = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += n;
        this.sprev = this.sbegin;
    }

    private void opAnyCharSb() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.bytes[this.s] == 10) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAnyCharML() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        int n = this.enc.length(this.bytes, this.s, this.end);
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.s += n;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLSb() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opAnyCharStar() {
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            int n = this.enc.length(bytes, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            if (this.enc.isNewLine(bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarSb() {
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            if (bytes[this.s] == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStar() {
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            int n = this.enc.length(bytes, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarSb() {
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s, this.sprev);
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarPeekNext() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            int n;
            if (c == bytes[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            if (this.s + (n = this.enc.length(bytes, this.s, this.end)) > this.range || this.enc.isNewLine(bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharStarPeekNextSb() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            byte b = bytes[this.s];
            if (c == b) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            if (b == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarPeekNext() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            int n;
            if (c == bytes[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            if (this.s + (n = this.enc.length(bytes, this.s, this.end)) > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opAnyCharMLStarPeekNextSb() {
        byte c = (byte)this.code[this.ip];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            if (c == bytes[this.s]) {
                this.pushAlt(this.ip + 1, this.s, this.sprev);
            }
            this.sprev = this.s++;
        }
        ++this.ip;
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharStar() {
        int mem = this.code[this.ip++];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem);
            int n = this.enc.length(bytes, this.s, this.end);
            if (this.s + n > this.range || this.enc.isNewLine(bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharStarSb() {
        int mem = this.code[this.ip++];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem);
            if (bytes[this.s] == 10) {
                this.opFail();
                return;
            }
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharMLStar() {
        int mem = this.code[this.ip++];
        byte[] bytes = this.bytes;
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem);
            int n = this.enc.length(bytes, this.s, this.end);
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.s += n;
        }
        this.sprev = this.sbegin;
    }

    private void opStateCheckAnyCharMLStarSb() {
        int mem = this.code[this.ip++];
        while (this.s < this.range) {
            if (this.stateCheckVal(this.s, mem)) {
                this.opFail();
                return;
            }
            this.pushAltWithStateCheck(this.ip, this.s, this.sprev, mem);
            this.sprev = this.s++;
        }
        this.sprev = this.sbegin;
    }

    private void opWord() {
        if (this.s >= this.range || !this.enc.isMbcWord(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opWordSb() {
        if (this.s >= this.range || !this.enc.isWord(this.bytes[this.s] & 0xFF)) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opNotWord() {
        if (this.s >= this.range || this.enc.isMbcWord(this.bytes, this.s, this.end)) {
            this.opFail();
            return;
        }
        this.s += this.enc.length(this.bytes, this.s, this.end);
        this.sprev = this.sbegin;
    }

    private void opNotWordSb() {
        if (this.s >= this.range || this.enc.isWord(this.bytes[this.s] & 0xFF)) {
            this.opFail();
            return;
        }
        ++this.s;
        this.sprev = this.sbegin;
    }

    private void opWordBound() {
        if (this.s == this.str) {
            if (this.s >= this.range || !this.enc.isMbcWord(this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (!this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isMbcWord(this.bytes, this.s, this.end) == this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opWordBoundSb() {
        if (this.s == this.str) {
            if (this.s >= this.range || !this.enc.isWord(this.bytes[this.s] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev >= this.end || !this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isWord(this.bytes[this.s] & 0xFF) == this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBound() {
        if (this.s == this.str) {
            if (this.s < this.range && this.enc.isMbcWord(this.bytes, this.s, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isMbcWord(this.bytes, this.s, this.end) != this.enc.isMbcWord(this.bytes, this.sprev, this.end)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBoundSb() {
        if (this.s == this.str) {
            if (this.s < this.range && this.enc.isWord(this.bytes[this.s] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.s == this.end) {
            if (this.sprev < this.end && this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
                this.opFail();
                return;
            }
        } else if (this.enc.isWord(this.bytes[this.s] & 0xFF) != this.enc.isWord(this.bytes[this.sprev] & 0xFF)) {
            this.opFail();
            return;
        }
    }

    private void opWordBegin() {
        if (this.s < this.range && this.enc.isMbcWord(this.bytes, this.s, this.end) && (this.s == this.str || !this.enc.isMbcWord(this.bytes, this.sprev, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordBeginSb() {
        if (this.s < this.range && this.enc.isWord(this.bytes[this.s] & 0xFF) && (this.s == this.str || !this.enc.isWord(this.bytes[this.sprev] & 0xFF))) {
            return;
        }
        this.opFail();
    }

    private void opWordEnd() {
        if (this.s != this.str && this.enc.isMbcWord(this.bytes, this.sprev, this.end) && (this.s == this.end || !this.enc.isMbcWord(this.bytes, this.s, this.end))) {
            return;
        }
        this.opFail();
    }

    private void opWordEndSb() {
        if (this.s != this.str && this.enc.isWord(this.bytes[this.sprev] & 0xFF) && (this.s == this.end || !this.enc.isWord(this.bytes[this.s] & 0xFF))) {
            return;
        }
        this.opFail();
    }

    private void opBeginBuf() {
        if (this.s != this.str) {
            this.opFail();
        }
    }

    private void opEndBuf() {
        if (this.s != this.end) {
            this.opFail();
        }
    }

    private void opBeginLine() {
        if (this.s == this.str) {
            if (Option.isNotBol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.sprev, this.end) && this.s != this.end) {
            return;
        }
        this.opFail();
    }

    private void opEndLine() {
        if (this.s == this.end) {
            if ((this.str == this.end || !this.enc.isNewLine(this.bytes, this.sprev, this.end)) && Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end)) {
            return;
        }
        this.opFail();
    }

    private void opSemiEndBuf() {
        if (this.s == this.end) {
            if ((this.str == this.end || !this.enc.isNewLine(this.bytes, this.sprev, this.end)) && Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.enc.isNewLine(this.bytes, this.s, this.end) && this.s + this.enc.length(this.bytes, this.s, this.end) == this.end) {
            return;
        }
        this.opFail();
    }

    private void opBeginPosition() {
        if (this.s != this.msaStart) {
            this.opFail();
        }
    }

    private void opMemoryStartPush() {
        int mem = this.code[this.ip++];
        this.pushMemStart(mem, this.s);
    }

    private void opMemoryStart() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memStartStk + mem] = this.s;
    }

    private void opMemoryEndPush() {
        int mem = this.code[this.ip++];
        this.pushMemEnd(mem, this.s);
    }

    private void opMemoryEnd() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memEndStk + mem] = this.s;
    }

    private void opMemoryEndPushRec() {
        int mem = this.code[this.ip++];
        int stkp = this.getMemStart(mem);
        this.pushMemEnd(mem, this.s);
        this.repeatStk[this.memStartStk + mem] = stkp;
    }

    private void opMemoryEndRec() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memEndStk + mem] = this.s;
        int stkp = this.getMemStart(mem);
        this.repeatStk[this.memStartStk + mem] = BitStatus.bsAt(this.regex.btMemStart, mem) ? stkp : this.stack[stkp].getMemPStr();
        this.pushMemEndMark(mem);
    }

    private boolean backrefInvalid(int mem) {
        return this.repeatStk[this.memEndStk + mem] == -1 || this.repeatStk[this.memStartStk + mem] == -1;
    }

    private int backrefStart(int mem) {
        return BitStatus.bsAt(this.regex.btMemStart, mem) ? this.stack[this.repeatStk[this.memStartStk + mem]].getMemPStr() : this.repeatStk[this.memStartStk + mem];
    }

    private int backrefEnd(int mem) {
        return BitStatus.bsAt(this.regex.btMemEnd, mem) ? this.stack[this.repeatStk[this.memEndStk + mem]].getMemPStr() : this.repeatStk[this.memEndStk + mem];
    }

    private void backref(int mem) {
        if (mem > this.regex.numMem || this.backrefInvalid(mem)) {
            this.opFail();
            return;
        }
        int pstart = this.backrefStart(mem);
        int pend = this.backrefEnd(mem);
        int n = pend - pstart;
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.sprev = this.s;
        while (n-- > 0) {
            if (this.bytes[pstart++] == this.bytes[this.s++]) continue;
            this.opFail();
            return;
        }
        if (this.sprev < this.range) {
            int len;
            while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += len;
            }
        }
    }

    private void opBackRef1() {
        this.backref(1);
    }

    private void opBackRef2() {
        this.backref(2);
    }

    private void opBackRefN() {
        this.backref(this.code[this.ip++]);
    }

    private void opBackRefNIC() {
        int len;
        int mem;
        if ((mem = this.code[this.ip++]) > this.regex.numMem || this.backrefInvalid(mem)) {
            this.opFail();
            return;
        }
        int pstart = this.backrefStart(mem);
        int pend = this.backrefEnd(mem);
        int n = pend - pstart;
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        this.sprev = this.s;
        this.value = this.s;
        if (!this.stringCmpIC(this.regex.caseFoldFlag, pstart, this, n, this.end)) {
            this.opFail();
            return;
        }
        this.s = this.value;
        while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
            this.sprev += len;
        }
    }

    private void opBackRefMulti() {
        int i;
        int tlen = this.code[this.ip++];
        block0: for (i = 0; i < tlen; ++i) {
            int mem;
            if (this.backrefInvalid(mem = this.code[this.ip++])) continue;
            int pstart = this.backrefStart(mem);
            int pend = this.backrefEnd(mem);
            int n = pend - pstart;
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            int swork = this.s;
            while (n-- > 0) {
                if (this.bytes[pstart++] == this.bytes[swork++]) continue;
                continue block0;
            }
            this.s = swork;
            if (this.sprev < this.range) {
                int len;
                while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                    this.sprev += len;
                }
            }
            this.ip += tlen - i - 1;
            break;
        }
        if (i == tlen) {
            this.opFail();
            return;
        }
    }

    private void opBackRefMultiIC() {
        int i;
        int tlen = this.code[this.ip++];
        for (i = 0; i < tlen; ++i) {
            int len;
            int mem;
            if (this.backrefInvalid(mem = this.code[this.ip++])) continue;
            int pstart = this.backrefStart(mem);
            int pend = this.backrefEnd(mem);
            int n = pend - pstart;
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.sprev = this.s;
            this.value = this.s;
            if (!this.stringCmpIC(this.regex.caseFoldFlag, pstart, this, n, this.end)) continue;
            this.s = this.value;
            while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += len;
            }
            this.ip += tlen - i - 1;
            break;
        }
        if (i == tlen) {
            this.opFail();
            return;
        }
    }

    private boolean memIsInMemp(int mem, int num, int memp) {
        for (int i = 0; i < num; ++i) {
            int m;
            if (mem != (m = this.code[memp++])) continue;
            return true;
        }
        return false;
    }

    private boolean backrefMatchAtNestedLevel(boolean ignoreCase, int caseFoldFlag, int nest, int memNum, int memp) {
        int pend = -1;
        int level = 0;
        for (int k = this.stk - 1; k >= 0; --k) {
            StackEntry e = this.stack[k];
            if (e.type == 2048) {
                --level;
                continue;
            }
            if (e.type == 2304) {
                ++level;
                continue;
            }
            if (level != nest) continue;
            if (e.type == 256) {
                if (!this.memIsInMemp(e.getMemNum(), memNum, memp)) continue;
                int pstart = e.getMemPStr();
                if (pend == -1) continue;
                if (pend - pstart > this.end - this.s) {
                    return false;
                }
                int p = pstart;
                this.value = this.s;
                if (ignoreCase) {
                    if (!this.stringCmpIC(caseFoldFlag, pstart, this, pend - pstart, this.end)) {
                        return false;
                    }
                } else {
                    while (p < pend) {
                        if (this.bytes[p++] == this.bytes[this.value++]) continue;
                        return false;
                    }
                }
                this.s = this.value;
                return true;
            }
            if (e.type != 33280 || !this.memIsInMemp(e.getMemNum(), memNum, memp)) continue;
            pend = e.getMemPStr();
        }
        return false;
    }

    private void opBackRefAtLevel() {
        int ic = this.code[this.ip++];
        int level = this.code[this.ip++];
        int tlen = this.code[this.ip++];
        this.sprev = this.s;
        if (this.backrefMatchAtNestedLevel(ic != 0, this.regex.caseFoldFlag, level, tlen, this.ip)) {
            int len;
            while (this.sprev + (len = this.enc.length(this.bytes, this.sprev, this.end)) < this.s) {
                this.sprev += len;
            }
            this.ip += tlen;
        } else {
            this.opFail();
            return;
        }
    }

    private void opSetOptionPush() {
        this.pushAlt(this.ip, this.s, this.sprev);
        this.ip += 3;
    }

    private void opSetOption() {
    }

    private void opNullCheckStart() {
        int mem = this.code[this.ip++];
        this.pushNullCheckStart(mem, this.s);
    }

    private void nullCheckFound() {
        switch (this.code[this.ip++]) {
            case 55: 
            case 56: {
                ++this.ip;
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                ++this.ip;
                break;
            }
            default: {
                throw new InternalException("unexpected bytecode (bug)");
            }
        }
    }

    private void opNullCheckEnd() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheck(mem = this.code[this.ip++], this.s)) != 0) {
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemST() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheckMemSt(mem = this.code[this.ip++], this.s)) != 0) {
            if (isNull == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemSTPush() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheckMemStRec(mem = this.code[this.ip++], this.s)) != 0) {
            if (isNull == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        } else {
            this.pushNullCheckEnd(mem);
        }
    }

    private void opJump() {
        this.ip += this.code[this.ip] + 1;
    }

    private void opPush() {
        int addr = this.code[this.ip++];
        this.pushAlt(this.ip + addr, this.s, this.sprev);
    }

    private void opStateCheckPush() {
        int mem;
        if (this.stateCheckVal(this.s, mem = this.code[this.ip++])) {
            this.opFail();
            return;
        }
        int addr = this.code[this.ip++];
        this.pushAltWithStateCheck(this.ip + addr, this.s, this.sprev, mem);
    }

    private void opStateCheckPushOrJump() {
        int mem = this.code[this.ip++];
        int addr = this.code[this.ip++];
        if (this.stateCheckVal(this.s, mem)) {
            this.ip += addr;
        } else {
            this.pushAltWithStateCheck(this.ip + addr, this.s, this.sprev, mem);
        }
    }

    private void opStateCheck() {
        int mem;
        if (this.stateCheckVal(this.s, mem = this.code[this.ip++])) {
            this.opFail();
            return;
        }
        this.pushStateCheck(this.s, mem);
    }

    private void opPop() {
        this.popOne();
    }

    private void opPushOrJumpExact1() {
        int addr = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.bytes[this.s]) {
            ++this.ip;
            this.pushAlt(this.ip + addr, this.s, this.sprev);
            return;
        }
        this.ip += addr + 1;
    }

    private void opPushIfPeekNext() {
        int addr = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.bytes[this.s]) {
            ++this.ip;
            this.pushAlt(this.ip + addr, this.s, this.sprev);
            return;
        }
        ++this.ip;
    }

    private void opRepeat() {
        int mem = this.code[this.ip++];
        int addr = this.code[this.ip++];
        this.repeatStk[mem] = this.stk;
        this.pushRepeat(mem, this.ip);
        if (this.regex.repeatRangeLo[mem] == 0) {
            this.pushAlt(this.ip + addr, this.s, this.sprev);
        }
    }

    private void opRepeatNG() {
        int mem = this.code[this.ip++];
        int addr = this.code[this.ip++];
        this.repeatStk[mem] = this.stk;
        this.pushRepeat(mem, this.ip);
        if (this.regex.repeatRangeLo[mem] == 0) {
            this.pushAlt(this.ip, this.s, this.sprev);
            this.ip += addr;
        }
    }

    private void repeatInc(int mem, int si) {
        StackEntry e = this.stack[si];
        e.increaseRepeatCount();
        if (e.getRepeatCount() < this.regex.repeatRangeHi[mem]) {
            if (e.getRepeatCount() >= this.regex.repeatRangeLo[mem]) {
                this.pushAlt(this.ip, this.s, this.sprev);
                this.ip = e.getRepeatPCode();
            } else {
                this.ip = e.getRepeatPCode();
            }
        }
        this.pushRepeatInc(si);
    }

    private void opRepeatInc() {
        int mem = this.code[this.ip++];
        int si = this.repeatStk[mem];
        this.repeatInc(mem, si);
    }

    private void opRepeatIncSG() {
        int mem = this.code[this.ip++];
        int si = this.getRepeat(mem);
        this.repeatInc(mem, si);
    }

    private void repeatIncNG(int mem, int si) {
        StackEntry e = this.stack[si];
        e.increaseRepeatCount();
        if (e.getRepeatCount() < this.regex.repeatRangeHi[mem]) {
            if (e.getRepeatCount() >= this.regex.repeatRangeLo[mem]) {
                int pcode = e.getRepeatPCode();
                this.pushRepeatInc(si);
                this.pushAlt(pcode, this.s, this.sprev);
            } else {
                this.ip = e.getRepeatPCode();
                this.pushRepeatInc(si);
            }
        } else if (e.getRepeatCount() == this.regex.repeatRangeHi[mem]) {
            this.pushRepeatInc(si);
        }
    }

    private void opRepeatIncNG() {
        int mem = this.code[this.ip++];
        int si = this.repeatStk[mem];
        this.repeatIncNG(mem, si);
    }

    private void opRepeatIncNGSG() {
        int mem = this.code[this.ip++];
        int si = this.getRepeat(mem);
        this.repeatIncNG(mem, si);
    }

    private void opPushPos() {
        this.pushPos(this.s, this.sprev);
    }

    private void opPopPos() {
        StackEntry e = this.stack[this.posEnd()];
        this.s = e.getStatePStr();
        this.sprev = e.getStatePStrPrev();
    }

    private void opPushPosNot() {
        int addr = this.code[this.ip++];
        this.pushPosNot(this.ip + addr, this.s, this.sprev);
    }

    private void opFailPos() {
        this.popTilPosNot();
        this.opFail();
    }

    private void opPushStopBT() {
        this.pushStopBT();
    }

    private void opPopStopBT() {
        this.stopBtEnd();
    }

    private void opLookBehind() {
        int tlen = this.code[this.ip++];
        this.s = this.enc.stepBack(this.bytes, this.str, this.s, this.end, tlen);
        if (this.s == -1) {
            this.opFail();
            return;
        }
        this.sprev = this.enc.prevCharHead(this.bytes, this.str, this.s, this.end);
    }

    private void opLookBehindSb() {
        int tlen = this.code[this.ip++];
        this.s -= tlen;
        if (this.s < this.str) {
            this.opFail();
            return;
        }
        this.sprev = this.s == this.str ? -1 : this.s - 1;
    }

    private void opPushLookBehindNot() {
        int tlen;
        int q;
        int addr = this.code[this.ip++];
        if ((q = this.enc.stepBack(this.bytes, this.str, this.s, this.end, tlen = this.code[this.ip++])) == -1) {
            this.ip += addr;
        } else {
            this.pushLookBehindNot(this.ip + addr, this.s, this.sprev);
            this.s = q;
            this.sprev = this.enc.prevCharHead(this.bytes, this.str, this.s, this.end);
        }
    }

    private void opFailLookBehindNot() {
        this.popTilLookBehindNot();
        this.opFail();
    }

    private void opCall() {
        int addr = this.code[this.ip++];
        this.pushCallFrame(this.ip);
        this.ip = addr;
    }

    private void opReturn() {
        this.ip = this.sreturn();
        this.pushReturn();
    }

    private void opFail() {
        if (this.stack == null) {
            this.ip = this.regex.codeLength - 1;
            return;
        }
        StackEntry e = this.pop();
        this.ip = e.getStatePCode();
        this.s = e.getStatePStr();
        this.sprev = e.getStatePStrPrev();
    }

    private int finish() {
        return this.bestLen;
    }
}

