/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.Workload;
import org.apache.phoenix.pherf.workload.mt.generators.LoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantLoadEventGeneratorFactory;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantWorkload
implements Workload {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTenantWorkload.class);
    private final TenantLoadEventGeneratorFactory evtGeneratorFactory = new TenantLoadEventGeneratorFactory();
    private final LoadEventGenerator<TenantOperationInfo> generator;

    public MultiTenantWorkload(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, Properties properties) {
        this.generator = this.evtGeneratorFactory.newLoadEventGenerator(phoenixUtil, model, scenario, properties);
    }

    public MultiTenantWorkload(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workHandlers, Properties properties) throws Exception {
        this.generator = this.evtGeneratorFactory.newLoadEventGenerator(phoenixUtil, model, scenario, workHandlers, properties);
    }

    @Override
    public Callable<Void> execute() throws Exception {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MultiTenantWorkload.this.generator.start();
                return null;
            }
        };
    }

    @Override
    public void complete() {
        try {
            this.generator.stop();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

