/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.schema.SchemaType;

public class SubscriptionOption {
    private final TransportCnx cnx;
    private String subscriptionName;
    private long consumerId;
    private CommandSubscribe.SubType subType;
    private int priorityLevel;
    private String consumerName;
    private boolean isDurable;
    private MessageId startMessageId;
    private Map<String, String> metadata;
    private boolean readCompacted;
    private CommandSubscribe.InitialPosition initialPosition;
    private long startMessageRollbackDurationSec;
    private Boolean replicatedSubscriptionStateArg;
    private KeySharedMeta keySharedMeta;
    private Optional<Map<String, String>> subscriptionProperties;
    private long consumerEpoch;
    private SchemaType schemaType;

    public static Optional<Map<String, String>> getPropertiesMap(List<KeyValue> list) {
        if (list == null) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.of(list.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue, (key1, key2) -> key1)));
    }

    @Generated
    SubscriptionOption(TransportCnx cnx, String subscriptionName, long consumerId, CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, Boolean replicatedSubscriptionStateArg, KeySharedMeta keySharedMeta, Optional<Map<String, String>> subscriptionProperties, long consumerEpoch, SchemaType schemaType) {
        this.cnx = cnx;
        this.subscriptionName = subscriptionName;
        this.consumerId = consumerId;
        this.subType = subType;
        this.priorityLevel = priorityLevel;
        this.consumerName = consumerName;
        this.isDurable = isDurable;
        this.startMessageId = startMessageId;
        this.metadata = metadata;
        this.readCompacted = readCompacted;
        this.initialPosition = initialPosition;
        this.startMessageRollbackDurationSec = startMessageRollbackDurationSec;
        this.replicatedSubscriptionStateArg = replicatedSubscriptionStateArg;
        this.keySharedMeta = keySharedMeta;
        this.subscriptionProperties = subscriptionProperties;
        this.consumerEpoch = consumerEpoch;
        this.schemaType = schemaType;
    }

    @Generated
    public static SubscriptionOptionBuilder builder() {
        return new SubscriptionOptionBuilder();
    }

    @Generated
    public TransportCnx getCnx() {
        return this.cnx;
    }

    @Generated
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @Generated
    public long getConsumerId() {
        return this.consumerId;
    }

    @Generated
    public CommandSubscribe.SubType getSubType() {
        return this.subType;
    }

    @Generated
    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    @Generated
    public String getConsumerName() {
        return this.consumerName;
    }

    @Generated
    public boolean isDurable() {
        return this.isDurable;
    }

    @Generated
    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    @Generated
    public CommandSubscribe.InitialPosition getInitialPosition() {
        return this.initialPosition;
    }

    @Generated
    public long getStartMessageRollbackDurationSec() {
        return this.startMessageRollbackDurationSec;
    }

    @Generated
    public Boolean getReplicatedSubscriptionStateArg() {
        return this.replicatedSubscriptionStateArg;
    }

    @Generated
    public KeySharedMeta getKeySharedMeta() {
        return this.keySharedMeta;
    }

    @Generated
    public Optional<Map<String, String>> getSubscriptionProperties() {
        return this.subscriptionProperties;
    }

    @Generated
    public long getConsumerEpoch() {
        return this.consumerEpoch;
    }

    @Generated
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Generated
    public static class SubscriptionOptionBuilder {
        @Generated
        private TransportCnx cnx;
        @Generated
        private String subscriptionName;
        @Generated
        private long consumerId;
        @Generated
        private CommandSubscribe.SubType subType;
        @Generated
        private int priorityLevel;
        @Generated
        private String consumerName;
        @Generated
        private boolean isDurable;
        @Generated
        private MessageId startMessageId;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private boolean readCompacted;
        @Generated
        private CommandSubscribe.InitialPosition initialPosition;
        @Generated
        private long startMessageRollbackDurationSec;
        @Generated
        private Boolean replicatedSubscriptionStateArg;
        @Generated
        private KeySharedMeta keySharedMeta;
        @Generated
        private Optional<Map<String, String>> subscriptionProperties;
        @Generated
        private long consumerEpoch;
        @Generated
        private SchemaType schemaType;

        @Generated
        SubscriptionOptionBuilder() {
        }

        @Generated
        public SubscriptionOptionBuilder cnx(TransportCnx cnx) {
            this.cnx = cnx;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder consumerId(long consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder subType(CommandSubscribe.SubType subType) {
            this.subType = subType;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder priorityLevel(int priorityLevel) {
            this.priorityLevel = priorityLevel;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder isDurable(boolean isDurable) {
            this.isDurable = isDurable;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder startMessageId(MessageId startMessageId) {
            this.startMessageId = startMessageId;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder readCompacted(boolean readCompacted) {
            this.readCompacted = readCompacted;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder initialPosition(CommandSubscribe.InitialPosition initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder startMessageRollbackDurationSec(long startMessageRollbackDurationSec) {
            this.startMessageRollbackDurationSec = startMessageRollbackDurationSec;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder replicatedSubscriptionStateArg(Boolean replicatedSubscriptionStateArg) {
            this.replicatedSubscriptionStateArg = replicatedSubscriptionStateArg;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder keySharedMeta(KeySharedMeta keySharedMeta) {
            this.keySharedMeta = keySharedMeta;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder subscriptionProperties(Optional<Map<String, String>> subscriptionProperties) {
            this.subscriptionProperties = subscriptionProperties;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder consumerEpoch(long consumerEpoch) {
            this.consumerEpoch = consumerEpoch;
            return this;
        }

        @Generated
        public SubscriptionOptionBuilder schemaType(SchemaType schemaType) {
            this.schemaType = schemaType;
            return this;
        }

        @Generated
        public SubscriptionOption build() {
            return new SubscriptionOption(this.cnx, this.subscriptionName, this.consumerId, this.subType, this.priorityLevel, this.consumerName, this.isDurable, this.startMessageId, this.metadata, this.readCompacted, this.initialPosition, this.startMessageRollbackDurationSec, this.replicatedSubscriptionStateArg, this.keySharedMeta, this.subscriptionProperties, this.consumerEpoch, this.schemaType);
        }

        @Generated
        public String toString() {
            return "SubscriptionOption.SubscriptionOptionBuilder(cnx=" + this.cnx + ", subscriptionName=" + this.subscriptionName + ", consumerId=" + this.consumerId + ", subType=" + this.subType + ", priorityLevel=" + this.priorityLevel + ", consumerName=" + this.consumerName + ", isDurable=" + this.isDurable + ", startMessageId=" + this.startMessageId + ", metadata=" + this.metadata + ", readCompacted=" + this.readCompacted + ", initialPosition=" + this.initialPosition + ", startMessageRollbackDurationSec=" + this.startMessageRollbackDurationSec + ", replicatedSubscriptionStateArg=" + this.replicatedSubscriptionStateArg + ", keySharedMeta=" + this.keySharedMeta + ", subscriptionProperties=" + this.subscriptionProperties + ", consumerEpoch=" + this.consumerEpoch + ", schemaType=" + this.schemaType + ")";
        }
    }
}

