/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.stats.MetricsUtil;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

class SchemaRegistryStats
implements AutoCloseable,
Runnable {
    private static final String NAMESPACE = "namespace";
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999, 1.0};
    public static final AttributeKey<String> REQUEST_TYPE_KEY = AttributeKey.stringKey((String)"pulsar.schema_registry.request");
    public static final AttributeKey<String> RESPONSE_TYPE_KEY = AttributeKey.stringKey((String)"pulsar.schema_registry.response");
    public static final AttributeKey<String> COMPATIBILITY_CHECK_RESPONSE_KEY = AttributeKey.stringKey((String)"pulsar.schema_registry.compatibility_check.response");
    public static final String SCHEMA_REGISTRY_REQUEST_DURATION_METRIC_NAME = "pulsar.broker.request.schema_registry.duration";
    private final DoubleHistogram latencyHistogram;
    public static final String COMPATIBLE_COUNTER_METRIC_NAME = "pulsar.broker.operation.schema_registry.compatibility_check.count";
    private final LongCounter schemaCompatibilityCounter;
    private static final Counter getOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_get_ops_failed_total", (String)"-").labelNames(new String[]{"namespace"})).create().register();
    private static final Counter putOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_put_ops_failed_total", (String)"-").labelNames(new String[]{"namespace"})).create().register();
    private static final Counter deleteOpsFailedCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_del_ops_failed_total", (String)"-").labelNames(new String[]{"namespace"})).create().register();
    private static final Counter compatibleCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_compatible_total", (String)"-").labelNames(new String[]{"namespace"})).create().register();
    private static final Counter incompatibleCounter = (Counter)((Counter.Builder)Counter.build((String)"pulsar_schema_incompatible_total", (String)"-").labelNames(new String[]{"namespace"})).create().register();
    private static final Summary deleteOpsLatency = SchemaRegistryStats.buildSummary("pulsar_schema_del_ops_latency", "-");
    private static final Summary getOpsLatency = SchemaRegistryStats.buildSummary("pulsar_schema_get_ops_latency", "-");
    private static final Summary putOpsLatency = SchemaRegistryStats.buildSummary("pulsar_schema_put_ops_latency", "-");
    private final Map<String, Long> namespaceAccess = new ConcurrentHashMap<String, Long>();
    private final ScheduledFuture<?> future;

    public SchemaRegistryStats(PulsarService pulsarService) {
        this.future = pulsarService.getExecutor().scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        Meter meter = pulsarService.getOpenTelemetry().getMeter();
        this.latencyHistogram = meter.histogramBuilder(SCHEMA_REGISTRY_REQUEST_DURATION_METRIC_NAME).setDescription("The duration of Schema Registry requests.").setUnit("s").build();
        this.schemaCompatibilityCounter = meter.counterBuilder(COMPATIBLE_COUNTER_METRIC_NAME).setDescription("The number of Schema Registry compatibility check operations performed by the broker.").setUnit("{operation}").build();
    }

    private static Summary buildSummary(String name, String help) {
        Summary.Builder builder = (Summary.Builder)Summary.build((String)name, (String)help).labelNames(new String[]{NAMESPACE});
        for (double quantile : QUANTILES) {
            builder.quantile(quantile, 0.01);
        }
        return (Summary)builder.create().register();
    }

    void recordDelFailed(String schemaId, long millis) {
        ((Counter.Child)deleteOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
        this.recordOperationLatency(schemaId, millis, RequestType.DELETE, ResponseType.FAILURE);
    }

    void recordGetFailed(String schemaId, long millis) {
        ((Counter.Child)getOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
        this.recordOperationLatency(schemaId, millis, RequestType.GET, ResponseType.FAILURE);
    }

    void recordListFailed(String schemaId, long millis) {
        ((Counter.Child)getOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
        this.recordOperationLatency(schemaId, millis, RequestType.LIST, ResponseType.FAILURE);
    }

    void recordPutFailed(String schemaId, long millis) {
        ((Counter.Child)putOpsFailedCounter.labels(new String[]{this.getNamespace(schemaId)})).inc();
        this.recordOperationLatency(schemaId, millis, RequestType.PUT, ResponseType.FAILURE);
    }

    void recordDelLatency(String schemaId, long millis) {
        ((Summary.Child)deleteOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
        this.recordOperationLatency(schemaId, millis, RequestType.DELETE, ResponseType.SUCCESS);
    }

    void recordGetLatency(String schemaId, long millis) {
        ((Summary.Child)getOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
        this.recordOperationLatency(schemaId, millis, RequestType.GET, ResponseType.SUCCESS);
    }

    void recordListLatency(String schemaId, long millis) {
        ((Summary.Child)getOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
        this.recordOperationLatency(schemaId, millis, RequestType.LIST, ResponseType.SUCCESS);
    }

    void recordPutLatency(String schemaId, long millis) {
        ((Summary.Child)putOpsLatency.labels(new String[]{this.getNamespace(schemaId)})).observe((double)millis);
        this.recordOperationLatency(schemaId, millis, RequestType.PUT, ResponseType.SUCCESS);
    }

    private void recordOperationLatency(String schemaId, long millis, RequestType requestType, ResponseType responseType) {
        double duration = MetricsUtil.convertToSeconds((long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
        String namespace = this.getNamespace(schemaId);
        Attributes attributes = Attributes.builder().put(OpenTelemetryAttributes.PULSAR_NAMESPACE, (Object)namespace).putAll(requestType.attributes).putAll(responseType.attributes).build();
        this.latencyHistogram.record(duration, attributes);
    }

    void recordSchemaIncompatible(String schemaId) {
        String namespace = this.getNamespace(schemaId);
        ((Counter.Child)incompatibleCounter.labels(new String[]{namespace})).inc();
        this.recordSchemaCompabilityResult(namespace, CompatibilityCheckResponse.INCOMPATIBLE);
    }

    void recordSchemaCompatible(String schemaId) {
        String namespace = this.getNamespace(schemaId);
        ((Counter.Child)compatibleCounter.labels(new String[]{namespace})).inc();
        this.recordSchemaCompabilityResult(namespace, CompatibilityCheckResponse.COMPATIBLE);
    }

    private void recordSchemaCompabilityResult(String namespace, CompatibilityCheckResponse result) {
        Attributes attributes = Attributes.builder().put(OpenTelemetryAttributes.PULSAR_NAMESPACE, (Object)namespace).putAll(result.attributes).build();
        this.schemaCompatibilityCounter.add(1L, attributes);
    }

    private String getNamespace(String schemaId) {
        String namespace;
        try {
            namespace = TopicName.get((String)schemaId).getNamespace();
        }
        catch (IllegalArgumentException t) {
            namespace = "unknown";
        }
        this.namespaceAccess.put(namespace, System.currentTimeMillis());
        return namespace;
    }

    private void removeChild(String namespace) {
        getOpsFailedCounter.remove(new String[]{namespace});
        putOpsFailedCounter.remove(new String[]{namespace});
        deleteOpsFailedCounter.remove(new String[]{namespace});
        compatibleCounter.remove(new String[]{namespace});
        incompatibleCounter.remove(new String[]{namespace});
        deleteOpsLatency.remove(new String[]{namespace});
        getOpsLatency.remove(new String[]{namespace});
        putOpsLatency.remove(new String[]{namespace});
    }

    @Override
    public synchronized void close() throws Exception {
        this.namespaceAccess.keySet().forEach(this::removeChild);
        this.future.cancel(false);
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        long interval = TimeUnit.MINUTES.toMillis(5L);
        this.namespaceAccess.entrySet().removeIf(entry -> {
            String namespace = (String)entry.getKey();
            long accessTime = (Long)entry.getValue();
            if (now - accessTime > interval) {
                this.removeChild(namespace);
                return true;
            }
            return false;
        });
    }

    @VisibleForTesting
    static enum RequestType {
        GET,
        LIST,
        PUT,
        DELETE;

        public final Attributes attributes = Attributes.of(REQUEST_TYPE_KEY, (Object)this.name().toLowerCase());
    }

    @VisibleForTesting
    static enum ResponseType {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(RESPONSE_TYPE_KEY, (Object)this.name().toLowerCase());
    }

    @VisibleForTesting
    static enum CompatibilityCheckResponse {
        COMPATIBLE,
        INCOMPATIBLE;

        public final Attributes attributes = Attributes.of(COMPATIBILITY_CHECK_RESPONSE_KEY, (Object)this.name().toLowerCase());
    }
}

