/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.StampedLock;
import lombok.Generated;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ActiveManagedCursorContainer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveManagedCursorContainerImpl
implements ActiveManagedCursorContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActiveManagedCursorContainerImpl.class);
    int trackedNodeCount = 0;
    private final long continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis;
    private volatile long cursorRemovedTimestampMillis;
    private volatile int cursorCount;
    private Node head = null;
    private Node tail = null;
    private final ConcurrentMap<String, Node> cursors = new ConcurrentHashMap<String, Node>();
    private final Map<String, Node> pendingRemovedCursors = new HashMap<String, Node>();
    private final PriorityQueue<Node> pendingPositionUpdates = new PriorityQueue<Node>(new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.position == null) {
                return 1;
            }
            if (o2.position == null) {
                return -1;
            }
            return o2.position.compareTo(o1.position);
        }
    });
    private final StampedLock rwLock = new StampedLock();

    public ActiveManagedCursorContainerImpl() {
        this(-1L);
    }

    public ActiveManagedCursorContainerImpl(long continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis) {
        this.continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis = continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis;
        this.cursorRemovedTimestampMillis = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ManagedCursor cursor, Position position) {
        long stamp = this.rwLock.writeLock();
        try {
            Node node = (Node)this.cursors.get(cursor.getName());
            if (node != null) {
                if (position == null) {
                    if (node.position != null) {
                        this.pendingRemovedCursors.put(cursor.getName(), node);
                        node.pendingRemove = true;
                    }
                    node.pendingPosition = null;
                } else {
                    if (node.pendingPosition == null) {
                        this.pendingPositionUpdates.add(node);
                    }
                    node.pendingPosition = position;
                }
            } else {
                if (position != null && (node = this.pendingRemovedCursors.remove(cursor.getName())) != null) {
                    node.pendingRemove = false;
                }
                if (node == null) {
                    node = new Node(cursor, position);
                }
                if (position != null) {
                    node.pendingPosition = position;
                    this.pendingPositionUpdates.add(node);
                }
                if (this.cursors.put(cursor.getName(), node) == null) {
                    ++this.cursorCount;
                }
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    private void insertNodeIntoList(Node node) {
        int comparison;
        ++this.trackedNodeCount;
        if (this.head == null) {
            this.head = this.tail = node;
            node.numberOfCursorsAtSamePositionOrBefore = new MutableInt(1);
            return;
        }
        Node current = this.head;
        int countBefore = 0;
        Node firstNodeWithSamePosition = null;
        while (current != null && (comparison = current.position.compareTo(node.position)) <= 0) {
            if (comparison == 0 && firstNodeWithSamePosition == null) {
                firstNodeWithSamePosition = current;
            }
            if (comparison < 0) {
                ++countBefore;
            }
            current = current.next;
        }
        MutableInt mutableInt = node.numberOfCursorsAtSamePositionOrBefore = firstNodeWithSamePosition != null ? firstNodeWithSamePosition.numberOfCursorsAtSamePositionOrBefore : new MutableInt(countBefore + 1);
        if (current == null) {
            node.prev = this.tail;
            this.tail.next = node;
            this.tail = node;
        } else if (current == this.head) {
            node.next = this.head;
            this.head.prev = node;
            this.head = node;
        } else {
            node.prev = current.prev;
            node.next = current;
            current.prev.next = node;
            current.prev = node;
        }
        Node counterUpdateStartNode = firstNodeWithSamePosition != null ? firstNodeWithSamePosition : node.next;
        this.updateCounters(counterUpdateStartNode, true);
    }

    private void updateCounters(Node startNode, boolean increment) {
        if (startNode == null) {
            return;
        }
        Node current = startNode;
        Position lastUpdatedPosition = null;
        while (current != null) {
            if (lastUpdatedPosition == null || current.position.compareTo(lastUpdatedPosition) != 0) {
                lastUpdatedPosition = current.position;
                MutableInt numberOfCursorsAtSamePositionOrBefore = current.numberOfCursorsAtSamePositionOrBefore;
                if (increment) {
                    numberOfCursorsAtSamePositionOrBefore.increment();
                } else {
                    numberOfCursorsAtSamePositionOrBefore.decrement();
                }
            }
            current = current.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedCursor get(String name) {
        long stamp = this.rwLock.readLock();
        try {
            Node node = (Node)this.cursors.get(name);
            ManagedCursor managedCursor = node != null ? node.cursor : null;
            return managedCursor;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCursor(String name) {
        long stamp = this.rwLock.writeLock();
        try {
            Node node = (Node)this.cursors.remove(name);
            if (node != null) {
                if (node.position != null) {
                    this.pendingRemovedCursors.put(name, node);
                    node.pendingRemove = true;
                }
                node.pendingPosition = null;
                this.cursorRemovedTimestampMillis = System.currentTimeMillis();
                --this.cursorCount;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    private void removeNodeFromList(Node node) {
        Node firstNodeWithSamePositionBeforeNode = ActiveManagedCursorContainerImpl.findFirstNodeWithSamePositionBeforeNode(node);
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
        this.updateCounters(firstNodeWithSamePositionBeforeNode != null ? firstNodeWithSamePositionBeforeNode : node.next, false);
        node.prev = null;
        node.next = null;
        --this.trackedNodeCount;
    }

    private static Node findFirstNodeWithSamePositionBeforeNode(Node node) {
        Position samePosition = node.position;
        Node firstNodeWithSamePositionBeforeNode = null;
        Node current = node.prev;
        while (current != null && current.position.compareTo(samePosition) == 0) {
            firstNodeWithSamePositionBeforeNode = current;
            current = current.prev;
        }
        return firstNodeWithSamePositionBeforeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCursor(ManagedCursor cursor, Position newPosition) {
        Objects.requireNonNull(cursor);
        long stamp = this.rwLock.writeLock();
        try {
            Node node = (Node)this.cursors.get(cursor.getName());
            if (node == null) {
                return;
            }
            if (newPosition == null) {
                this.pendingRemovedCursors.put(cursor.getName(), node);
                node.pendingRemove = true;
                node.pendingPosition = null;
            } else {
                if (node.pendingRemove) {
                    node.pendingRemove = false;
                    this.pendingRemovedCursors.remove(cursor.getName());
                }
                if (node.pendingPosition == null) {
                    this.pendingPositionUpdates.add(node);
                }
                node.pendingPosition = newPosition;
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    private void processPendingPositions() {
        if (this.pendingRemovedCursors.isEmpty() && this.pendingPositionUpdates.isEmpty()) {
            return;
        }
        if (this.pendingPositionUpdates.size() >= this.trackedNodeCount / 2) {
            this.rebuildEntireList();
            this.pendingPositionUpdates.clear();
        } else {
            this.performIncrementalUpdate();
        }
    }

    private void performIncrementalUpdate() {
        Node node;
        if (!this.pendingRemovedCursors.isEmpty()) {
            for (Node node2 : this.pendingRemovedCursors.values()) {
                this.removeNodeFromList(node2);
                node2.pendingRemove = false;
            }
            this.pendingRemovedCursors.clear();
        }
        while ((node = this.pendingPositionUpdates.poll()) != null) {
            if (node.pendingPosition == null) continue;
            if (node.position == null) {
                node.position = node.pendingPosition;
                this.insertNodeIntoList(node);
            } else {
                this.moveNodeToNewPosition(node, node.position, node.pendingPosition);
            }
            node.pendingPosition = null;
        }
    }

    private void rebuildEntireList() {
        this.head = null;
        this.tail = null;
        this.trackedNodeCount = 0;
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        for (Node node : this.cursors.values()) {
            if (node.pendingPosition != null) {
                node.position = node.pendingPosition;
                node.pendingPosition = null;
            }
            if (node.position != null && !node.pendingRemove) {
                activeNodes.add(node);
                ++this.trackedNodeCount;
            }
            node.pendingRemove = false;
        }
        this.pendingRemovedCursors.clear();
        activeNodes.sort((n1, n2) -> {
            int cmp = n1.position.compareTo(n2.position);
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        });
        Node prev = null;
        MutableInt currentCounter = null;
        Position lastPosition = null;
        int runningCount = 0;
        for (Node node : activeNodes) {
            node.prev = prev;
            node.next = null;
            if (prev != null) {
                prev.next = node;
            } else {
                this.head = node;
            }
            if (lastPosition == null || !node.position.equals(lastPosition)) {
                currentCounter = new MutableInt(++runningCount);
                lastPosition = node.position;
            } else {
                currentCounter.increment();
                ++runningCount;
            }
            node.numberOfCursorsAtSamePositionOrBefore = currentCounter;
            prev = node;
        }
        this.tail = prev;
    }

    @Override
    public Pair<Position, Position> cursorUpdated(ManagedCursor cursor, Position newPosition) {
        throw new UnsupportedOperationException("cursorUpdated method is not supported by this implementation");
    }

    private void moveNodeToNewPosition(Node node, Position oldPosition, Position newPosition) {
        boolean movingForward;
        if (oldPosition.compareTo(newPosition) == 0) {
            return;
        }
        boolean bl = movingForward = oldPosition.compareTo(newPosition) < 0;
        if (this.isAlreadyInCorrectPosition(node, newPosition)) {
            node.position = newPosition;
            if (node == this.tail) {
                return;
            }
            if (movingForward) {
                node.numberOfCursorsAtSamePositionOrBefore.decrement();
            }
            if (node.prev != null && node.prev.position.compareTo(newPosition) == 0) {
                node.numberOfCursorsAtSamePositionOrBefore = node.prev.numberOfCursorsAtSamePositionOrBefore;
                node.numberOfCursorsAtSamePositionOrBefore.increment();
            } else if (node.next != null && node.next.position.compareTo(newPosition) == 0) {
                node.numberOfCursorsAtSamePositionOrBefore = node.next.numberOfCursorsAtSamePositionOrBefore;
            } else {
                int base = node.prev != null ? node.prev.numberOfCursorsAtSamePositionOrBefore.intValue() : 0;
                node.numberOfCursorsAtSamePositionOrBefore = new MutableInt(base + 1);
            }
            return;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
        Position lastProcessedPosition = null;
        if (movingForward) {
            node.numberOfCursorsAtSamePositionOrBefore.decrement();
            lastProcessedPosition = oldPosition;
            Node current = node.next;
            while (current != null && current.position.compareTo(newPosition) < 0) {
                if (current.position.compareTo(lastProcessedPosition) != 0) {
                    current.numberOfCursorsAtSamePositionOrBefore.decrement();
                    lastProcessedPosition = current.position;
                }
                current = current.next;
            }
            this.insertNodeAtNewPositionForward(node, current, newPosition);
        } else {
            lastProcessedPosition = oldPosition;
            Node current = node.prev;
            while (current != null && current.position.compareTo(newPosition) > 0) {
                if (current.position.compareTo(lastProcessedPosition) != 0) {
                    current.numberOfCursorsAtSamePositionOrBefore.increment();
                    lastProcessedPosition = current.position;
                }
                current = current.prev;
            }
            this.insertNodeAtNewPositionBackward(node, current, newPosition);
        }
        node.position = newPosition;
    }

    private void insertNodeAtNewPositionForward(Node node, Node current, Position newPosition) {
        if (current == null) {
            node.prev = this.tail;
            node.next = null;
            if (this.tail != null) {
                this.tail.next = node;
            } else {
                this.head = node;
            }
            this.tail = node;
            node.numberOfCursorsAtSamePositionOrBefore = new MutableInt(node.prev.numberOfCursorsAtSamePositionOrBefore.intValue() + 1);
            return;
        }
        if (current.position.compareTo(newPosition) == 0) {
            node.prev = current.prev;
            node.next = current;
            if (current.prev != null) {
                current.prev.next = node;
            } else {
                this.head = node;
            }
            current.prev = node;
            node.numberOfCursorsAtSamePositionOrBefore = current.numberOfCursorsAtSamePositionOrBefore;
            return;
        }
        node.prev = current.prev;
        node.next = current;
        if (current.prev != null) {
            current.prev.next = node;
        } else {
            this.head = node;
        }
        current.prev = node;
        node.numberOfCursorsAtSamePositionOrBefore = new MutableInt(node.prev != null ? node.prev.numberOfCursorsAtSamePositionOrBefore.intValue() + 1 : 1);
    }

    private void insertNodeAtNewPositionBackward(Node node, Node current, Position newPosition) {
        if (current == null) {
            node.prev = null;
            node.next = this.head;
            if (this.head != null) {
                this.head.prev = node;
            }
            this.head = node;
            if (this.tail == null) {
                this.tail = node;
            }
            node.numberOfCursorsAtSamePositionOrBefore = new MutableInt(1);
            return;
        }
        if (current.position.compareTo(newPosition) == 0) {
            node.prev = current;
            node.next = current.next;
            if (current.next != null) {
                current.next.prev = node;
            } else {
                this.tail = node;
            }
            current.next = node;
            node.numberOfCursorsAtSamePositionOrBefore = current.numberOfCursorsAtSamePositionOrBefore;
            node.numberOfCursorsAtSamePositionOrBefore.increment();
            return;
        }
        node.prev = current;
        node.next = current.next;
        if (current.next != null) {
            current.next.prev = node;
        } else {
            this.tail = node;
        }
        current.next = node;
        node.numberOfCursorsAtSamePositionOrBefore = new MutableInt(current.numberOfCursorsAtSamePositionOrBefore.intValue() + 1);
    }

    private boolean isAlreadyInCorrectPosition(Node node, Position newPosition) {
        if (node.prev != null && node.prev.position.compareTo(newPosition) > 0) {
            return false;
        }
        return node.next == null || node.next.position.compareTo(newPosition) >= 0;
    }

    private Position internalSlowestReaderPosition() {
        this.processPendingPositions();
        return this.head != null ? this.head.position : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position getSlowestCursorPosition() {
        long stamp = this.rwLock.readLock();
        try {
            Position position = this.internalSlowestReaderPosition();
            return position;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long stamp = this.rwLock.readLock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            boolean first = true;
            for (Node node : this.cursors.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(node.cursor);
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    @Override
    public Iterator<ManagedCursor> iterator() {
        final Iterator it = this.cursors.entrySet().iterator();
        return new Iterator<ManagedCursor>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ManagedCursor next() {
                return ((Node)((Map.Entry)it.next()).getValue()).cursor;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Cannot remove ManagedCursor from container");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfCursorsAtSamePositionOrBefore(ManagedCursor cursor) {
        long stamp = this.rwLock.writeLock();
        try {
            this.processPendingPositions();
            Node node = (Node)this.cursors.get(cursor.getName());
            if (node == null || node.position == null) {
                int n = 0;
                return n;
            }
            int n = node.numberOfCursorsAtSamePositionOrBefore.intValue();
            return n;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    @Override
    public int size() {
        return this.cursorCount;
    }

    @Override
    public boolean shouldCacheAddedEntry() {
        long sinceLastCursorLeftMillis;
        if (!this.isEmpty()) {
            return true;
        }
        return this.continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis > 0L && (sinceLastCursorLeftMillis = System.currentTimeMillis() - this.cursorRemovedTimestampMillis) < this.continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkOrderingAndNumberOfCursorsState() {
        long stamp = this.rwLock.readLock();
        try {
            this.processPendingPositions();
            Node current = this.head;
            int currentCount = 0;
            Position lastPosition = null;
            ArrayList<String> lastPositionCursorNames = new ArrayList<String>();
            while (current != null) {
                if (current.prev != null && current.position.compareTo(current.prev.position) < 0) {
                    throw new IllegalStateException("Cursors are not ordered: " + current.cursor.getName() + " with position " + String.valueOf(current.position) + " is after cursor " + current.prev.cursor.getName() + " with position " + String.valueOf(current.prev.position));
                }
                ++currentCount;
                if (lastPosition == null) {
                    lastPosition = current.position;
                    lastPositionCursorNames.add(current.cursor.getName());
                } else if (current.position.compareTo(lastPosition) > 0 || current.next == null) {
                    int expectedCount;
                    if (current.position.compareTo(lastPosition) <= 0) {
                        lastPositionCursorNames.add(current.cursor.getName());
                        lastPosition = current.position;
                        expectedCount = currentCount;
                    } else {
                        expectedCount = currentCount - 1;
                    }
                    if (current.prev.numberOfCursorsAtSamePositionOrBefore.intValue() != expectedCount) {
                        throw new IllegalStateException("Number of cursors at same position is not correct for position " + String.valueOf(current.prev.position) + ": expected " + expectedCount + ", but got " + String.valueOf(current.prev.numberOfCursorsAtSamePositionOrBefore) + " for cursors " + String.valueOf(lastPositionCursorNames) + " current.next: " + String.valueOf(current.next));
                    }
                    if (current.next != null) {
                        lastPositionCursorNames.clear();
                        lastPositionCursorNames.add(current.cursor.getName());
                        lastPosition = current.position;
                    }
                } else {
                    lastPositionCursorNames.add(current.cursor.getName());
                }
                current = current.next;
            }
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    private static class Node {
        final ManagedCursor cursor;
        Position position;
        Position pendingPosition;
        boolean pendingRemove = false;
        MutableInt numberOfCursorsAtSamePositionOrBefore;
        Node prev;
        Node next;

        Node(ManagedCursor cursor, Position pendingPosition) {
            this.cursor = cursor;
            this.pendingPosition = pendingPosition;
        }
    }
}

