/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import com.google.common.annotations.VisibleForTesting;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.functions.CryptoConfig;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.functions.instance.FunctionResultRouter;
import org.apache.pulsar.functions.utils.CryptoUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBuilderFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerBuilderFactory.class);
    private final PulsarClient client;
    private final ProducerConfig producerConfig;
    private final Consumer<ProducerBuilder<?>> defaultConfigurer;
    private final Crypto crypto;

    public ProducerBuilderFactory(PulsarClient client, ProducerConfig producerConfig, ClassLoader functionClassLoader, Consumer<ProducerBuilder<?>> defaultConfigurer) {
        this.client = client;
        this.producerConfig = producerConfig;
        this.defaultConfigurer = defaultConfigurer;
        try {
            this.crypto = this.initializeCrypto(functionClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to initialize crypto config " + String.valueOf(producerConfig.getCryptoConfig()), e);
        }
        if (this.crypto == null) {
            log.info("crypto key reader is not provided, not enabling end to end encryption");
        }
    }

    public <T> ProducerBuilder<T> createProducerBuilder(String topic, Schema<T> schema, String producerName) {
        ProducerBuilder builder = this.client.newProducer(schema);
        if (this.defaultConfigurer != null) {
            this.defaultConfigurer.accept(builder);
        }
        builder.blockIfQueueFull(true).enableBatching(true).batchingMaxPublishDelay(10L, TimeUnit.MILLISECONDS).hashingScheme(HashingScheme.Murmur3_32Hash).messageRoutingMode(MessageRoutingMode.CustomPartition).messageRouter((MessageRouter)FunctionResultRouter.of()).sendTimeout(0, TimeUnit.SECONDS).topic(topic);
        if (producerName != null) {
            builder.producerName(producerName);
        }
        if (this.producerConfig != null) {
            if (this.producerConfig.getCompressionType() != null) {
                builder.compressionType(this.producerConfig.getCompressionType());
            } else {
                builder.compressionType(CompressionType.LZ4);
            }
            if (this.producerConfig.getMaxPendingMessages() != null && this.producerConfig.getMaxPendingMessages() != 0) {
                builder.maxPendingMessages(this.producerConfig.getMaxPendingMessages().intValue());
            }
            if (this.producerConfig.getMaxPendingMessagesAcrossPartitions() != null && this.producerConfig.getMaxPendingMessagesAcrossPartitions() != 0) {
                builder.maxPendingMessagesAcrossPartitions(this.producerConfig.getMaxPendingMessagesAcrossPartitions().intValue());
            }
            if (this.producerConfig.getCryptoConfig() != null) {
                builder.cryptoKeyReader(this.crypto.keyReader);
                builder.cryptoFailureAction(this.crypto.failureAction);
                for (String encryptionKeyName : this.crypto.getEncryptionKeys()) {
                    builder.addEncryptionKey(encryptionKeyName);
                }
            }
            if (this.producerConfig.getBatchBuilder() != null) {
                if (this.producerConfig.getBatchBuilder().equals("KEY_BASED")) {
                    builder.batcherBuilder(BatcherBuilder.KEY_BASED);
                } else {
                    builder.batcherBuilder(BatcherBuilder.DEFAULT);
                }
            }
            if (this.producerConfig.getBatchingConfig() != null) {
                builder.enableBatching(this.producerConfig.getBatchingConfig().isEnabled());
                if (this.producerConfig.getBatchingConfig().getBatchingMaxPublishDelayMs() != null && this.producerConfig.getBatchingConfig().getBatchingMaxPublishDelayMs() > 0) {
                    builder.batchingMaxPublishDelay((long)this.producerConfig.getBatchingConfig().getBatchingMaxPublishDelayMs().intValue(), TimeUnit.MILLISECONDS);
                }
                if (this.producerConfig.getBatchingConfig().getRoundRobinRouterBatchingPartitionSwitchFrequency() != null && this.producerConfig.getBatchingConfig().getRoundRobinRouterBatchingPartitionSwitchFrequency() > 0) {
                    builder.roundRobinRouterBatchingPartitionSwitchFrequency(this.producerConfig.getBatchingConfig().getRoundRobinRouterBatchingPartitionSwitchFrequency().intValue());
                }
                if (this.producerConfig.getBatchingConfig().getBatchingMaxMessages() != null && this.producerConfig.getBatchingConfig().getBatchingMaxMessages() > 0) {
                    builder.batchingMaxMessages(this.producerConfig.getBatchingConfig().getBatchingMaxMessages().intValue());
                }
                if (this.producerConfig.getBatchingConfig().getBatchingMaxBytes() != null && this.producerConfig.getBatchingConfig().getBatchingMaxBytes() > 0) {
                    builder.batchingMaxBytes(this.producerConfig.getBatchingConfig().getBatchingMaxBytes().intValue());
                }
                if (this.producerConfig.getBatchingConfig().getBatchBuilder() != null) {
                    if (this.producerConfig.getBatchingConfig().getBatchBuilder().equals("KEY_BASED")) {
                        builder.batcherBuilder(BatcherBuilder.KEY_BASED);
                    } else {
                        builder.batcherBuilder(BatcherBuilder.DEFAULT);
                    }
                }
            }
        }
        return builder;
    }

    @VisibleForTesting
    Crypto initializeCrypto(ClassLoader functionClassLoader) throws ClassNotFoundException {
        if (this.producerConfig == null || this.producerConfig.getCryptoConfig() == null || StringUtils.isEmpty((CharSequence)this.producerConfig.getCryptoConfig().getCryptoKeyReaderClassName())) {
            return null;
        }
        CryptoConfig cryptoConfig = this.producerConfig.getCryptoConfig();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        String[] encryptionKeys = cryptoConfig.getEncryptionKeys();
        Crypto.CryptoBuilder bldr = Crypto.builder().failureAction(cryptoConfig.getProducerCryptoFailureAction()).encryptionKeys(encryptionKeys);
        bldr.keyReader(CryptoUtils.getCryptoKeyReaderInstance((String)cryptoConfig.getCryptoKeyReaderClassName(), (Map)cryptoConfig.getCryptoKeyReaderConfig(), (ClassLoader)functionClassLoader));
        return bldr.build();
    }

    private static class Crypto {
        private CryptoKeyReader keyReader;
        private ProducerCryptoFailureAction failureAction;
        private String[] encryptionKeys;

        @Generated
        Crypto(CryptoKeyReader keyReader, ProducerCryptoFailureAction failureAction, String[] encryptionKeys) {
            this.keyReader = keyReader;
            this.failureAction = failureAction;
            this.encryptionKeys = encryptionKeys;
        }

        @Generated
        public static CryptoBuilder builder() {
            return new CryptoBuilder();
        }

        @Generated
        public CryptoKeyReader getKeyReader() {
            return this.keyReader;
        }

        @Generated
        public ProducerCryptoFailureAction getFailureAction() {
            return this.failureAction;
        }

        @Generated
        public String[] getEncryptionKeys() {
            return this.encryptionKeys;
        }

        @Generated
        public void setKeyReader(CryptoKeyReader keyReader) {
            this.keyReader = keyReader;
        }

        @Generated
        public void setFailureAction(ProducerCryptoFailureAction failureAction) {
            this.failureAction = failureAction;
        }

        @Generated
        public void setEncryptionKeys(String[] encryptionKeys) {
            this.encryptionKeys = encryptionKeys;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Crypto)) {
                return false;
            }
            Crypto other = (Crypto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CryptoKeyReader this$keyReader = this.getKeyReader();
            CryptoKeyReader other$keyReader = other.getKeyReader();
            if (this$keyReader == null ? other$keyReader != null : !this$keyReader.equals(other$keyReader)) {
                return false;
            }
            ProducerCryptoFailureAction this$failureAction = this.getFailureAction();
            ProducerCryptoFailureAction other$failureAction = other.getFailureAction();
            if (this$failureAction == null ? other$failureAction != null : !this$failureAction.equals(other$failureAction)) {
                return false;
            }
            return Arrays.deepEquals(this.getEncryptionKeys(), other.getEncryptionKeys());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Crypto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CryptoKeyReader $keyReader = this.getKeyReader();
            result = result * 59 + ($keyReader == null ? 43 : $keyReader.hashCode());
            ProducerCryptoFailureAction $failureAction = this.getFailureAction();
            result = result * 59 + ($failureAction == null ? 43 : $failureAction.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getEncryptionKeys());
            return result;
        }

        @Generated
        public String toString() {
            return "ProducerBuilderFactory.Crypto(keyReader=" + String.valueOf(this.getKeyReader()) + ", failureAction=" + String.valueOf(this.getFailureAction()) + ", encryptionKeys=" + Arrays.deepToString(this.getEncryptionKeys()) + ")";
        }

        @Generated
        public static class CryptoBuilder {
            @Generated
            private CryptoKeyReader keyReader;
            @Generated
            private ProducerCryptoFailureAction failureAction;
            @Generated
            private String[] encryptionKeys;

            @Generated
            CryptoBuilder() {
            }

            @Generated
            public CryptoBuilder keyReader(CryptoKeyReader keyReader) {
                this.keyReader = keyReader;
                return this;
            }

            @Generated
            public CryptoBuilder failureAction(ProducerCryptoFailureAction failureAction) {
                this.failureAction = failureAction;
                return this;
            }

            @Generated
            public CryptoBuilder encryptionKeys(String[] encryptionKeys) {
                this.encryptionKeys = encryptionKeys;
                return this;
            }

            @Generated
            public Crypto build() {
                return new Crypto(this.keyReader, this.failureAction, this.encryptionKeys);
            }

            @Generated
            public String toString() {
                return "ProducerBuilderFactory.Crypto.CryptoBuilder(keyReader=" + String.valueOf(this.keyReader) + ", failureAction=" + String.valueOf(this.failureAction) + ", encryptionKeys=" + Arrays.deepToString(this.encryptionKeys) + ")";
            }
        }
    }
}

