/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.command;

import java.nio.file.Path;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.config.ConfigBuilder;
import org.apache.seatunnel.core.starter.exception.ConfigCheckException;
import org.apache.seatunnel.core.starter.spark.args.SparkCommandArgs;
import org.apache.seatunnel.core.starter.spark.config.SparkApiConfigChecker;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkApiConfValidateCommand
implements Command<SparkCommandArgs> {
    private static final Logger log = LoggerFactory.getLogger(SparkApiConfValidateCommand.class);
    private final SparkCommandArgs sparkCommandArgs;

    public SparkApiConfValidateCommand(SparkCommandArgs sparkCommandArgs) {
        this.sparkCommandArgs = sparkCommandArgs;
    }

    @Override
    public void execute() throws ConfigCheckException {
        Path configPath = FileUtils.getConfigPath(this.sparkCommandArgs);
        ConfigBuilder configBuilder = new ConfigBuilder(configPath);
        new SparkApiConfigChecker().checkConfig(configBuilder.getConfig());
        log.info("config OK !");
    }
}

