/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.jet.impl.util.Util;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class KeyedWindowResult<K, R>
extends WindowResult<R>
implements Map.Entry<K, R> {
    private final K key;

    public KeyedWindowResult(long start, long end, @Nonnull K key, @Nonnull R result2, boolean isEarly) {
        super(start, end, result2, isEarly);
        this.key = key;
    }

    public KeyedWindowResult(long start, long end, @Nonnull K key, @Nonnull R result2) {
        this(start, end, key, result2, false);
    }

    @Nonnull
    public K key() {
        return this.key;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public R getValue() {
        return this.result();
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeyedWindowResult that = (KeyedWindowResult)obj;
        return this.start() == that.start() && this.end() == that.end() && this.isEarly() == that.isEarly() && Objects.equals(this.result(), that.result()) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key);
    }

    @Override
    public String toString() {
        return String.format("KeyedWindowResult{start=%s, end=%s, key='%s', value='%s', isEarly=%s}", Util.toLocalTime(this.start()), Util.toLocalTime(this.end()), this.key, this.result(), this.isEarly());
    }
}

