/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.impl.util.LoggingUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InsertWatermarksP<T>
extends AbstractProcessor {
    private final EventTimeMapper<? super T> eventTimeMapper;
    private Traverser<Object> traverser;
    private long minRestoredWm = Long.MAX_VALUE;

    public InsertWatermarksP(EventTimePolicy<? super T> eventTimePolicy) {
        this.eventTimeMapper = new EventTimeMapper<T>(eventTimePolicy);
        this.eventTimeMapper.addPartitions(1);
    }

    @Override
    public boolean tryProcess() {
        return this.tryProcessInternal(null);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        return this.tryProcessInternal(item);
    }

    private boolean tryProcessInternal(@Nullable Object item) {
        if (this.traverser == null) {
            this.traverser = this.eventTimeMapper.flatMapEvent(item, 0, Long.MIN_VALUE);
        }
        if (this.emitFromTraverser(this.traverser)) {
            this.traverser = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean saveToSnapshot() {
        return this.tryEmitToSnapshot(BroadcastKey.broadcastKey(Keys.LAST_EMITTED_WM), this.eventTimeMapper.getWatermark(0));
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        assert (((BroadcastKey)key).key().equals((Object)Keys.LAST_EMITTED_WM)) : "Unexpected key: " + key;
        this.minRestoredWm = Math.min(this.minRestoredWm, (Long)value);
    }

    @Override
    public boolean finishSnapshotRestore() {
        this.eventTimeMapper.restoreWatermark(0, this.minRestoredWm);
        LoggingUtil.logFine(this.getLogger(), "restored lastEmittedWm=%s", this.minRestoredWm);
        return true;
    }

    private static enum Keys {
        LAST_EMITTED_WM;

    }
}

