/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.ThreadHints;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LiteBlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();
    private final AtomicBoolean signalNeeded = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence2, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (cursorSequence.get() < sequence2) {
            this.lock.lock();
            try {
                do {
                    this.signalNeeded.getAndSet(true);
                    if (cursorSequence.get() >= sequence2) {
                        break;
                    }
                    barrier.checkAlert();
                    this.processorNotifyCondition.await();
                } while (cursorSequence.get() < sequence2);
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence2) {
            barrier.checkAlert();
            ThreadHints.onSpinWait();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        if (this.signalNeeded.getAndSet(false)) {
            this.lock.lock();
            try {
                this.processorNotifyCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String toString() {
        return "LiteBlockingWaitStrategy{processorNotifyCondition=" + this.processorNotifyCondition + '}';
    }
}

