/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.sedona.flink.expressions.Accumulators;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class Aggregators {

    @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
    public static class ST_Union_Aggr
    extends AggregateFunction<Geometry, Accumulators.AccGeometry> {
        public Accumulators.AccGeometry createAccumulator() {
            return new Accumulators.AccGeometry();
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry getValue(Accumulators.AccGeometry acc) {
            return acc.geom;
        }

        public void accumulate(Accumulators.AccGeometry acc, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            acc.geom = acc.geom == null ? (Geometry)o : acc.geom.union((Geometry)o);
        }

        public void retract(Accumulators.AccGeometry acc, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geometry = (Geometry)o;
            assert (false);
        }

        public void merge(Accumulators.AccGeometry acc, Iterable<Accumulators.AccGeometry> it) {
            for (Accumulators.AccGeometry a : it) {
                if (acc.geom == null) {
                    acc.geom = a.geom;
                    continue;
                }
                acc.geom = acc.geom.union(a.geom);
            }
        }

        public void resetAccumulator(Accumulators.AccGeometry acc) {
            acc.geom = null;
        }
    }

    @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
    public static class ST_Intersection_Aggr
    extends AggregateFunction<Geometry, Accumulators.AccGeometry> {
        public Accumulators.AccGeometry createAccumulator() {
            return new Accumulators.AccGeometry();
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry getValue(Accumulators.AccGeometry acc) {
            return acc.geom;
        }

        public void accumulate(Accumulators.AccGeometry acc, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            acc.geom = acc.geom == null ? (Geometry)o : acc.geom.intersection((Geometry)o);
        }

        public void retract(Accumulators.AccGeometry acc, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geometry = (Geometry)o;
            assert (false);
        }

        public void merge(Accumulators.AccGeometry acc, Iterable<Accumulators.AccGeometry> it) {
            for (Accumulators.AccGeometry a : it) {
                if (acc.geom == null) {
                    acc.geom = a.geom;
                    continue;
                }
                acc.geom = acc.geom.intersection(a.geom);
            }
        }

        public void resetAccumulator(Accumulators.AccGeometry acc) {
            acc.geom = null;
        }
    }

    @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
    public static class ST_Envelope_Aggr
    extends AggregateFunction<Geometry, Accumulators.Envelope> {
        Geometry createPolygon(double minX, double minY, double maxX, double maxY) {
            Coordinate[] coords;
            coords = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), coords[0]};
            GeometryFactory geomFact = new GeometryFactory();
            return geomFact.createPolygon(coords);
        }

        public Accumulators.Envelope createAccumulator() {
            return new Accumulators.Envelope();
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry getValue(Accumulators.Envelope acc) {
            return this.createPolygon(acc.minX, acc.minY, acc.maxX, acc.maxY);
        }

        public void accumulate(Accumulators.Envelope acc, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Envelope envelope = ((Geometry)o).getEnvelopeInternal();
            acc.minX = Math.min(acc.minX, envelope.getMinX());
            acc.minY = Math.min(acc.minY, envelope.getMinY());
            acc.maxX = Math.max(acc.maxX, envelope.getMaxX());
            acc.maxY = Math.max(acc.maxY, envelope.getMaxY());
        }

        public void retract(Accumulators.Envelope acc, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geometry = (Geometry)o;
            assert (false);
        }

        public void merge(Accumulators.Envelope acc, Iterable<Accumulators.Envelope> it) {
            for (Accumulators.Envelope a : it) {
                acc.minX = Math.min(acc.minX, a.minX);
                acc.minY = Math.min(acc.minY, a.minY);
                acc.maxX = Math.max(acc.maxX, a.maxX);
                acc.maxY = Math.max(acc.maxY, a.maxY);
            }
        }

        public void resetAccumulator(Accumulators.Envelope acc) {
            acc.reset();
        }
    }
}

