/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.internal.shared.CheckedArrayList;

public final class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedContainer<E> {
    private static final long serialVersionUID = 1999408533884863599L;
    private final Class<E> type;

    public CheckedHashSet(Class<E> type) {
        this.type = Objects.requireNonNull(type);
    }

    public CheckedHashSet(Class<E> type, int capacity) {
        super(capacity);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    @Override
    public boolean add(E element) throws IllegalArgumentException {
        if (this.type.isInstance(element)) {
            return super.add(element);
        }
        String message = CheckedArrayList.illegalElement(this, element, this.type);
        if (message == null) {
            return false;
        }
        if (element == null) {
            throw new NullPointerException(message);
        }
        throw new IllegalArgumentException(message);
    }
}

