/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;

final class ConvertedRange
extends MeasurementRange<Double> {
    private static final long serialVersionUID = -1416908614729956928L;
    private final double altMinimum;
    private final double altMaximum;

    ConvertedRange(double[] extremums, boolean isMinIncluded, boolean isMaxIncluded, Unit<?> unit) {
        super(Double.class, (Number)extremums[0], isMinIncluded, (Number)extremums[1], isMaxIncluded, unit);
        this.altMinimum = extremums[2];
        this.altMaximum = extremums[3];
    }

    private ConvertedRange(NumberRange<Double> union, ConvertedRange r1, NumberRange<Double> r2) {
        super(union, r1.unit());
        boolean f = !this.isMinIncluded();
        this.altMinimum = Math.min(r1.getMinDouble(f), r2.getMinDouble(f));
        f = !this.isMaxIncluded();
        this.altMaximum = Math.max(r1.getMaxDouble(f), r2.getMaxDouble(f));
    }

    public Range<Double> union(Range<Double> range) {
        Object union = super.union(range);
        if (union != this && union != range && union instanceof NumberRange && range instanceof NumberRange) {
            union = new ConvertedRange((NumberRange<Double>)((NumberRange)union), this, (NumberRange<Double>)((NumberRange)range));
        }
        return union;
    }

    public double getMinDouble(boolean inclusive) {
        return inclusive == this.isMinIncluded() ? this.getMinDouble() : this.altMinimum;
    }

    public double getMaxDouble(boolean inclusive) {
        return inclusive == this.isMaxIncluded() ? this.getMaxDouble() : this.altMaximum;
    }
}

