/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.HttpClient3TimeoutTransformer;
import org.apache.sling.cta.impl.HttpClient4TimeoutTransformer;
import org.apache.sling.cta.impl.JavaNetTimeoutTransformer;
import org.apache.sling.cta.impl.JdkHttpClientBuilderTimeoutTransformer;
import org.apache.sling.cta.impl.JdkHttpRequestBuilderTimeoutTransformer;
import org.apache.sling.cta.impl.Log;
import org.apache.sling.cta.impl.OkHttpTimeoutTransformer;

public class Agent {
    public static void premain(String args, Instrumentation inst) {
        String[] parsedArgs = args != null ? args.split(",") : new String[]{};
        long connectTimeout = TimeUnit.MINUTES.toMillis(1L);
        long readTimeout = TimeUnit.MINUTES.toMillis(1L);
        String logSpec = "";
        if (parsedArgs.length > 0) {
            connectTimeout = Long.parseLong(parsedArgs[0]);
        }
        if (parsedArgs.length > 1) {
            readTimeout = Long.parseLong(parsedArgs[1]);
        }
        if (parsedArgs.length > 2) {
            logSpec = parsedArgs[2];
        }
        Log.configure(logSpec);
        Log.get().log("Preparing to install URL transformers. Configured timeouts - connectTimeout : %d, readTimeout: %d", connectTimeout, readTimeout);
        AgentInfo agentInfoMBean = new AgentInfo(connectTimeout, readTimeout);
        ClassFileTransformer[] transformers = new ClassFileTransformer[]{new JavaNetTimeoutTransformer(connectTimeout, readTimeout, agentInfoMBean), new HttpClient3TimeoutTransformer(connectTimeout, readTimeout, agentInfoMBean), new HttpClient4TimeoutTransformer(connectTimeout, readTimeout, agentInfoMBean), new OkHttpTimeoutTransformer(connectTimeout, readTimeout, agentInfoMBean), new JdkHttpClientBuilderTimeoutTransformer(connectTimeout, agentInfoMBean), new JdkHttpRequestBuilderTimeoutTransformer(readTimeout, agentInfoMBean)};
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(agentInfoMBean, AgentInfo.NAME);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            Log.get().log("Failed registering MBean: %s", e.getMessage());
        }
        ArrayList<String> transformerNames = new ArrayList<String>();
        for (ClassFileTransformer transformer : transformers) {
            inst.addTransformer(transformer, true);
            transformerNames.add(transformer.getClass().getName());
        }
        Log.get().log("All transformers installed", new Object[0]);
    }

    private Agent() {
    }
}

