/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.core.SecureNodeState;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SecureNodeBuilder
implements NodeBuilder {
    private final SecureNodeBuilder rootBuilder;
    private final SecureNodeBuilder parent;
    private final String name;
    private final LazyValue<PermissionProvider> permissionProvider;
    private final NodeBuilder builder;
    private TreePermission treePermission = null;
    private TreePermission rootPermission = null;

    SecureNodeBuilder(@NotNull NodeBuilder builder, @NotNull LazyValue<PermissionProvider> permissionProvider) {
        this.rootBuilder = this;
        this.parent = null;
        this.name = null;
        this.permissionProvider = Objects.requireNonNull(permissionProvider);
        this.builder = Objects.requireNonNull(builder);
    }

    private SecureNodeBuilder(SecureNodeBuilder parent, String name) {
        this.rootBuilder = parent.rootBuilder;
        this.parent = parent;
        this.name = name;
        this.permissionProvider = parent.permissionProvider;
        this.builder = parent.builder.getChildNode(name);
    }

    @Override
    @NotNull
    public NodeState getBaseState() {
        return new SecureNodeState(this.builder.getBaseState(), this.getTreePermission());
    }

    @Override
    @NotNull
    public NodeState getNodeState() {
        return new SecureNodeState(this.builder.getNodeState(), this.getTreePermission());
    }

    @Override
    public boolean exists() {
        return this.builder.exists() && (this.builder.isReplaced() || this.getTreePermission().canRead());
    }

    @Override
    public boolean isNew() {
        return this.builder.isNew() || this.builder.isReplaced() && !this.getTreePermission().canRead();
    }

    @Override
    public boolean isNew(String name) {
        return this.builder.isNew(name) || this.builder.isReplaced(name) && !this.getTreePermission().canRead(this.builder.getProperty(name));
    }

    @Override
    public boolean isModified() {
        return this.builder.isModified();
    }

    @Override
    public boolean isReplaced() {
        return this.builder.isReplaced() && !this.isNew();
    }

    @Override
    public boolean isReplaced(String name) {
        return this.builder.isReplaced(name) && !this.isNew(name);
    }

    public void baseChanged() {
        Validate.checkState(this.parent == null);
        this.treePermission = null;
        this.rootPermission = null;
    }

    @Override
    public boolean remove() {
        return this.exists() && this.builder.remove();
    }

    @Override
    public boolean moveTo(@NotNull NodeBuilder newParent, @NotNull String newName) {
        return this.exists() && this.builder.moveTo(newParent, newName);
    }

    @Override
    @Nullable
    public PropertyState getProperty(String name) {
        PropertyState property = this.builder.getProperty(name);
        if (new ReadablePropertyPredicate().test(property)) {
            return property;
        }
        return null;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public synchronized long getPropertyCount() {
        if (this.getTreePermission().canReadProperties() || this.isNew()) {
            return this.builder.getPropertyCount();
        }
        return IterableUtils.size(IterableUtils.filter(this.builder.getProperties(), new ReadablePropertyPredicate()::test));
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        if (this.getTreePermission().canReadProperties() || this.isNew()) {
            return this.builder.getProperties();
        }
        return IterableUtils.filter(this.builder.getProperties(), new ReadablePropertyPredicate()::test);
    }

    @Override
    public boolean getBoolean(@NotNull String name) {
        PropertyState property = this.getProperty(name);
        return SecureNodeBuilder.isType(property, Type.BOOLEAN) && property.getValue(Type.BOOLEAN) != false;
    }

    @Override
    @Nullable
    public String getString(@NotNull String name) {
        PropertyState property = this.getProperty(name);
        if (SecureNodeBuilder.isType(property, Type.STRING)) {
            return property.getValue(Type.STRING);
        }
        return null;
    }

    @Override
    @Nullable
    public String getName(@NotNull String name) {
        PropertyState property = this.getProperty(name);
        if (SecureNodeBuilder.isType(property, Type.NAME)) {
            return property.getValue(Type.NAME);
        }
        return null;
    }

    @Override
    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        PropertyState property = this.getProperty(name);
        if (SecureNodeBuilder.isType(property, Type.NAMES)) {
            return property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public NodeBuilder setProperty(@NotNull PropertyState property) {
        this.builder.setProperty(property);
        return this;
    }

    @Override
    @NotNull
    public <T> NodeBuilder setProperty(String name, @NotNull T value) {
        this.builder.setProperty(name, value);
        return this;
    }

    @Override
    @NotNull
    public <T> NodeBuilder setProperty(String name, @NotNull T value, Type<T> type) {
        this.builder.setProperty(name, value, type);
        return this;
    }

    @Override
    @NotNull
    public NodeBuilder removeProperty(String name) {
        if (this.hasProperty(name)) {
            this.builder.removeProperty(name);
        }
        return this;
    }

    @Override
    @NotNull
    public Iterable<String> getChildNodeNames() {
        return IterableUtils.filter(this.builder.getChildNodeNames(), input -> input != null && this.getChildNode((String)input).exists());
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        if (this.builder.hasChildNode(name)) {
            return this.getChildNode(name).exists();
        }
        return false;
    }

    @Override
    @NotNull
    public NodeBuilder child(@NotNull String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    @Override
    @NotNull
    public NodeBuilder setChildNode(@NotNull String name) {
        this.builder.setChildNode(name);
        return new SecureNodeBuilder(this, name);
    }

    @Override
    @NotNull
    public NodeBuilder setChildNode(@NotNull String name, @NotNull NodeState nodeState) {
        this.builder.setChildNode(name, nodeState);
        return new SecureNodeBuilder(this, name);
    }

    @Override
    @NotNull
    public NodeBuilder getChildNode(@NotNull String name) {
        return new SecureNodeBuilder(this, name);
    }

    @Override
    public synchronized long getChildNodeCount(long max) {
        if (this.getTreePermission().canReadAll()) {
            return this.builder.getChildNodeCount(max);
        }
        return IterableUtils.size(this.getChildNodeNames());
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        return this.builder.createBlob(stream);
    }

    @NotNull
    private TreePermission getTreePermission() {
        if (this.treePermission == null || this.rootPermission != this.rootBuilder.treePermission) {
            NodeState base = this.builder.getBaseState();
            String msg = "see OAK-11790 and OAK-11843";
            if (this.parent == null) {
                Tree baseTree = TreeFactory.createReadOnlyTree(base);
                PermissionProvider provider = Objects.requireNonNull(this.permissionProvider.get(), msg);
                this.rootPermission = this.treePermission = Objects.requireNonNull(provider.getTreePermission(baseTree, TreePermission.EMPTY), msg);
            } else {
                TreePermission parentTreePermission = Objects.requireNonNull(this.parent.getTreePermission(), msg);
                this.treePermission = Objects.requireNonNull(parentTreePermission.getChildPermission(this.name, base), msg);
                this.rootPermission = this.parent.rootPermission;
            }
        }
        return this.treePermission;
    }

    private static boolean isType(@Nullable PropertyState property, Type<?> type) {
        Type<?> t = property == null ? null : property.getType();
        return t == type;
    }

    private class ReadablePropertyPredicate
    implements Predicate<PropertyState> {
        private ReadablePropertyPredicate() {
        }

        @Override
        public boolean test(@Nullable PropertyState property) {
            if (property != null) {
                String propertyName = property.getName();
                return NodeStateUtils.isHidden(propertyName) || SecureNodeBuilder.this.getTreePermission().canRead(property) || SecureNodeBuilder.this.isNew(propertyName);
            }
            return false;
        }
    }
}

