/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tooling.support.install.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.tooling.support.install.impl.InstallationResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@HttpWhiteboardServletPattern(value={"/system/sling/tooling/install"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=org.osgi.service.http)")
public class InstallServlet
extends HttpServlet {
    private static final long serialVersionUID = -8820366266126231409L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DIR = "dir";
    private final BundleContext bundleContext;

    @Activate
    public InstallServlet(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String dirPath = req.getParameter(DIR);
        boolean refreshPackages = Boolean.parseBoolean(req.getParameter(dirPath));
        try {
            if (dirPath == null) {
                this.logger.error("No mandatory dir parameter specified");
                resp.setStatus(500);
                InstallationResult result = new InstallationResult(false, "No mandatory dir parameter specified");
                result.render(resp.getWriter());
                return;
            }
            this.installBundleFromDirectory(resp, Paths.get(dirPath, new String[0]), refreshPackages);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void logAndWriteError(Exception e, HttpServletResponse resp) throws IOException {
        this.logger.info(e.getMessage(), (Throwable)e);
        resp.setStatus(500);
        new InstallationResult(false, e.getMessage()).render(resp.getWriter());
    }

    private void installBundleFromDirectory(HttpServletResponse resp, Path dir, boolean refreshPackages) throws IOException {
        try {
            this.installBundleFromDirectory(dir, refreshPackages);
            InstallationResult result = new InstallationResult(true, null);
            resp.setStatus(200);
            result.render(resp.getWriter());
        }
        catch (IllegalArgumentException e) {
            this.logAndWriteError(e, resp);
        }
    }

    Bundle installBundleFromDirectory(Path dir, boolean refreshPackages) throws IOException {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            this.logger.info("Checking dir {} for bundle install", (Object)dir);
            Path manifestFile = dir.resolve("META-INF/MANIFEST.MF");
            if (Files.exists(dir, new LinkOption[0])) {
                try (InputStream fis = Files.newInputStream(manifestFile, new OpenOption[0]);){
                    Manifest mf = new Manifest(fis);
                    String symbolicName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                    if (symbolicName != null) {
                        Bundle found = this.getBundle(symbolicName);
                        Path tmpJarFile = Files.createTempFile(dir.getFileName().toString(), "bundle", new FileAttribute[0]);
                        try {
                            Bundle bundle;
                            block22: {
                                InstallServlet.createJar(dir, tmpJarFile, mf);
                                InputStream in = Files.newInputStream(tmpJarFile, new OpenOption[0]);
                                try {
                                    String location = dir.toAbsolutePath().toString();
                                    bundle = this.installOrUpdateBundle(found, in, location, refreshPackages);
                                    if (in == null) break block22;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (BundleException be) {
                                        throw new IllegalArgumentException("Unable to install/update bundle from dir " + dir, be);
                                    }
                                }
                                in.close();
                            }
                            return bundle;
                        }
                        finally {
                            Files.delete(tmpJarFile);
                        }
                    }
                    throw new IllegalArgumentException("Manifest in " + dir + " does not have a symbolic name");
                }
            }
            throw new IllegalArgumentException("Dir " + dir + " does not have a manifest");
        }
        throw new IllegalArgumentException("Dir " + dir + " does not exist");
    }

    private Bundle installOrUpdateBundle(Bundle bundle, InputStream in, String location, boolean refreshPackages) throws BundleException {
        if (bundle != null) {
            bundle.update(in);
        } else {
            bundle = this.bundleContext.installBundle(location, in);
            bundle.start();
        }
        if (refreshPackages) {
            this.refreshBundle(bundle);
        }
        return bundle;
    }

    private void refreshBundle(Bundle bundle) {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
        frameworkWiring.refreshBundles(Collections.singleton(bundle), new FrameworkListener[0]);
    }

    private Bundle getBundle(String symbolicName) {
        Bundle found = null;
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!symbolicName.equals(b.getSymbolicName())) continue;
            found = b;
            break;
        }
        return found;
    }

    private static void createJar(Path sourceDir, Path jarFile, Manifest mf) throws IOException {
        try (JarOutputStream zos = new JarOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            zos.setLevel(0);
            ZipEntry anEntry = new ZipEntry("META-INF/MANIFEST.MF");
            zos.putNextEntry(anEntry);
            mf.write(zos);
            zos.closeEntry();
            InstallServlet.zipDir(sourceDir, zos, "");
        }
    }

    public static void zipDir(Path sourceDir, ZipOutputStream zos, String prefix) throws IOException {
        try (Stream<Path> stream = Files.list(sourceDir);){
            stream.forEach(p -> {
                try {
                    InstallServlet.zipFileOrDir(p, zos, prefix);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException ioe) {
            throw ioe.getCause();
        }
    }

    private static void zipFileOrDir(Path sourceFileOrDir, ZipOutputStream zos, String prefix) throws IOException {
        if (Files.isDirectory(sourceFileOrDir, new LinkOption[0])) {
            String newPrefix = prefix + sourceFileOrDir.getFileName() + "/";
            zos.putNextEntry(new ZipEntry(newPrefix));
            InstallServlet.zipDir(sourceFileOrDir, zos, newPrefix);
        } else {
            String entry = prefix + sourceFileOrDir.getFileName();
            if (!"META-INF/MANIFEST.MF".equals(entry)) {
                ZipEntry anEntry = new ZipEntry(entry);
                zos.putNextEntry(anEntry);
                Files.copy(sourceFileOrDir, zos);
            }
        }
    }
}

