/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateExpressionResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolutionContext;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TypeCoercionResolver;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u000b\u0017\u0001\u0015B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")q\t\u0001C\u0001\u0011\"9A\n\u0001b\u0001\n\u0013i\u0005BB/\u0001A\u0003%a\nC\u0004_\u0001\t\u0007I\u0011B0\t\r\r\u0004\u0001\u0015!\u0003a\u0011\u001d!\u0007A1A\u0005\n\u0015Da!\u001d\u0001!\u0002\u00131\u0007\"\u0002:\u0001\t\u0003\u001a\b\"\u0002<\u0001\t\u00139\b\"\u0002?\u0001\t\u0013i\bBB@\u0001\t\u0013\t\taB\u0004\u0002\u0006YA\t!a\u0002\u0007\rU1\u0002\u0012AA\u0005\u0011\u00199u\u0002\"\u0001\u0002\f!A\u0011QB\bC\u0002\u0013%Q\nC\u0004\u0002\u0010=\u0001\u000b\u0011\u0002(\t\u0011\u0005EqB1A\u0005\n5Cq!a\u0005\u0010A\u0003%aJA\u000eBO\u001e\u0014XmZ1uK\u0016C\bO]3tg&|gNU3t_24XM\u001d\u0006\u0003/a\t\u0001B]3t_24XM\u001d\u0006\u00033i\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u00037q\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0019bC\b\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0005[9\u0002\u0004(D\u0001\u0017\u0013\tycC\u0001\tUe\u0016,gj\u001c3f%\u0016\u001cx\u000e\u001c<feB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\nC\u001e<'/Z4bi\u0016T!!\u000e\u000e\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003oI\u00121#Q4he\u0016<\u0017\r^3FqB\u0014Xm]:j_:\u0004\"!\u000f\u001e\u000e\u0003QJ!a\u000f\u001b\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002.{%\u0011aH\u0006\u0002\u001b%\u0016\u001cx\u000e\u001c<fg\u0016C\bO]3tg&|gn\u00115jY\u0012\u0014XM\\\u0001\u0013Kb\u0004(/Z:tS>t'+Z:pYZ,'\u000f\u0005\u0002.\u0003&\u0011!I\u0006\u0002\u0013\u000bb\u0004(/Z:tS>t'+Z:pYZ,'/A\u0010uS6,'p\u001c8f\u0003^\f'/Z#yaJ,7o]5p]J+7o\u001c7wKJ\u0004\"!L#\n\u0005\u00193\"a\b+j[\u0016TxN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"2!\u0013&L!\ti\u0003\u0001C\u0003@\u0007\u0001\u0007\u0001\tC\u0003D\u0007\u0001\u0007A)A\u000eusB,7i\\3sG&|g\u000e\u0016:b]N4wN]7bi&|gn]\u000b\u0002\u001dB\u0019qj\u0016.\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*%\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002WQ\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005\r\u0019V-\u001d\u0006\u0003-\"\u0002BaJ.9q%\u0011A\f\u000b\u0002\n\rVt7\r^5p]F\nA\u0004^=qK\u000e{WM]2j_:$&/\u00198tM>\u0014X.\u0019;j_:\u001c\b%\u0001\u000busB,7i\\3sG&|gNU3t_24XM]\u000b\u0002AB\u0011Q&Y\u0005\u0003EZ\u0011A\u0003V=qK\u000e{WM]2j_:\u0014Vm]8mm\u0016\u0014\u0018!\u0006;za\u0016\u001cu.\u001a:dS>t'+Z:pYZ,'\u000fI\u0001!Kb\u0004(/Z:tS>t'+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;Ti\u0006\u001c7.F\u0001g!\r9GN\\\u0007\u0002Q*\u0011\u0011N[\u0001\u0005kRLGNC\u0001l\u0003\u0011Q\u0017M^1\n\u00055D'AC!se\u0006LH)Z9vKB\u0011Qf\\\u0005\u0003aZ\u00111$\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\u0018!I3yaJ,7o]5p]J+7o\u001c7vi&|gnQ8oi\u0016DHo\u0015;bG.\u0004\u0013a\u0002:fg>dg/\u001a\u000b\u0003qQDQ!\u001e\u0006A\u0002A\n1#Y4he\u0016<\u0017\r^3FqB\u0014Xm]:j_:\fA\u0004\u001e5s_^LeMT8u+:$WM\u001d,bY&$w\n]3sCR|'\u000f\u0006\u0002ywB\u0011q%_\u0005\u0003u\"\u0012A!\u00168ji\")Qo\u0003a\u0001a\u0005aB\u000f\u001b:po&3g*Z:uK\u0012\fum\u001a:fO\u0006$X-\u0012=jgR\u001cHC\u0001=\u007f\u0011\u0015)H\u00021\u00011\u0003\t\"\bN]8x\u0013\u001aD\u0015m\u001d(p]\u0012,G/\u001a:nS:L7\u000f^5d\u0007\"LG\u000e\u001a:f]R\u0019\u00010a\u0001\t\u000bUl\u0001\u0019\u0001\u0019\u00027\u0005;wM]3hCR,W\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s!\tisb\u0005\u0002\u0010MQ\u0011\u0011qA\u0001\u001e)f\u0003ViX\"P\u000bJ\u001b\u0015j\u0014(`)J\u000bej\u0015$P%6\u000bE+S(O'\u0006qB+\u0017)F?\u000e{UIU\"J\u001f:{FKU!O'\u001a{%+T!U\u0013>s5\u000bI\u0001#\u0003:\u001b\u0016j\u0018+Z!\u0016{6iT#S\u0007&{ej\u0018+S\u0003:\u001bfi\u0014*N\u0003RKuJT*\u0002G\u0005s5+S0U3B+ulQ(F%\u000eKuJT0U%\u0006s5KR(S\u001b\u0006#\u0016j\u0014(TA\u0001")
public class AggregateExpressionResolver
implements TreeNodeResolver<AggregateExpression, Expression>,
ResolvesExpressionChildren {
    private final ExpressionResolver expressionResolver;
    private final Seq<Function1<Expression, Expression>> typeCoercionTransformations;
    private final TypeCoercionResolver typeCoercionResolver;
    private final ArrayDeque<ExpressionResolutionContext> expressionResolutionContextStack;

    @Override
    public <ExpressionType extends Expression> ExpressionType withResolvedChildren(ExpressionType unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return (ExpressionType)ResolvesExpressionChildren.withResolvedChildren$(this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private Seq<Function1<Expression, Expression>> typeCoercionTransformations() {
        return this.typeCoercionTransformations;
    }

    private TypeCoercionResolver typeCoercionResolver() {
        return this.typeCoercionResolver;
    }

    private ArrayDeque<ExpressionResolutionContext> expressionResolutionContextStack() {
        return this.expressionResolutionContextStack;
    }

    @Override
    public Expression resolve(AggregateExpression aggregateExpression) {
        AggregateExpression aggregateExpressionWithTypeCoercion = this.withResolvedChildren(aggregateExpression, (Function1<Expression, Expression>)(Function1 & Serializable)expression -> this.typeCoercionResolver().resolve((Expression)expression));
        this.throwIfNotUnderValidOperator(aggregateExpression);
        this.throwIfNestedAggregateExists(aggregateExpressionWithTypeCoercion);
        this.throwIfHasNondeterministicChildren(aggregateExpressionWithTypeCoercion);
        this.expressionResolutionContextStack().peek().hasAggregateExpressionsInASubtree_$eq(true);
        this.expressionResolutionContextStack().peek().hasAttributeInASubtree_$eq(false);
        return aggregateExpressionWithTypeCoercion;
    }

    private void throwIfNotUnderValidOperator(AggregateExpression aggregateExpression) {
        LogicalPlan logicalPlan = (LogicalPlan)this.expressionResolver.getParentOperator().get();
        if (logicalPlan instanceof Aggregate ? true : logicalPlan instanceof Project) {
            return;
        }
        if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            throw package$.MODULE$.AnalysisErrorAt(filter).failAnalysis("INVALID_WHERE_CONDITION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)this.toSQLExpr(filter.condition())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressionList"), (Object)new .colon.colon((Object)aggregateExpression, (List)Nil$.MODULE$).mkString(", "))}))));
        }
        throw package$.MODULE$.AnalysisErrorAt(logicalPlan).failAnalysis("UNSUPPORTED_EXPR_FOR_OPERATOR", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidExprSqls"), (Object)new .colon.colon((Object)aggregateExpression, (List)Nil$.MODULE$).mkString(", "))}))));
    }

    private void throwIfNestedAggregateExists(AggregateExpression aggregateExpression) {
        if (this.expressionResolutionContextStack().peek().hasAggregateExpressionsInASubtree()) {
            throw package$.MODULE$.AnalysisErrorAt(aggregateExpression).failAnalysis("NESTED_AGGREGATE_FUNCTION", (Map<String, String>)Predef$.MODULE$.Map().empty());
        }
    }

    private void throwIfHasNondeterministicChildren(AggregateExpression aggregateExpression) {
        aggregateExpression.aggregateFunction().children().foreach((Function1 & Serializable)child -> {
            AggregateExpressionResolver.$anonfun$throwIfHasNondeterministicChildren$1(this, aggregateExpression, child);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$throwIfHasNondeterministicChildren$1(AggregateExpressionResolver $this, AggregateExpression aggregateExpression$1, Expression child) {
        if (!child.deterministic()) {
            throw package$.MODULE$.AnalysisErrorAt(child).failAnalysis("AGGREGATE_FUNCTION_WITH_NONDETERMINISTIC_EXPRESSION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)$this.toSQLExpr(aggregateExpression$1))}))));
        }
    }

    public AggregateExpressionResolver(ExpressionResolver expressionResolver, TimezoneAwareExpressionResolver timezoneAwareExpressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        this.typeCoercionTransformations = this.conf().ansiEnabled() ? AggregateExpressionResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$AggregateExpressionResolver$$ANSI_TYPE_COERCION_TRANSFORMATIONS() : AggregateExpressionResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$AggregateExpressionResolver$$TYPE_COERCION_TRANSFORMATIONS();
        this.typeCoercionResolver = new TypeCoercionResolver(timezoneAwareExpressionResolver, this.typeCoercionTransformations());
        this.expressionResolutionContextStack = expressionResolver.getExpressionResolutionContextStack();
    }
}

