/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.internal.types.AbstractArrayType;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, delimiter[, nullReplacement]) - Concatenates the elements of the given array\n      using the delimiter and an optional string to replace nulls. If no value is set for\n      nullReplacement, any null value is filtered.", examples="\n    Examples:\n      > SELECT _FUNC_(array('hello', 'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ', ',');\n       hello , world\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tub\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005k!A\u0011\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005S\u0001\tE\t\u0015!\u00036\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A0\t\u000be\u0003A\u0011\u00012\t\u000b\u0019\u0004A\u0011I4\t\u000bE\u0004A\u0011\t:\t\u000bQ\u0004A\u0011K;\t\u000bm\u0004A\u0011\t?\t\r\u0005\u0005\u0001\u0001\"\u0011}\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u0007\u0001\t#\nY\u0002C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u00111\r\u0001\u0005B\u0005\u0015\u0004\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\t\t\bAI\u0001\n\u0003\t\u0019\bC\u0005\u0002\n\u0002\t\n\u0011\"\u0001\u0002t!I\u00111\u0012\u0001\u0012\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003'C\u0011\"a)\u0001\u0003\u0003%\t!!*\t\u0013\u00055\u0006!!A\u0005\u0002\u0005=\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u0011%\t)\rAA\u0001\n\u0003\t9\rC\u0005\u0002L\u0002\t\t\u0011\"\u0011\u0002N\"I\u0011\u0011\u001b\u0001\u0002\u0002\u0013\u0005\u00131[\u0004\n\u0003o<\u0013\u0011!E\u0001\u0003s4\u0001BJ\u0014\u0002\u0002#\u0005\u00111 \u0005\u00073\u0002\"\tAa\u0005\t\u0013\tU\u0001%!A\u0005F\t]\u0001\"\u0003B\rA\u0005\u0005I\u0011\u0011B\u000e\u0011%\u0011\u0019\u0003IA\u0001\n\u0003\u0013)\u0003C\u0005\u00034\u0001\n\t\u0011\"\u0003\u00036\tI\u0011I\u001d:bs*{\u0017N\u001c\u0006\u0003Q%\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!fK\u0001\tG\u0006$\u0018\r\\=ti*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M)\u0001!N\u001d=\u0005B\u0011agN\u0007\u0002O%\u0011\u0001h\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001c;\u0013\tYtEA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0017:\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fN\na\u0001\u0010:p_Rt\u0014\"A \n\u0005)s\u0014a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0013 \u0002\u000b\u0005\u0014(/Y=\u0016\u0003U\na!\u0019:sCf\u0004\u0013!\u00033fY&l\u0017\u000e^3s\u0003)!W\r\\5nSR,'\u000fI\u0001\u0010]VdGNU3qY\u0006\u001cW-\\3oiV\tQ\u000bE\u0002>-VJ!a\u0016 \u0003\r=\u0003H/[8o\u0003AqW\u000f\u001c7SKBd\u0017mY3nK:$\b%\u0001\u0004=S:LGO\u0010\u000b\u00057rkf\f\u0005\u00027\u0001!)aj\u0002a\u0001k!)\u0011k\u0002a\u0001k!)1k\u0002a\u0001+R\u00191\fY1\t\u000b9C\u0001\u0019A\u001b\t\u000bEC\u0001\u0019A\u001b\u0015\tm\u001bG-\u001a\u0005\u0006\u001d&\u0001\r!\u000e\u0005\u0006#&\u0001\r!\u000e\u0005\u0006'&\u0001\r!N\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00015\u0011\u0007\rK7.\u0003\u0002k\u001b\n\u00191+Z9\u0011\u00051|W\"A7\u000b\u00059\\\u0013!\u0002;za\u0016\u001c\u0018B\u00019n\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005dQ&dGM]3o+\u0005\u0019\bcA\"jk\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0003kYDQa\u001e\u0007A\u0002a\f1B\\3x\u0007\"LG\u000e\u001a:f]B\u00191)_\u001b\n\u0005il%AC%oI\u0016DX\rZ*fc\u0006Aa.\u001e7mC\ndW-F\u0001~!\tid0\u0003\u0002\u0000}\t9!i\\8mK\u0006t\u0017\u0001\u00034pY\u0012\f'\r\\3\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003\u000f\ti\u0001E\u0002>\u0003\u0013I1!a\u0003?\u0005\r\te.\u001f\u0005\n\u0003\u001fy\u0001\u0013!a\u0001\u0003#\tQ!\u001b8qkR\u0004B!a\u0005\u0002\u00165\t\u0011&C\u0002\u0002\u0018%\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003;\tI#a\r\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t(\u0003\u001d\u0019w\u000eZ3hK:LA!a\n\u0002\"\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002,A\u0001\r!!\f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002 \u0005=\u0012\u0002BA\u0019\u0003C\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u00026A\u0001\r!!\b\u0002\u0005\u00154\u0018aG4f]\u000e{G-\u001a$pe\u0006\u0013(/Y=B]\u0012$U\r\\5nSR,'\u000f\u0006\u0005\u0002<\u0005-\u0013QJA(!\u0011\ti$!\u0012\u000f\t\u0005}\u0012\u0011\t\t\u0003\u000bzJ1!a\u0011?\u0003\u0019\u0001&/\u001a3fM&!\u0011qIA%\u0005\u0019\u0019FO]5oO*\u0019\u00111\t \t\u000f\u0005-\u0012\u00031\u0001\u0002.!9\u0011QG\tA\u0002\u0005u\u0001bBA)#\u0001\u0007\u00111K\u0001\t]VdG.\u0012<bYBYQ(!\u0016\u0002<\u0005m\u00121HA\u001e\u0013\r\t9F\u0010\u0002\n\rVt7\r^5p]N\n\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003;\u00022\u0001\\A0\u0013\r\t\t'\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005m\u0012\u0001B2paf$raWA6\u0003[\ny\u0007C\u0004O)A\u0005\t\u0019A\u001b\t\u000fE#\u0002\u0013!a\u0001k!91\u000b\u0006I\u0001\u0002\u0004)\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kR3!NA<W\t\tI\b\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\u0013Ut7\r[3dW\u0016$'bAAB}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0015Q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyIK\u0002V\u0003o\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAK!\u0011\t9*!)\u000e\u0005\u0005e%\u0002BAN\u0003;\u000bA\u0001\\1oO*\u0011\u0011qT\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005e\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAT!\ri\u0014\u0011V\u0005\u0004\u0003Ws$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0004\u0003cC\u0011\"a-\u001b\u0003\u0003\u0005\r!a*\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\f\u0005\u0004\u0002<\u0006\u0005\u0017qA\u0007\u0003\u0003{S1!a0?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0007\fiL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA?\u0002J\"I\u00111\u0017\u000f\u0002\u0002\u0003\u0007\u0011qA\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0016\u0006=\u0007\"CAZ;\u0005\u0005\t\u0019AAT\u0003\u0019)\u0017/^1mgR\u0019Q0!6\t\u0013\u0005Mf$!AA\u0002\u0005\u001d\u0001f\u0005\u0001\u0002Z\u0006}\u0017\u0011]As\u0003O\fY/!<\u0002r\u0006M\bc\u0001\u001c\u0002\\&\u0019\u0011Q\\\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111]\u0001\u0002Z*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\f\u0011eK2LW.\u001b;fenc\u0003E\\;mYJ+\u0007\u000f\\1dK6,g\u000e^/*A5\u00023i\u001c8dCR,g.\u0019;fg\u0002\"\b.\u001a\u0011fY\u0016lWM\u001c;tA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!CJ\u0014\u0018-\u001f\u0006!A\u0001\u0002\u0003\u0005I;tS:<\u0007\u0005\u001e5fA\u0011,G.[7ji\u0016\u0014\b%\u00198eA\u0005t\u0007e\u001c9uS>t\u0017\r\u001c\u0011tiJLgn\u001a\u0011u_\u0002\u0012X\r\u001d7bG\u0016\u0004c.\u001e7mg:\u0002\u0013J\u001a\u0011o_\u00022\u0018\r\\;fA%\u001c\be]3uA\u0019|'O\u0003\u0011!A\u0001\u0002\u0003E\\;mYJ+\u0007\u000f\\1dK6,g\u000e\u001e\u0017!C:L\bE\\;mY\u00022\u0018\r\\;fA%\u001c\bEZ5mi\u0016\u0014X\r\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!;\u0002\u0003sT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDs\u0005[3mY><C\u0006I\u0014x_JdGmJ\u0015-A\u001d\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q\u0016dGn\u001c\u0011x_JdGM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014iK2dwn\n\u0017!]VdG\u000e\t\u0017(o>\u0014H\u000eZ\u0014*Y\u0001:\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A!,G\u000e\\8!o>\u0014H\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015(Q\u0016dGn\\\u0014-A9,H\u000e\u001c\u0011-O]|'\u000f\u001c3(S1\u0002s\u0005I\u0014-A\u001dbs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q\u0016dGn\u001c\u0011-A]|'\u000f\u001c3\u000bA\u0001\nQa\u001a:pkB\f#!a<\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003k\fQA\r\u00185]A\n\u0011\"\u0011:sCfTu.\u001b8\u0011\u0005Y\u00023#\u0002\u0011\u0002~\n%\u0001\u0003CA\u0000\u0005\u000b)T'V.\u000e\u0005\t\u0005!b\u0001B\u0002}\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u0004\u0005\u0003\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011YA!\u0005\u000e\u0005\t5!\u0002\u0002B\b\u0003;\u000b!![8\n\u00071\u0013i\u0001\u0006\u0002\u0002z\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0016\u0006)\u0011\r\u001d9msR91L!\b\u0003 \t\u0005\u0002\"\u0002($\u0001\u0004)\u0004\"B)$\u0001\u0004)\u0004\"B*$\u0001\u0004)\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005O\u0011y\u0003\u0005\u0003>-\n%\u0002CB\u001f\u0003,U*T+C\u0002\u0003.y\u0012a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0019I\u0005\u0005\t\u0019A.\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00038A!\u0011q\u0013B\u001d\u0013\u0011\u0011Y$!'\u0003\r=\u0013'.Z2u\u0001")
public class ArrayJoin
extends Expression
implements ExpectsInputTypes,
Serializable {
    private final Expression array;
    private final Expression delimiter;
    private final Option<Expression> nullReplacement;

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(ArrayJoin x$0) {
        return ArrayJoin$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, ArrayJoin> tupled() {
        return ArrayJoin$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, ArrayJoin>>> curried() {
        return ArrayJoin$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression array() {
        return this.array;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Option<Expression> nullReplacement() {
        return this.nullReplacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        if (this.nullReplacement().isDefined()) {
            return new .colon.colon((Object)new AbstractArrayType((AbstractDataType)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)new AbstractArrayType((AbstractDataType)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        if (this.nullReplacement().isDefined()) {
            return new .colon.colon((Object)this.array(), (List)new .colon.colon((Object)this.delimiter(), (List)new .colon.colon((Object)((Expression)this.nullReplacement().get()), (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)this.array(), (List)new .colon.colon((Object)this.delimiter(), (List)Nil$.MODULE$));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.nullReplacement().isDefined()) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Function1 & Serializable intersect;
        Object arrayEval = this.array().eval(input);
        if (arrayEval == null) {
            return null;
        }
        Object delimiterEval = this.delimiter().eval(input);
        if (delimiterEval == null) {
            return null;
        }
        Option nullReplacementEval = this.nullReplacement().map((Function1 & Serializable)x$32 -> x$32.eval(input));
        if (nullReplacementEval.contains(null)) {
            return null;
        }
        UTF8StringBuilder buffer = new UTF8StringBuilder();
        BooleanRef firstItem = BooleanRef.create((boolean)true);
        Option option = nullReplacementEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object rep = some.value();
            intersect = (Function1 & Serializable)prependDelimiter -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$8(buffer, delimiterEval, rep, BoxesRunTime.unboxToBoolean((Object)prependDelimiter)));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$9(BoxesRunTime.unboxToBoolean((Object)x$33)));
        } else {
            throw new MatchError((Object)option);
        }
        Function1 & Serializable nullHandling = intersect;
        ((ArrayData)arrayEval).foreach((DataType)StringType$.MODULE$, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$34, item) -> {
            ArrayJoin.$anonfun$eval$10(nullHandling, firstItem, buffer, delimiterEval, BoxesRunTime.unboxToInt((Object)x$34), item);
            return BoxedUnit.UNIT;
        });
        return buffer.build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        Option<Expression> option = this.nullReplacement();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression replacement = (Expression)some.value();
            ExprCode replacementGen = replacement.genCode(ctx);
            Function3 & Serializable nullHandling = (Function3 & Serializable)(buffer, delimiter, firstItem) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |if (!" + firstItem + ") {\n             |  " + buffer + ".append(" + delimiter + ");\n             |}\n             |" + buffer + ".append(" + replacementGen.value() + ");\n             |" + firstItem + " = false;\n           "));
            String execCode = replacement.nullable() ? ctx.nullSafeExec(replacement.nullable(), ExprValue$.MODULE$.exprValueToString(replacementGen.isNull()), this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling)) : this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling);
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + replacementGen.code() + "\n           |" + execCode + "\n         "));
        } else if (None$.MODULE$.equals(option)) {
            string = this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(x$35, x$36, x$37) -> "// nulls are ignored");
        } else {
            throw new MatchError(option);
        }
        String code = string;
        if (this.nullable()) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), code})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), code})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private String genCodeForArrayAndDelimiter(CodegenContext ctx, ExprCode ev, Function3<String, String, String, String> nullEval) {
        ExprCode arrayGen = this.array().genCode(ctx);
        ExprCode delimiterGen = this.delimiter().genCode(ctx);
        String buffer = ctx.freshName("buffer");
        String bufferClass = UTF8StringBuilder.class.getName();
        String i = ctx.freshName("i");
        String firstItem = ctx.freshName("firstItem");
        String resultCode = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + bufferClass + " " + buffer + " = new " + bufferClass + "();\n         |boolean " + firstItem + " = true;\n         |for (int " + i + " = 0; " + i + " < " + arrayGen.value() + ".numElements(); " + i + " ++) {\n         |  if (" + arrayGen.value() + ".isNullAt(" + i + ")) {\n         |    " + nullEval.apply((Object)buffer, (Object)ExprValue$.MODULE$.exprValueToString(delimiterGen.value()), (Object)firstItem) + "\n         |  } else {\n         |    if (!" + firstItem + ") {\n         |      " + buffer + ".append(" + delimiterGen.value() + ");\n         |    }\n         |    " + buffer + ".append(" + CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(arrayGen.value()), (DataType)StringType$.MODULE$, i) + ");\n         |    " + firstItem + " = false;\n         |  }\n         |}\n         |" + ev.value() + " = " + buffer + ".build();"));
        if (this.array().nullable() || this.delimiter().nullable()) {
            return arrayGen.code().toString() + ctx.nullSafeExec(this.array().nullable(), ExprValue$.MODULE$.exprValueToString(arrayGen.isNull()), delimiterGen.code().toString() + ctx.nullSafeExec(this.delimiter().nullable(), ExprValue$.MODULE$.exprValueToString(delimiterGen.isNull()), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + ev.isNull() + " = false;\n             |" + resultCode))));
        }
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + arrayGen.code() + "\n         |" + delimiterGen.code() + "\n         |" + resultCode));
    }

    @Override
    public DataType dataType() {
        return ((ArrayType)this.array().dataType()).elementType();
    }

    @Override
    public String prettyName() {
        return "array_join";
    }

    public ArrayJoin copy(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        return new ArrayJoin(array, delimiter, nullReplacement);
    }

    public Expression copy$default$1() {
        return this.array();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Option<Expression> copy$default$3() {
        return this.nullReplacement();
    }

    @Override
    public String productPrefix() {
        return "ArrayJoin";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.array();
            }
            case 1: {
                return this.delimiter();
            }
            case 2: {
                return this.nullReplacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayJoin;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "array";
            }
            case 1: {
                return "delimiter";
            }
            case 2: {
                return "nullReplacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayJoin)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayJoin arrayJoin = (ArrayJoin)x$1;
        Expression expression = this.array();
        Expression expression2 = arrayJoin.array();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = arrayJoin.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.nullReplacement();
        Option<Expression> option2 = arrayJoin.nullReplacement();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!arrayJoin.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$8(UTF8StringBuilder buffer$1, Object delimiterEval$1, Object rep$1, boolean prependDelimiter) {
        if (!prependDelimiter) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)rep$1);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$9(boolean x$33) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$eval$10(Function1 nullHandling$1, BooleanRef firstItem$1, UTF8StringBuilder buffer$1, Object delimiterEval$1, int x$34, Object item) {
        if (item == null) {
            if (BoxesRunTime.unboxToBoolean((Object)nullHandling$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)firstItem$1.elem)))) {
                firstItem$1.elem = false;
                return;
            }
            return;
        }
        if (!firstItem$1.elem) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)item);
        firstItem$1.elem = false;
    }

    public ArrayJoin(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        this.array = array;
        this.delimiter = delimiter;
        this.nullReplacement = nullReplacement;
        ExpectsInputTypes.$init$(this);
    }

    public ArrayJoin(Expression array, Expression delimiter) {
        this(array, delimiter, (Option<Expression>)None$.MODULE$);
    }

    public ArrayJoin(Expression array, Expression delimiter, Expression nullReplacement) {
        this(array, delimiter, (Option<Expression>)new Some((Object)nullReplacement));
    }
}

