/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.analysis.UnresolvedWithinGroup$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.Mode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Mode$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col[, deterministic]) - Returns the most frequent value for the values within `col`. NULL values are ignored. If all the values are NULL, or there are 0 rows, returns NULL.\n      When multiple values have the same greatest frequency then either any of values is returned if `deterministic` is false or is not defined, or the lowest value is returned if `deterministic` is true.\n    _FUNC_() WITHIN GROUP (ORDER BY col) - Returns the most frequent value for the values within `col` (specified in ORDER BY clause). NULL values are ignored.\n      If all the values are NULL, or there are 0 rows, returns NULL. When multiple values have the same greatest frequency only one value will be returned.\n      The value will be chosen based on sort direction. Return the smallest value if sort direction is asc or the largest value if sort direction is desc from multiple values with the same frequency.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (0), (10), (10) AS tab(col);\n       10\n      > SELECT _FUNC_(col) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '10' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-10\n      > SELECT _FUNC_(col) FROM VALUES (0), (10), (10), (null), (null), (null) AS tab(col);\n       10\n      > SELECT _FUNC_(col, false) FROM VALUES (-10), (0), (10) AS tab(col);\n       0\n      > SELECT _FUNC_(col, true) FROM VALUES (-10), (0), (10) AS tab(col);\n       -10\n      > SELECT _FUNC_() WITHIN GROUP (ORDER BY col) FROM VALUES (0), (10), (10) AS tab(col);\n       10\n      > SELECT _FUNC_() WITHIN GROUP (ORDER BY col) FROM VALUES (0), (10), (10), (20), (20) AS tab(col);\n       10\n      > SELECT _FUNC_() WITHIN GROUP (ORDER BY col DESC) FROM VALUES (0), (10), (10), (20), (20) AS tab(col);\n       20\n  ", group="agg_funcs", since="3.4.0")
public final class ModeBuilder$
implements ExpressionBuilder {
    public static final ModeBuilder$ MODULE$ = new ModeBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 0) {
            return new Mode(UnresolvedWithinGroup$.MODULE$, Mode$.MODULE$.apply$default$2(), Mode$.MODULE$.apply$default$3(), Mode$.MODULE$.apply$default$4());
        }
        if (numArgs == 1) {
            return new Mode((Expression)expressions.apply(0), Mode$.MODULE$.apply$default$2(), Mode$.MODULE$.apply$default$3(), Mode$.MODULE$.apply$default$4());
        }
        if (numArgs == 2) {
            InternalRow x$1;
            if (!((Expression)expressions.apply(1)).foldable()) {
                throw QueryCompilationErrors$.MODULE$.nonFoldableArgumentError(funcName, "deterministic", (DataType)BooleanType$.MODULE$);
            }
            Expression qual$1 = (Expression)expressions.apply(1);
            Object deterministicResult = qual$1.eval(x$1 = qual$1.eval$default$1());
            if (deterministicResult == null) {
                throw QueryCompilationErrors$.MODULE$.unexpectedNullError("deterministic", (Expression)expressions.apply(1));
            }
            DataType dataType = ((Expression)expressions.apply(1)).dataType();
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            if (dataType == null ? booleanType$ != null : !dataType.equals(booleanType$)) {
                throw QueryCompilationErrors$.MODULE$.unexpectedInputDataTypeError(funcName, 2, (DataType)BooleanType$.MODULE$, (Expression)expressions.apply(1));
            }
            if (BoxesRunTime.unboxToBoolean((Object)deterministicResult)) {
                return new Mode((Expression)expressions.apply(0), true);
            }
            return new Mode((Expression)expressions.apply(0), Mode$.MODULE$.apply$default$2(), Mode$.MODULE$.apply$default$3(), Mode$.MODULE$.apply$default$4());
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private ModeBuilder$() {
    }
}

