/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import org.apache.spark.sql.catalyst.analysis.GeneratorBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExplodeGeneratorBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.Option;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="_FUNC_(expr) - It separates a variant object/array into multiple rows containing its fields/elements. Its result schema is `struct<pos int, key string, value variant>`. `pos` is the position of the field/element in its parent object/array, and `value` is the field/element value. `key` is the field name when exploding a variant object, or is NULL when exploding a variant array. It ignores any input that is not a variant array/object, including SQL NULL, variant null, and any other variant values.", examples="\n    Examples:\n      > SELECT * from _FUNC_(parse_json('[\"hello\", \"world\"]'));\n       0\tNULL\t\"hello\"\n       1\tNULL\t\"world\"\n      > SELECT * from _FUNC_(input => parse_json('{\"a\": true, \"b\": 3.14}'));\n       0\ta\ttrue\n       1\tb\t3.14\n  ", since="4.0.0", group="variant_funcs")
public final class VariantExplodeGeneratorBuilder$
implements VariantExplodeGeneratorBuilderBase {
    public static final VariantExplodeGeneratorBuilder$ MODULE$ = new VariantExplodeGeneratorBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
        GeneratorBuilder.$init$(MODULE$);
        VariantExplodeGeneratorBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return VariantExplodeGeneratorBuilderBase.functionSignature$(this);
    }

    @Override
    public Generator buildGenerator(String funcName, Seq<Expression> expressions) {
        return VariantExplodeGeneratorBuilderBase.buildGenerator$(this, funcName, expressions);
    }

    @Override
    public final LogicalPlan build(String funcName, Seq<Expression> expressions) {
        return GeneratorBuilder.build$(this, funcName, expressions);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public boolean isOuter() {
        return false;
    }

    private VariantExplodeGeneratorBuilder$() {
    }
}

