/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRank;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@WindowFunctionDescription(description=@Description(name="cume_dist", value="_FUNC_(x) - The CUME_DIST function (defined as the inverse of percentile in some statistical books) computes the position of a specified value relative to a set of values. To compute the CUME_DIST of a value x in a set S of size N, you use the formula: CUME_DIST(x) =  number of values in S coming before    and including x in the specified order/ N"), supportsWindow=false, pivotResult=true, rankingFunction=true, impliesOrder=true)
public class GenericUDAFCumeDist
extends GenericUDAFRank {
    @Override
    protected GenericUDAFRank.GenericUDAFAbstractRankEvaluator createEvaluator() {
        return new GenericUDAFCumeDistEvaluator();
    }

    public static class GenericUDAFCumeDistEvaluator
    extends GenericUDAFRank.GenericUDAFAbstractRankEvaluator {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ArrayList<IntWritable> ranks = ((GenericUDAFRank.RankBuffer)agg).rowNums;
            int ranksSize = ranks.size();
            double ranksSizeDouble = ranksSize;
            ArrayList<DoubleWritable> distances = new ArrayList<DoubleWritable>(ranksSize);
            int last = -1;
            int current = -1;
            int elementsAtRank = 1;
            for (int index = 0; index < ranksSize; ++index) {
                current = ((IntWritable)ranks.get(index)).get();
                if (index == 0) {
                    last = current;
                    continue;
                }
                if (last == current) {
                    ++elementsAtRank;
                    continue;
                }
                last = current;
                double distance = (double)index / ranksSizeDouble;
                while (elementsAtRank-- > 0) {
                    distances.add(new DoubleWritable(distance));
                }
                elementsAtRank = 1;
            }
            if (ranksSize > 0 && last == current) {
                double distance = (double)ranksSize / ranksSizeDouble;
                while (elementsAtRank-- > 0) {
                    distances.add(new DoubleWritable(distance));
                }
            }
            return distances;
        }
    }
}

