/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchUserFuncException;
import org.apache.spark.sql.execution.streaming.sources.ForeachUserFuncException;
import org.sparkproject.guava.util.concurrent.UncheckedExecutionException;
import py4j.Py4JException;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.util.matching.Regex;

public final class StreamExecution$ {
    public static final StreamExecution$ MODULE$ = new StreamExecution$();
    private static final String QUERY_ID_KEY = "sql.streaming.queryId";
    private static final String RUN_ID_KEY = "sql.streaming.runId";
    private static final String IS_CONTINUOUS_PROCESSING = "__is_continuous_processing";
    private static final Seq<String> IO_EXCEPTION_NAMES = new .colon.colon((Object)InterruptedException.class.getName(), (List)new .colon.colon((Object)InterruptedIOException.class.getName(), (List)new .colon.colon((Object)ClosedByInterruptException.class.getName(), (List)Nil$.MODULE$)));
    private static final Regex PROXY_ERROR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("py4j.protocol.Py4JJavaError: An error occurred while calling((.|\\r\\n|\\r|\\n)*)(" + MODULE$.IO_EXCEPTION_NAMES().mkString("|") + ")"));

    public String QUERY_ID_KEY() {
        return QUERY_ID_KEY;
    }

    public String RUN_ID_KEY() {
        return RUN_ID_KEY;
    }

    public String IS_CONTINUOUS_PROCESSING() {
        return IS_CONTINUOUS_PROCESSING;
    }

    public Seq<String> IO_EXCEPTION_NAMES() {
        return IO_EXCEPTION_NAMES;
    }

    public Regex PROXY_ERROR() {
        return PROXY_ERROR;
    }

    public boolean isInterruptionException(Throwable e, SparkContext sc) {
        Throwable throwable;
        while (true) {
            if ((throwable = e) instanceof InterruptedException ? true : (throwable instanceof InterruptedIOException ? true : throwable instanceof ClosedByInterruptException)) {
                return true;
            }
            if ((throwable instanceof UncheckedIOException ? true : (throwable instanceof ExecutionException ? true : throwable instanceof UncheckedExecutionException)) && throwable.getCause() != null) {
                e = throwable.getCause();
                continue;
            }
            if (throwable instanceof ForeachBatchUserFuncException) {
                ForeachBatchUserFuncException foreachBatchUserFuncException = (ForeachBatchUserFuncException)((Object)throwable);
                e = foreachBatchUserFuncException.getCause();
                continue;
            }
            if (throwable instanceof ForeachUserFuncException) {
                ForeachUserFuncException foreachUserFuncException = (ForeachUserFuncException)((Object)throwable);
                e = foreachUserFuncException.getCause();
                continue;
            }
            if (!(throwable instanceof SparkException)) break;
            SparkException sparkException = (SparkException)throwable;
            if (sparkException.getCause() == null) {
                return StreamExecution$.isCancelledJobGroup$1(sparkException.getMessage(), sc);
            }
            e = sparkException.getCause();
        }
        if (throwable instanceof Py4JException) {
            Py4JException py4JException = (Py4JException)throwable;
            return this.PROXY_ERROR().findFirstIn((CharSequence)py4JException.getMessage()).isDefined() || py4JException.getMessage().contains("org.apache.spark.SparkException") && StreamExecution$.isCancelledJobGroup$1(py4JException.getMessage(), sc);
        }
        return false;
    }

    public boolean containsSpecialCharsInPath(Path path) {
        String string = path.toUri().getPath();
        String string2 = new Path(path.toUri().toString()).toUri().getPath();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final boolean isCancelledJobGroup$1(String errorMsg, SparkContext sc$1) {
        String jobGroup = sc$1.getLocalProperty("spark.jobGroup.id");
        if (jobGroup == null) {
            return false;
        }
        return errorMsg.contains("cancelled") && errorMsg.contains(jobGroup);
    }

    private StreamExecution$() {
    }
}

