/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.api.java.function.FlatMapGroupsWithStateFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public final class JavaStructuredComplexSessionization {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaStructuredComplexSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        SparkSession spark = SparkSession.builder().appName("JavaStructuredComplexSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        StructType jsonSchema = new StructType().add("user_id", DataTypes.StringType).add("event_type", DataTypes.StringType).add("timestamp", DataTypes.TimestampType);
        final long gapDuration = 5000L;
        Dataset events = lines.select(new Column[]{functions.from_json((Column)functions.col((String)"value"), (StructType)jsonSchema).as("event")}).selectExpr(new String[]{"event.user_id AS user_id", "event.event_type AS event_type", "event.timestamp AS timestamp"}).withWatermark("timestamp", "10 seconds");
        FlatMapGroupsWithStateFunction<String, Row, Sessions, Session> stateUpdateFunc = new FlatMapGroupsWithStateFunction<String, Row, Sessions, Session>(){

            private Iterator<Session> handleEvict(String userId, GroupState<Sessions> state) {
                Sessions sessions = (Sessions)state.get();
                ArrayList evicted = new ArrayList();
                ArrayList<SessionAcc> kept = new ArrayList<SessionAcc>();
                sessions.getSessions().forEach(session -> {
                    if (session.endTime().getTime() < state.getCurrentWatermarkMs()) {
                        evicted.add(session);
                    } else {
                        kept.add((SessionAcc)session);
                    }
                });
                if (kept.isEmpty()) {
                    state.remove();
                } else {
                    state.update((Object)Sessions.newInstance(kept));
                    state.setTimeoutTimestamp(((SessionAcc)kept.get(0)).endTime().getTime());
                }
                return evicted.stream().map(sessionAcc -> Session.newInstance(userId, sessionAcc.endTime().getTime() - sessionAcc.startTime().getTime(), sessionAcc.getEvents().size())).iterator();
            }

            private void mergeSessions(List<SessionAcc> sessionAccs, GroupState<Sessions> state) {
                int curIdx = 0;
                while (curIdx < sessionAccs.size() - 1) {
                    SessionAcc curSession = sessionAccs.get(curIdx);
                    SessionAcc nextSession = sessionAccs.get(curIdx + 1);
                    if (curSession.endTime().getTime() > nextSession.startTime().getTime()) {
                        ArrayList<SessionEvent> accumulatedEvents = new ArrayList<SessionEvent>(curSession.getEvents());
                        accumulatedEvents.addAll(nextSession.getEvents());
                        accumulatedEvents.sort(Comparator.comparingLong(e -> e.getStartTimestamp().getTime()));
                        ArrayList<SessionAcc> newSessions = new ArrayList<SessionAcc>();
                        ArrayList<SessionEvent> eventsForCurSession = new ArrayList<SessionEvent>();
                        for (SessionEvent event : accumulatedEvents) {
                            eventsForCurSession.add(event);
                            if (event.eventType != EventTypes.CLOSE_SESSION) continue;
                            SessionAcc newSessionAcc = SessionAcc.newInstance(eventsForCurSession);
                            newSessions.add(newSessionAcc);
                            eventsForCurSession = new ArrayList();
                        }
                        if (!eventsForCurSession.isEmpty()) {
                            SessionAcc newSessionAcc = SessionAcc.newInstance(eventsForCurSession);
                            newSessions.add(newSessionAcc);
                        }
                        sessionAccs.remove(curIdx + 1);
                        sessionAccs.set(curIdx, (SessionAcc)newSessions.get(0));
                        if (newSessions.size() > 1) {
                            sessionAccs.addAll(curIdx + 1, newSessions.stream().skip(1L).collect(Collectors.toList()));
                        }
                        curIdx += newSessions.size() - 1;
                        continue;
                    }
                    ++curIdx;
                }
                state.update((Object)Sessions.newInstance(sessionAccs));
            }

            public Iterator<Session> call(String userId, Iterator<Row> events, GroupState<Sessions> state) {
                if (state.hasTimedOut() && state.exists()) {
                    return this.handleEvict(userId, state);
                }
                Stream<Row> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(events, 16), false);
                List sessionsFromEvents = stream.map(r -> {
                    SessionEvent event = SessionEvent.newInstance(userId, r.getString(1), r.getTimestamp(2), gapDuration);
                    return SessionAcc.newInstance(event);
                }).collect(Collectors.toList());
                if (sessionsFromEvents.isEmpty()) {
                    return Collections.emptyIterator();
                }
                ArrayList<SessionAcc> allSessions = new ArrayList<SessionAcc>(sessionsFromEvents);
                if (state.exists()) {
                    allSessions.addAll(((Sessions)state.get()).getSessions());
                }
                allSessions.sort(Comparator.comparingLong(s -> s.startTime().getTime()));
                this.mergeSessions(allSessions, state);
                return this.handleEvict(userId, state);
            }
        };
        Dataset sessionUpdates = events.groupByKey((MapFunction & Serializable)event -> event.getString(0), Encoders.STRING()).flatMapGroupsWithState((FlatMapGroupsWithStateFunction)stateUpdateFunc, OutputMode.Append(), Encoders.bean(Sessions.class), Encoders.bean(Session.class), GroupStateTimeout.EventTimeTimeout());
        StreamingQuery query = sessionUpdates.writeStream().outputMode("append").format("console").start();
        query.awaitTermination();
    }

    public static class Sessions {
        private List<SessionAcc> sessions;

        public List<SessionAcc> getSessions() {
            return this.sessions;
        }

        public void setSessions(List<SessionAcc> sessions) {
            if (sessions.isEmpty()) {
                throw new IllegalArgumentException("events should not be empty!");
            }
            ArrayList<SessionAcc> sorted = new ArrayList<SessionAcc>(sessions);
            sorted.sort(Comparator.comparingLong(session -> session.startTime().getTime()));
            this.sessions = sorted;
        }

        public static Sessions newInstance(List<SessionAcc> sessions) {
            Sessions instance = new Sessions();
            instance.setSessions(sessions);
            return instance;
        }
    }

    public static class Session
    implements Serializable {
        private String id;
        private long duration;
        private int numEvents;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public int getNumEvents() {
            return this.numEvents;
        }

        public void setNumEvents(int numEvents) {
            this.numEvents = numEvents;
        }

        public static Session newInstance(String id, long duration, int numEvents) {
            Session instance = new Session();
            instance.setId(id);
            instance.setDuration(duration);
            instance.setNumEvents(numEvents);
            return instance;
        }
    }

    public static class SessionAcc
    implements Serializable {
        private List<SessionEvent> events;

        public Timestamp startTime() {
            return this.events.get((int)0).startTimestamp;
        }

        public Timestamp endTime() {
            return this.events.get(this.events.size() - 1).getEndTimestamp();
        }

        public List<SessionEvent> getEvents() {
            return this.events;
        }

        public void setEvents(List<SessionEvent> events) {
            if (events.isEmpty()) {
                throw new IllegalArgumentException("events should not be empty!");
            }
            ArrayList<SessionEvent> sorted = new ArrayList<SessionEvent>(events);
            sorted.sort(Comparator.comparingLong(event -> event.startTimestamp.getTime()));
            boolean eventCloseSessionExistBeforeLastEvent = sorted.stream().limit(sorted.size() - 1).anyMatch(e -> e.eventType == EventTypes.CLOSE_SESSION);
            if (eventCloseSessionExistBeforeLastEvent) {
                throw new IllegalStateException("CLOSE_SESSION event cannot be placed except the last event!");
            }
            this.events = sorted;
        }

        public static SessionAcc newInstance(SessionEvent event) {
            return SessionAcc.newInstance(Collections.singletonList(event));
        }

        public static SessionAcc newInstance(List<SessionEvent> events) {
            SessionAcc instance = new SessionAcc();
            instance.setEvents(events);
            return instance;
        }
    }

    public static class SessionEvent
    implements Serializable {
        private String userId;
        private EventTypes eventType;
        private Timestamp startTimestamp;
        private Timestamp endTimestamp;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public EventTypes getEventType() {
            return this.eventType;
        }

        public void setEventType(EventTypes eventType) {
            this.eventType = eventType;
        }

        public Timestamp getStartTimestamp() {
            return this.startTimestamp;
        }

        public void setStartTimestamp(Timestamp startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public Timestamp getEndTimestamp() {
            return this.endTimestamp;
        }

        public void setEndTimestamp(Timestamp endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public static SessionEvent newInstance(String userId, String eventTypeStr, Timestamp startTimestamp, long gapDuration) {
            SessionEvent instance = new SessionEvent();
            instance.setUserId(userId);
            instance.setEventType(EventTypes.valueOf(eventTypeStr));
            instance.setStartTimestamp(startTimestamp);
            if (instance.getEventType() == EventTypes.CLOSE_SESSION) {
                instance.setEndTimestamp(instance.getStartTimestamp());
            } else {
                instance.setEndTimestamp(new Timestamp(instance.getStartTimestamp().getTime() + gapDuration));
            }
            return instance;
        }
    }

    public static enum EventTypes {
        NEW_EVENT,
        CLOSE_SESSION;

    }
}

