/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandle;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.StructuredResourceHandle;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.StructuredResourceHandleBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.StructuredResourceHandleFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceHandleFluent<A extends ResourceHandleFluent<A>>
extends BaseFluent<A> {
    private String data;
    private String driverName;
    private StructuredResourceHandleBuilder structuredData;
    private Map<String, Object> additionalProperties;

    public ResourceHandleFluent() {
    }

    public ResourceHandleFluent(ResourceHandle instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceHandle instance) {
        ResourceHandle resourceHandle = instance = instance != null ? instance : new ResourceHandle();
        if (instance != null) {
            this.withData(instance.getData());
            this.withDriverName(instance.getDriverName());
            this.withStructuredData(instance.getStructuredData());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getData() {
        return this.data;
    }

    public A withData(String data) {
        this.data = data;
        return (A)((Object)this);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)((Object)this);
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public StructuredResourceHandle buildStructuredData() {
        return this.structuredData != null ? this.structuredData.build() : null;
    }

    public A withStructuredData(StructuredResourceHandle structuredData) {
        this._visitables.remove((Object)"structuredData");
        if (structuredData != null) {
            this.structuredData = new StructuredResourceHandleBuilder(structuredData);
            this._visitables.get((Object)"structuredData").add(this.structuredData);
        } else {
            this.structuredData = null;
            this._visitables.get((Object)"structuredData").remove((Object)this.structuredData);
        }
        return (A)((Object)this);
    }

    public boolean hasStructuredData() {
        return this.structuredData != null;
    }

    public StructuredDataNested<A> withNewStructuredData() {
        return new StructuredDataNested(null);
    }

    public StructuredDataNested<A> withNewStructuredDataLike(StructuredResourceHandle item) {
        return new StructuredDataNested(item);
    }

    public StructuredDataNested<A> editStructuredData() {
        return this.withNewStructuredDataLike(Optional.ofNullable(this.buildStructuredData()).orElse(null));
    }

    public StructuredDataNested<A> editOrNewStructuredData() {
        return this.withNewStructuredDataLike(Optional.ofNullable(this.buildStructuredData()).orElse(new StructuredResourceHandleBuilder().build()));
    }

    public StructuredDataNested<A> editOrNewStructuredDataLike(StructuredResourceHandle item) {
        return this.withNewStructuredDataLike(Optional.ofNullable(this.buildStructuredData()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceHandleFluent that = (ResourceHandleFluent)((Object)o);
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals((Object)this.structuredData, (Object)that.structuredData)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.driverName, this.structuredData, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.structuredData != null) {
            sb.append("structuredData:");
            sb.append(this.structuredData + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StructuredDataNested<N>
    extends StructuredResourceHandleFluent<StructuredDataNested<N>>
    implements Nested<N> {
        StructuredResourceHandleBuilder builder;

        StructuredDataNested(StructuredResourceHandle item) {
            this.builder = new StructuredResourceHandleBuilder(this, item);
        }

        public N and() {
            return (N)ResourceHandleFluent.this.withStructuredData(this.builder.build());
        }

        public N endStructuredData() {
            return this.and();
        }
    }
}

