/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.ShiroException;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.realm.text.TextConfigurationRealm;
import org.apache.shiro.util.Destroyable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesRealm
extends TextConfigurationRealm
implements Destroyable,
Runnable {
    private static final int DEFAULT_RELOAD_INTERVAL_SECONDS = 10;
    private static final String USERNAME_PREFIX = "user.";
    private static final String ROLENAME_PREFIX = "role.";
    private static final String DEFAULT_RESOURCE_PATH = "classpath:shiro-users.properties";
    private static final Logger log = LoggerFactory.getLogger(PropertiesRealm.class);
    protected ExecutorService scheduler = null;
    protected boolean useXmlFormat = false;
    protected String resourcePath = "classpath:shiro-users.properties";
    protected long fileLastModified;
    protected int reloadIntervalSeconds = 10;

    public void setUseXmlFormat(boolean useXmlFormat) {
        this.useXmlFormat = useXmlFormat;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setReloadIntervalSeconds(int reloadIntervalSeconds) {
        this.reloadIntervalSeconds = reloadIntervalSeconds;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.afterRoleCacheSet();
    }

    protected void afterRoleCacheSet() {
        this.loadProperties();
        if (this.resourcePath.startsWith("file:") && this.scheduler == null) {
            this.startReloadThread();
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Unable to cleanly shutdown Scheduler.  Ignoring (shutting down)...", (Throwable)e);
            }
        }
        finally {
            this.scheduler = null;
        }
    }

    protected void startReloadThread() {
        if (this.reloadIntervalSeconds > 0) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            ((ScheduledExecutorService)this.scheduler).scheduleAtFixedRate(this, this.reloadIntervalSeconds, this.reloadIntervalSeconds, TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.reloadPropertiesIfNecessary();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Error while reloading property files for realm.", (Throwable)e);
            }
        }
    }

    private void loadProperties() {
        if (this.resourcePath == null || this.resourcePath.length() == 0) {
            throw new IllegalStateException("The resourcePath property is not set.  It must be set prior to this realm being initialized.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading user security information from file [" + this.resourcePath + "]...");
        }
        Properties properties = this.loadProperties(this.resourcePath);
        this.createRealmEntitiesFromProperties(properties);
    }

    private Properties loadProperties(String resourcePath) {
        InputStream is;
        Properties props;
        block8: {
            props = new Properties();
            is = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Opening input stream for path [" + resourcePath + "]...");
                }
                is = ResourceUtils.getInputStreamForPath(resourcePath);
                if (this.useXmlFormat) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading properties from path [" + resourcePath + "] in XML format...");
                    }
                    props.loadFromXML(is);
                    break block8;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Loading properties from path [" + resourcePath + "]...");
                }
                props.load(is);
            }
            catch (IOException e) {
                try {
                    throw new ShiroException("Error reading properties path [" + resourcePath + "].  Initializing of the realm from this file failed.", e);
                }
                catch (Throwable throwable) {
                    ResourceUtils.close(is);
                    throw throwable;
                }
            }
        }
        ResourceUtils.close(is);
        return props;
    }

    private void reloadPropertiesIfNecessary() {
        if (this.isSourceModified()) {
            this.restart();
        }
    }

    private boolean isSourceModified() {
        return this.resourcePath.startsWith("file:") && this.isFileModified();
    }

    private boolean isFileModified() {
        String fileNameWithoutPrefix = this.resourcePath.substring(this.resourcePath.indexOf(":") + 1);
        File propertyFile = new File(fileNameWithoutPrefix);
        long currentLastModified = propertyFile.lastModified();
        if (currentLastModified > this.fileLastModified) {
            this.fileLastModified = currentLastModified;
            return true;
        }
        return false;
    }

    private void restart() {
        if (this.resourcePath == null || this.resourcePath.length() == 0) {
            throw new IllegalStateException("The resourcePath property is not set.  It must be set prior to this realm being initialized.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading user security information from file [" + this.resourcePath + "]...");
        }
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    private void createRealmEntitiesFromProperties(Properties properties) {
        StringBuilder userDefs = new StringBuilder();
        StringBuilder roleDefs = new StringBuilder();
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = ((String)propNames.nextElement()).trim();
            String value = properties.getProperty(key).trim();
            if (log.isTraceEnabled()) {
                log.trace("Processing properties line - key: [" + key + "], value: [" + value + "].");
            }
            if (this.isUsername(key)) {
                String username = this.getUsername(key);
                userDefs.append(username).append(" = ").append(value).append("\n");
                continue;
            }
            if (this.isRolename(key)) {
                String rolename = this.getRolename(key);
                roleDefs.append(rolename).append(" = ").append(value).append("\n");
                continue;
            }
            String msg = "Encountered unexpected key/value pair.  All keys must be prefixed with either 'user.' or 'role.'.";
            throw new IllegalStateException(msg);
        }
        this.setUserDefinitions(userDefs.toString());
        this.setRoleDefinitions(roleDefs.toString());
        this.processDefinitions();
    }

    protected String getName(String key, String prefix) {
        return key.substring(prefix.length(), key.length());
    }

    protected boolean isUsername(String key) {
        return key != null && key.startsWith(USERNAME_PREFIX);
    }

    protected boolean isRolename(String key) {
        return key != null && key.startsWith(ROLENAME_PREFIX);
    }

    protected String getUsername(String key) {
        return this.getName(key, USERNAME_PREFIX);
    }

    protected String getRolename(String key) {
        return this.getName(key, ROLENAME_PREFIX);
    }
}

