/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.config;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.type.JdbcType;
import org.apache.streampark.console.base.mybatis.interceptor.PostgreSQLPrepareInterceptor;
import org.apache.streampark.console.base.mybatis.interceptor.PostgreSQLQueryInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"org.apache.streampark.console.*.mapper"})
public class MybatisConfig {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(name={"datasource.dialect"}, havingValue="pgsql")
    public PostgreSQLQueryInterceptor postgreSQLQueryInterceptor() {
        return new PostgreSQLQueryInterceptor();
    }

    @Bean
    @ConditionalOnProperty(name={"datasource.dialect"}, havingValue="pgsql")
    public PostgreSQLPrepareInterceptor postgreSQLPrepareInterceptor() {
        return new PostgreSQLPrepareInterceptor();
    }

    @Bean
    @ConditionalOnProperty(name={"spring.profiles.active"}, havingValue="pgsql")
    public PostgreSQLQueryInterceptor postgreSQLQueryInterceptorForCompatibility() {
        return new PostgreSQLQueryInterceptor();
    }

    @Bean
    @ConditionalOnProperty(name={"spring.profiles.active"}, havingValue="pgsql")
    public PostgreSQLPrepareInterceptor postgreSQLPrepareInterceptorForCompatibility() {
        return new PostgreSQLPrepareInterceptor();
    }

    @Bean
    public MybatisPlusPropertiesCustomizer mybatisPlusPropertiesCustomizer() {
        return properties -> {
            properties.setTypeAliasesPackage("org.apache.streampark.console.*.entity");
            properties.setMapperLocations(new String[]{"classpath:mapper/*/*.xml"});
            MybatisConfiguration mybatisConfiguration = new MybatisConfiguration();
            mybatisConfiguration.setJdbcTypeForNull(JdbcType.NULL);
            properties.setConfiguration(mybatisConfiguration);
            GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig((org.apache.ibatis.session.Configuration)mybatisConfiguration);
            GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
            dbConfig.setIdType(IdType.AUTO);
            globalConfig.setBanner(false);
            properties.setGlobalConfig(globalConfig);
        };
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.put("MySQL", "mysql");
        properties.setProperty("H2", "mysql");
        properties.setProperty("PostgreSQL", "pgsql");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }
}

