/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.schema.Schema;
import java.util.regex.Pattern;

public class StringConstant
extends Expression {
    private final String value;
    private static final Pattern ONLY_SPACES = Pattern.compile("^\\s*$", 32);

    public StringConstant(Node fromNode, Schema schema, String value) {
        super(fromNode, schema);
        this.value = value;
    }

    public StringConstant(SourcePosition pos, Schema schema, String value) {
        this(pos, "text", schema, value);
    }

    private StringConstant(SourcePosition sourcePosition, String displayName, Schema schema, String value) {
        super(sourcePosition, displayName, schema);
        this.value = value;
    }

    public String evaluate() {
        return this.value;
    }

    @Override
    public boolean alwaysEmpty() {
        return this.value.length() == 0;
    }

    @Override
    public boolean alwaysOnlyWhitespace() {
        return ONLY_SPACES.matcher(this.value).matches();
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitStringConstant(this);
    }

    @Override
    public boolean alwaysEquals(Expression that) {
        return that instanceof StringConstant && ((StringConstant)that).evaluate() == this.evaluate() && that.getSchema() != null && that.getSchema().equals((Object)this.getSchema());
    }

    public String toString() {
        return this.getDisplayName() + "=StringConstant@" + this.getSourcePosition() + "(\"" + CharEscapers.javaStringEscaper().escape(this.evaluate()) + "\")";
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof StringConstant && this.equals((StringConstant)that);
    }

    public boolean equals(StringConstant that) {
        return this.equalsExpression(that) && this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.value);
    }

    @Override
    public String getStaticString(AlertSink alertSink, String fallback) {
        return this.evaluate();
    }

    @Override
    public boolean hasStaticString() {
        return true;
    }
}

