/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LogMessageSummarizer;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.logging.DefaultLogMessageSummarizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingUtils {
    private static final int CHAR_REPEAT_ACCOUNT = 60;
    private static final String LOGGER_NAME_PROTOCOL_MESSAGE = "PROTOCOL_MESSAGE";
    private static final LogMessageSummarizer LOG_MESSAGE_SUMMARIZER = ServiceLoader.load(LogMessageSummarizer.class).findFirst().orElseGet(DefaultLogMessageSummarizer::new);

    public static void protocolMessage(String title, Map<String, Object> context) {
        LoggingUtils.protocolMessage(title, context, "");
    }

    public static void protocolMessage(String title, Object message) {
        LoggingUtils.protocolMessage(title, Map.of(), message);
    }

    public static void protocolMessage(String title, Map<String, Object> context, Object message) {
        if (LoggingUtils.isProtocolMessageLoggerEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            builder.append(StringUtils.repeat((char)'=', (int)60));
            builder.append(String.format("\n%s\n", title));
            builder.append(StringUtils.repeat((char)'=', (int)60));
            builder.append('\n');
            context.forEach((key, value) -> {
                String toLog = DigestUtils.abbreviate(value.toString());
                if (StringUtils.isNotBlank((CharSequence)toLog)) {
                    builder.append(String.format("%s: %s\n", key, toLog));
                }
            });
            if (!context.isEmpty()) {
                builder.append(StringUtils.repeat((char)'=', (int)60));
                builder.append('\n');
            }
            if (message != null && StringUtils.isNotBlank((CharSequence)message.toString())) {
                builder.append(String.format("%s\n", message));
                builder.append(StringUtils.repeat((char)'=', (int)60));
            }
            String result = builder.toString();
            LoggerFactory.getLogger((String)LOGGER_NAME_PROTOCOL_MESSAGE).info(result);
        }
    }

    public static boolean isProtocolMessageLoggerEnabled() {
        return LoggerFactory.getLogger((String)LOGGER_NAME_PROTOCOL_MESSAGE).isInfoEnabled();
    }

    public static void error(Logger logger, String msg) {
        logger.error(msg);
    }

    public static void error(Logger logger, String msg, Throwable throwable) {
        FunctionUtils.doIf(LOG_MESSAGE_SUMMARIZER.shouldSummarize(logger), __ -> logger.error(LOG_MESSAGE_SUMMARIZER.summarizeStackTrace(msg, throwable)), __ -> logger.error(msg, throwable)).accept(throwable);
    }

    public static void error(Logger logger, Throwable throwable) {
        if (throwable != null) {
            LoggingUtils.error(logger, LoggingUtils.getMessage(throwable), throwable);
        }
    }

    public static void warn(Logger logger, Throwable throwable) {
        LoggingUtils.warn(logger, LoggingUtils.getMessage(throwable), throwable);
    }

    public static void warn(Logger logger, String message, Throwable throwable) {
        FunctionUtils.doIf(LOG_MESSAGE_SUMMARIZER.shouldSummarize(logger), __ -> logger.warn(LOG_MESSAGE_SUMMARIZER.summarizeStackTrace(message, throwable)), __ -> logger.warn(message, throwable)).accept(throwable);
    }

    public static String getMessage(Throwable throwable) {
        Optional<String> message;
        if (StringUtils.isEmpty((CharSequence)throwable.getMessage()) && (message = ExceptionUtils.getThrowableList((Throwable)throwable).stream().map(Throwable::getMessage).filter(Objects::nonNull).findFirst()).isPresent()) {
            return message.get();
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)throwable.getMessage(), (CharSequence)throwable.getClass().getSimpleName());
    }

    @Generated
    private LoggingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

