/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.audit.BaseAuditableExecution;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.inspektr.audit.annotation.Audit;
import org.pac4j.core.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer
extends BaseAuditableExecution {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceDelegatedAuthenticationPolicyAuditableEnforcer.class);

    @Audit(action="DELEGATED_CLIENT", actionResolverName="DELEGATED_CLIENT_ACTION_RESOLVER", resourceResolverName="DELEGATED_CLIENT_RESOURCE_RESOLVER")
    public AuditableExecutionResult execute(AuditableContext context) {
        AuditableExecutionResult result = AuditableExecutionResult.of((AuditableContext)context);
        if (context.getRegisteredService().isPresent() && context.getProperties().containsKey(Client.class.getSimpleName())) {
            RegisteredService registeredService = (RegisteredService)context.getRegisteredService().orElseThrow();
            String clientName = context.getProperties().get(Client.class.getSimpleName()).toString();
            LOGGER.trace("Checking delegated access strategy of [{}] for client [{}]", (Object)registeredService, (Object)clientName);
            RegisteredServiceDelegatedAuthenticationPolicy policy = registeredService.getAccessStrategy().getDelegatedAuthenticationPolicy();
            if (policy != null && !policy.isProviderAllowed(clientName, registeredService)) {
                LOGGER.debug("Delegated access strategy for [{}] does not permit client [{}]", (Object)registeredService, (Object)clientName);
                result.setException((Throwable)UnauthorizedServiceException.denied((String)clientName));
            }
        }
        return result;
    }
}

