/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.ticket.Ticket;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public final class DelegationWebflowUtils {
    public static final String FLOW_SCOPE_ATTR_DELEGATED_AUTHN_PROVIDER_PRIMARY = "delegatedAuthenticationProviderPrimary";

    public static <T> T getDelegatedClientAuthenticationCandidateProfile(RequestContext context, Class<T> clazz) {
        return (T)context.getFlashScope().get("delegatedClientAuthenticationCandidateProfile", clazz);
    }

    public static boolean hasDelegatedClientAuthenticationCandidateProfile(RequestContext context) {
        return context.getFlashScope().contains("delegatedClientAuthenticationCandidateProfile");
    }

    public static void putDelegatedClientAuthenticationCandidateProfile(RequestContext context, Serializable profile) {
        context.getFlashScope().put("delegatedClientAuthenticationCandidateProfile", (Object)profile);
    }

    public static void putDelegatedAuthenticationLogoutRequest(RequestContext requestContext, Serializable logoutAction) {
        requestContext.getFlashScope().put("delegatedAuthenticationLogoutRequest", (Object)logoutAction);
    }

    public static <T> T getDelegatedAuthenticationLogoutRequest(RequestContext requestContext, Class<T> clazz) {
        return (T)requestContext.getFlashScope().get("delegatedAuthenticationLogoutRequest", clazz);
    }

    public static void putDelegatedAuthenticationDisabled(RequestContext requestContext, boolean disabled) {
        requestContext.getFlowScope().put("delegatedAuthenticationDisabled", (Object)disabled);
    }

    public static void putDelegatedClientAuthenticationResolvedCredentials(RequestContext context, List<? extends Serializable> candidateMatches) {
        context.getFlowScope().put("delegatedAuthenticationCredentials", candidateMatches);
    }

    public static <T extends Serializable> List<T> getDelegatedClientAuthenticationResolvedCredentials(RequestContext context, Class<T> clazz) {
        List results = (List)context.getFlowScope().get("delegatedAuthenticationCredentials", List.class);
        return (List)ObjectUtils.defaultIfNull((Object)results, List.of());
    }

    public static String getDelegatedAuthenticationClientName(RequestContext requestContext) {
        return (String)requestContext.getFlowScope().get("delegatedAuthenticationClientName", String.class);
    }

    public static void putDelegatedAuthenticationClientName(RequestContext requestContext, String clientName) {
        requestContext.getFlowScope().put("delegatedAuthenticationClientName", (Object)clientName);
    }

    public static Set<? extends Serializable> getDelegatedAuthenticationProviderConfigurations(RequestContext context) {
        MutableAttributeMap scope = context.getFlowScope();
        if (scope.contains("delegatedAuthenticationProviderConfigurations", Set.class)) {
            return (Set)scope.get("delegatedAuthenticationProviderConfigurations", Set.class);
        }
        return new HashSet(0);
    }

    public static void putDelegatedAuthenticationProviderConfigurations(RequestContext context, Set<? extends Serializable> urls) {
        context.getFlowScope().put("delegatedAuthenticationProviderConfigurations", urls);
    }

    public static void putDelegatedAuthenticationDynamicProviderSelection(RequestContext context, Boolean result) {
        context.getFlowScope().put("delegatedAuthenticationDynamicProviderSelection", (Object)result);
    }

    public static Boolean isDelegatedAuthenticationDynamicProviderSelection(RequestContext context) {
        return (Boolean)context.getFlowScope().get("delegatedAuthenticationDynamicProviderSelection", Boolean.class, (Object)Boolean.FALSE);
    }

    public static void putDelegatedAuthenticationProviderPrimary(RequestContext context, Serializable client) {
        context.getFlowScope().put(FLOW_SCOPE_ATTR_DELEGATED_AUTHN_PROVIDER_PRIMARY, (Object)client);
    }

    public static Object getDelegatedAuthenticationProviderPrimary(RequestContext context) {
        return context.getFlowScope().get(FLOW_SCOPE_ATTR_DELEGATED_AUTHN_PROVIDER_PRIMARY);
    }

    public static void putDelegatedAuthenticationLogoutRequestTicket(RequestContext requestContext, Ticket ticket) {
        if (ticket == null) {
            requestContext.getFlowScope().remove(FLOW_SCOPE_ATTR_DELEGATED_AUTHN_PROVIDER_PRIMARY);
        } else {
            requestContext.getFlowScope().put(FLOW_SCOPE_ATTR_DELEGATED_AUTHN_PROVIDER_PRIMARY, (Object)ticket);
        }
    }

    public static Ticket getDelegatedAuthenticationLogoutRequestTicket(RequestContext requestContext) {
        return (Ticket)requestContext.getFlowScope().get(FLOW_SCOPE_ATTR_DELEGATED_AUTHN_PROVIDER_PRIMARY, Ticket.class);
    }

    @Generated
    private DelegationWebflowUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

