/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.loader;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.loader.BaseConfigurationPropertiesLoader;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class SimpleConfigurationPropertiesLoader
extends BaseConfigurationPropertiesLoader {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleConfigurationPropertiesLoader.class);

    @Override
    public PropertySource load(Resource resource, Environment environment, String name, CipherExecutor<String, String> configurationCipherExecutor) {
        Properties props = new Properties();
        try (InputStream is = resource.getInputStream();){
            LOGGER.debug("Located CAS configuration file at [{}]", (Object)resource);
            props.load(is);
            LOGGER.debug("Found settings [{}] in file [{}]", props.keySet(), (Object)resource);
            props.putAll(this.decryptProperties(configurationCipherExecutor, props));
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
        }
        return this.finalizeProperties(name, props);
    }

    @Override
    public boolean supports(Resource resource) {
        String filename = StringUtils.defaultString((String)resource.getFilename()).toLowerCase(Locale.ENGLISH);
        return filename.endsWith(".properties");
    }

    @Generated
    public SimpleConfigurationPropertiesLoader() {
    }
}

