/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractProcessStartEventSubscriptionCmd;
import org.flowable.engine.impl.runtime.ProcessInstanceStartEventSubscriptionBuilderImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionBuilder;
import org.flowable.eventsubscription.service.EventSubscriptionService;

public class RegisterProcessInstanceStartEventSubscriptionCmd
extends AbstractProcessStartEventSubscriptionCmd
implements Command<EventSubscription>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ProcessInstanceStartEventSubscriptionBuilderImpl builder;

    public RegisterProcessInstanceStartEventSubscriptionCmd(ProcessInstanceStartEventSubscriptionBuilderImpl builder) {
        this.builder = builder;
    }

    public EventSubscription execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = this.getLatestProcessDefinitionByKey(this.builder.getProcessDefinitionKey(), this.builder.getTenantId(), commandContext);
        Process process = this.getProcess(processDefinition.getId(), commandContext);
        EventSubscription eventSubscription = null;
        List startEvents = process.findFlowElementsOfType(StartEvent.class, false);
        for (StartEvent startEvent : startEvents) {
            List correlationConfiguration;
            List eventTypeElements = (List)startEvent.getExtensionElements().get("eventType");
            if (eventTypeElements == null || eventTypeElements.size() <= 0 || (correlationConfiguration = (List)startEvent.getExtensionElements().get("startEventCorrelationConfiguration")) == null || correlationConfiguration.size() <= 0 || !"manualSubscription".equals(((ExtensionElement)correlationConfiguration.get(0)).getElementText())) continue;
            if (eventSubscription != null) {
                throw new FlowableIllegalArgumentException("The process definition with id " + processDefinition.getId() + " has more than one event-registry start events based on manually registered subscriptions, which is currently not supported.");
            }
            String eventDefinitionKey = ((ExtensionElement)eventTypeElements.get(0)).getElementText();
            String correlationKey = this.generateCorrelationConfiguration(eventDefinitionKey, this.builder.getTenantId(), this.builder.getCorrelationParameterValues(), commandContext);
            eventSubscription = this.insertEventRegistryEvent(eventDefinitionKey, this.builder.isDoNotUpdateToLatestVersionAutomatically(), startEvent, processDefinition, correlationKey, commandContext);
        }
        if (eventSubscription == null) {
            throw new FlowableIllegalArgumentException("The process definition with id '" + processDefinition.getId() + "' does not have an event-registry based start event with a manual subscription behavior.");
        }
        return eventSubscription;
    }

    protected EventSubscription insertEventRegistryEvent(String eventDefinitionKey, boolean doNotUpdateToLatestVersionAutomatically, StartEvent startEvent, ProcessDefinition processDefinition, String correlationKey, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        EventSubscriptionBuilder eventSubscriptionBuilder = eventSubscriptionService.createEventSubscriptionBuilder().eventType(eventDefinitionKey).activityId(startEvent.getId()).processDefinitionId(processDefinition.getId()).scopeType("bpmn").configuration(correlationKey);
        if (processDefinition.getTenantId() != null) {
            eventSubscriptionBuilder.tenantId(processDefinition.getTenantId());
        }
        if (!doNotUpdateToLatestVersionAutomatically) {
            eventSubscriptionBuilder.scopeDefinitionKey(processDefinition.getKey());
        }
        EventSubscription eventSubscription = eventSubscriptionBuilder.create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount(eventSubscription);
        return eventSubscription;
    }
}

