/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.Topology;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.protocol.ws.api.WebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

public class TopologyWebSocketBehavior
extends WebSocketBehavior {
    private static final long serialVersionUID = -1653665542635275551L;
    protected static final Logger LOG = LoggerFactory.getLogger(TopologyWebSocketBehavior.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected static final String CONNECTOR_TEST_TIMEOUT_PARAMETER = "connector.test.timeout";
    protected static final String RESOURCE_TEST_TIMEOUT_PARAMETER = "resource.test.timeout";
    @SpringBean
    protected ServiceOps serviceOps;
    @SpringBean
    protected ConfParamOps confParamOps;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    protected final Map<String, String> connectors = Collections.synchronizedMap(new HashMap());
    protected final Set<String> runningConnCheck = Collections.synchronizedSet(new HashSet());
    protected final Map<String, String> resources = Collections.synchronizedMap(new HashMap());
    protected final Set<String> runningResCheck = Collections.synchronizedSet(new HashSet());
    protected final transient SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor();
    protected String coreAddress;
    protected String domain;
    protected String jwt;
    protected Integer connectorTestTimeout = null;
    protected Integer resourceTestTimeout = null;

    public TopologyWebSocketBehavior() {
        this.executor.setVirtualThreads(true);
        this.coreAddress = this.serviceOps.get(NetworkService.Type.CORE).getAddress();
        this.domain = SyncopeConsoleSession.get().getDomain();
        this.jwt = SyncopeConsoleSession.get().getJWT();
        try {
            this.connectorTestTimeout = (Integer)this.confParamOps.get(this.domain, CONNECTOR_TEST_TIMEOUT_PARAMETER, null, Integer.class);
            this.resourceTestTimeout = (Integer)this.confParamOps.get(this.domain, RESOURCE_TEST_TIMEOUT_PARAMETER, null, Integer.class);
        }
        catch (Exception e) {
            LOG.debug("No {} or {} conf parameters found", new Object[]{CONNECTOR_TEST_TIMEOUT_PARAMETER, RESOURCE_TEST_TIMEOUT_PARAMETER, e});
        }
    }

    protected void timeoutHandlingConnectionChecker(Checker checker, Integer timeout, Map<String, String> responses, Set<String> running) {
        String response;
        try {
            if (timeout == null || timeout < 0) {
                LOG.debug("No timeouts for resource connection checking ... ");
                response = (String)checker.call();
            } else {
                LOG.debug("Timeouts provided for resource connection checking ... ");
                response = (String)this.executor.submit((Callable)checker).get(timeout.intValue(), TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.warn("Connection with {} timed out", (Object)checker.key);
            response = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNREACHABLE, checker.key});
        }
        catch (Exception e) {
            LOG.error("Unexpected exception connecting to {}", (Object)checker.key, (Object)e);
            response = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, checker.key});
        }
        Optional.ofNullable(response).ifPresent(r -> responses.put(checker.key, (String)r));
        running.remove(checker.key);
    }

    protected void onMessage(WebSocketRequestHandler handler, TextMessage message) {
        try {
            JsonNode obj = MAPPER.readTree(message.getText());
            switch (Topology.SupportedOperation.valueOf(obj.get("kind").asText())) {
                case CHECK_CONNECTOR: {
                    String ckey = obj.get("target").asText();
                    if (this.connectors.containsKey(ckey)) {
                        handler.push((CharSequence)this.connectors.get(ckey));
                    } else {
                        handler.push((CharSequence)String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNKNOWN, ckey}));
                    }
                    if (this.runningConnCheck.contains(ckey)) {
                        LOG.debug("Running connection check for connector {}", (Object)ckey);
                        break;
                    }
                    try {
                        this.timeoutHandlingConnectionChecker(new ConnectorChecker(ckey), this.connectorTestTimeout, this.connectors, this.runningConnCheck);
                        this.runningConnCheck.add(ckey);
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected error", (Throwable)e);
                    }
                    break;
                }
                case CHECK_RESOURCE: {
                    String rkey = obj.get("target").asText();
                    if (this.resources.containsKey(rkey)) {
                        handler.push((CharSequence)this.resources.get(rkey));
                    } else {
                        handler.push((CharSequence)String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNKNOWN, rkey}));
                    }
                    if (this.runningResCheck.contains(rkey)) {
                        LOG.debug("Running connection check for resource {}", (Object)rkey);
                        break;
                    }
                    try {
                        this.timeoutHandlingConnectionChecker(new ResourceChecker(rkey), this.resourceTestTimeout, this.resources, this.runningResCheck);
                        this.runningResCheck.add(rkey);
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected error", (Throwable)e);
                    }
                    break;
                }
                case ADD_ENDPOINT: {
                    handler.appendJavaScript((CharSequence)String.format("addEndpoint('%s', '%s', '%s');", obj.get("source").asText(), obj.get("target").asText(), obj.get("scope").asText()));
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error managing websocket message", (Throwable)e);
        }
    }

    public boolean connCheckDone(Collection<String> connectors) {
        return this.connectors.keySet().containsAll(connectors);
    }

    public boolean resCheckDone(Collection<String> resources) {
        return this.resources.keySet().containsAll(resources);
    }

    protected abstract class Checker
    implements Callable<String> {
        protected final String key;

        Checker(TopologyWebSocketBehavior this$0, String key) {
            this.key = key;
        }
    }

    protected class ConnectorChecker
    extends Checker {
        ConnectorChecker(String key) {
            super(TopologyWebSocketBehavior.this, key);
        }

        @Override
        public String call() {
            try {
                return String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyWebSocketBehavior.this.connectorRestClient.check(TopologyWebSocketBehavior.this.coreAddress, TopologyWebSocketBehavior.this.domain, TopologyWebSocketBehavior.this.jwt, this.key) ? TopologyNode.Status.REACHABLE : TopologyNode.Status.UNREACHABLE, this.key});
            }
            catch (Exception e) {
                LOG.warn("Error checking connection for {}", (Object)this.key, (Object)e);
                return String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, this.key});
            }
        }
    }

    protected class ResourceChecker
    extends Checker {
        ResourceChecker(String key) {
            super(TopologyWebSocketBehavior.this, key);
        }

        @Override
        public String call() {
            try {
                return String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyWebSocketBehavior.this.resourceRestClient.check(TopologyWebSocketBehavior.this.coreAddress, TopologyWebSocketBehavior.this.domain, TopologyWebSocketBehavior.this.jwt, this.key) ? TopologyNode.Status.REACHABLE : TopologyNode.Status.UNREACHABLE, this.key});
            }
            catch (Exception e) {
                LOG.warn("Error checking connection for {}", (Object)this.key, (Object)e);
                return String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, this.key});
            }
        }
    }
}

