/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import org.springframework.expression.Expression;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;

final class PreFilterExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<PreFilterExpressionAttribute> {
    private SecurityAnnotationScanner<PreFilter> scanner = SecurityAnnotationScanners.requireUnique(PreFilter.class);

    PreFilterExpressionAttributeRegistry() {
    }

    @Override
    @NonNull
    PreFilterExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        PreFilter preFilter = this.findPreFilterAnnotation(method, targetClass);
        if (preFilter == null) {
            return PreFilterExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression preFilterExpression = this.getExpressionHandler().getExpressionParser().parseExpression(preFilter.value());
        return new PreFilterExpressionAttribute(preFilterExpression, preFilter.filterTarget());
    }

    @Override
    void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.scanner = SecurityAnnotationScanners.requireUnique(PreFilter.class, defaults);
    }

    private PreFilter findPreFilterAnnotation(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = this.targetClass(method, targetClass);
        return this.scanner.scan(method, targetClassToUse);
    }

    static final class PreFilterExpressionAttribute
    extends ExpressionAttribute {
        static final PreFilterExpressionAttribute NULL_ATTRIBUTE = new PreFilterExpressionAttribute(null, null);
        private final String filterTarget;

        private PreFilterExpressionAttribute(Expression expression, String filterTarget) {
            super(expression);
            this.filterTarget = filterTarget;
        }

        String getFilterTarget() {
            return this.filterTarget;
        }
    }
}

