/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Schema;

public abstract class AbstractSchemaRepoExt {
    protected final EntityManager entityManager;

    protected AbstractSchemaRepoExt(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected <S extends Schema> List<S> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses, String entity, Class<S> reference) {
        if (anyTypeClasses.isEmpty()) {
            return List.of();
        }
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(entity).append(" e WHERE ");
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList<CallSite> clauses = new ArrayList<CallSite>();
        int clausesIdx = 0;
        for (AnyTypeClass anyTypeClass : anyTypeClasses) {
            clauses.add((CallSite)((Object)("e.anyTypeClass.id=?" + (clausesIdx + 1))));
            parameters.add(anyTypeClass.getKey());
            ++clausesIdx;
        }
        queryString.append(String.join((CharSequence)" OR ", clauses));
        TypedQuery query = this.entityManager.createQuery(queryString.toString(), reference);
        for (int i = 0; i < parameters.size(); ++i) {
            query.setParameter(i + 1, parameters.get(i));
        }
        return query.getResultList();
    }
}

