/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.utils;

import java.util.Arrays;
import java.util.List;
import net.tirasa.connid.bundles.okta.utils.OktaFilterOp;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.Uid;

public class OktaFilter {
    public static final List<String> ID_ATTRS = Arrays.asList("id", Uid.NAME);
    public static final List<String> USER_NAME_ATTRS = Arrays.asList("login", Name.NAME);
    public static final List<String> GROUP_NAME_ATTRS = Arrays.asList("name", Name.NAME);
    private final OktaFilterOp filterOp;
    private final String attribute;
    private final String value;
    private final boolean quote;
    private final List<OktaFilter> filters;

    public OktaFilter(OktaFilterOp filterOp, String attribute, String value, boolean quote, List<OktaFilter> filters) {
        this.filterOp = filterOp;
        this.attribute = attribute;
        this.value = value;
        this.quote = quote;
        this.filters = filters;
    }

    public OktaFilterOp getFilterOp() {
        return this.filterOp;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isQuote() {
        return this.quote;
    }

    public List<OktaFilter> getFilters() {
        return this.filters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        switch (this.filterOp) {
            case AND: 
            case OR: {
                for (int i = 0; i < this.filters.size(); ++i) {
                    if (i != 0) {
                        builder.append(' ');
                        builder.append((Object)this.filterOp);
                        builder.append(' ');
                    }
                    builder.append(this.filters.get(i));
                }
                break;
            }
            case EQUALS: 
            case CONTAINS: 
            case STARTS_WITH: 
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_OR_EQUAL: {
                builder.append(this.attribute);
                builder.append(' ');
                builder.append((Object)this.filterOp);
                builder.append(' ');
                if (this.quote) {
                    builder.append("\"");
                    builder.append(this.escape(this.value));
                    builder.append("\"");
                    break;
                }
                builder.append(this.value);
                break;
            }
            case IS_PRESENT: {
                builder.append(this.attribute);
                builder.append(' ');
                builder.append((Object)this.filterOp);
                break;
            }
        }
    }

    private String escape(String value) {
        return value.replace("\"", "\\\"");
    }
}

