/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class GoogleAppsPropagationActions
implements PropagationActions {
    protected static final Logger LOG = LoggerFactory.getLogger(GoogleAppsPropagationActions.class);

    protected String getEmailAttrName() {
        return "emails";
    }

    @Transactional
    public void before(PropagationTaskInfo taskInfo) {
        if (taskInfo.getOperation() == ResourceOperation.DELETE || taskInfo.getOperation() == ResourceOperation.NONE) {
            return;
        }
        if (AnyTypeKind.USER != taskInfo.getAnyTypeKind()) {
            return;
        }
        PropagationData data = taskInfo.getPropagationData();
        if (data.getAttributes() != null) {
            Set attrs = data.getAttributes();
            if (AttributeUtil.find((String)this.getEmailAttrName(), (Set)attrs) == null) {
                LOG.warn("Can't find {} to set as {} attribute value, skipping...", (Object)this.getEmailAttrName(), (Object)Name.NAME);
                return;
            }
            Optional.ofNullable(AttributeUtil.getNameFromAttributes((Set)attrs)).ifPresent(attrs::remove);
            attrs.add(new Name(AttributeUtil.find((String)this.getEmailAttrName(), (Set)attrs).getValue().getFirst().toString()));
        }
    }
}

