/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server;

import java.io.File;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.LogManager;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.server.ConnectorServer;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class Main {
    private static final String PROP_PORT = "connectorserver.port";
    private static final String PROP_BUNDLE_DIR = "connectorserver.bundleDir";
    private static final String PROP_LIB_DIR = "connectorserver.libDir";
    private static final String PROP_SSL = "connectorserver.usessl";
    private static final String PROP_IFADDRESS = "connectorserver.ifaddress";
    private static final String PROP_KEY = "connectorserver.key";
    private static final String PROP_LOGGER_CLASS = "connectorserver.loggerClass";
    private static final String DEFAULT_LOG_SPI = "org.identityconnectors.common.logging.StdOutLogger";
    private static ConnectorServer connectorServer;
    private static Log log;

    private static void usage() {
        System.out.println("Usage: Main -run -properties <connectorserver.properties>");
        System.out.println("       Main -setKey -key <key> -properties <connectorserver.properties>");
        System.out.println("       Main -setDefaults -properties <connectorserver.properties>");
        System.out.println("NOTE: If using SSL, you must specify the system config");
        System.out.println("    properties: ");
        System.out.println("        -Djavax.net.ssl.keyStore");
        System.out.println("        -Djavax.net.ssl.keyStoreType (optional)");
        System.out.println("        -Djavax.net.ssl.keyStorePassword");
    }

    public static void main(String[] args) throws Exception {
        Properties properties;
        if (args.length == 0 || args.length % 2 != 1) {
            Main.usage();
            return;
        }
        String propertiesFileName = null;
        String key = null;
        for (int i = 1; i < args.length; i += 2) {
            String name = args[i];
            String value = args[i + 1];
            if (name.equalsIgnoreCase("-properties")) {
                propertiesFileName = value;
                continue;
            }
            if (name.equalsIgnoreCase("-key")) {
                key = value;
                continue;
            }
            Main.usage();
            return;
        }
        String cmd = args[0];
        if (cmd.equalsIgnoreCase("-run")) {
            if (propertiesFileName == null || key != null) {
                Main.usage();
                return;
            }
            properties = IOUtil.loadPropertiesFile(propertiesFileName);
            Main.run(properties);
        } else if (cmd.equalsIgnoreCase("-setkey")) {
            if (propertiesFileName == null || key == null) {
                Main.usage();
                return;
            }
            properties = IOUtil.loadPropertiesFile((String)propertiesFileName);
            properties.put(PROP_KEY, SecurityUtil.computeBase64SHA1Hash((char[])key.toCharArray()));
            IOUtil.storePropertiesFile((Path)Path.of(propertiesFileName, new String[0]), (Properties)properties);
        } else if (cmd.equalsIgnoreCase("-setDefaults")) {
            if (propertiesFileName == null || key != null) {
                Main.usage();
                return;
            }
            IOUtil.extractResourceToFile(Main.class, (String)"connectorserver.properties", (Path)Path.of(propertiesFileName, new String[0]));
        } else {
            Main.usage();
        }
    }

    private static void run(Properties properties) throws Exception {
        if (connectorServer != null) {
            System.err.println("Server has already been started");
        }
        String portStr = properties.getProperty(PROP_PORT);
        String bundleDirStr = properties.getProperty(PROP_BUNDLE_DIR);
        String libDirStr = properties.getProperty(PROP_LIB_DIR);
        String useSSLStr = properties.getProperty(PROP_SSL);
        String ifAddress = properties.getProperty(PROP_IFADDRESS);
        String keyHash = properties.getProperty(PROP_KEY);
        String loggerClass = properties.getProperty(PROP_LOGGER_CLASS);
        if (portStr == null) {
            throw new ConnectorException("connectorserver.properties is missing connectorserver.port");
        }
        if (bundleDirStr == null) {
            throw new ConnectorException("connectorserver.properties is missing connectorserver.bundleDir");
        }
        if (keyHash == null) {
            throw new ConnectorException("connectorserver.properties is missing connectorserver.key");
        }
        if (loggerClass == null) {
            System.out.println("Logger Class is null");
            loggerClass = DEFAULT_LOG_SPI;
        }
        Main.ensureLoggingNotInitialized();
        System.setProperty(Log.LOGSPI_PROP, loggerClass);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Main.getLog().info("Logger class on connector server set to: " + loggerClass, new Object[0]);
        int port = Integer.parseInt(portStr);
        if (Thread.currentThread().getContextClassLoader() == null) {
            Main.getLog().warn("Context class loader is null, working around", new Object[0]);
            Thread.currentThread().setContextClassLoader(Main.class.getClassLoader());
        }
        connectorServer = ConnectorServer.newInstance();
        connectorServer.setPort(port);
        connectorServer.setBundleURLs(Main.buildBundleURLs(Path.of(bundleDirStr, new String[0])));
        if (libDirStr != null) {
            ClassLoader cl = Main.buildLibClassLoader(Path.of(libDirStr, new String[0]));
            connectorServer.setBundleParentClassLoader(cl);
        }
        connectorServer.setKeyHash(keyHash);
        if (useSSLStr != null) {
            boolean useSSL = Boolean.parseBoolean(useSSLStr);
            connectorServer.setUseSSL(useSSL);
        }
        if (ifAddress != null) {
            connectorServer.setIfAddress(InetAddress.getByName(ifAddress));
        }
        connectorServer.start();
        Main.getLog().info("Connector server listening on port " + port, new Object[0]);
        connectorServer.awaitStop();
    }

    public static void stop(String[] args) {
        if (connectorServer == null) {
            System.err.println("Server has not been started yet");
            return;
        }
        if (Thread.currentThread().getContextClassLoader() == null) {
            Main.getLog().warn("Context class loader is null, working around", new Object[0]);
            Thread.currentThread().setContextClassLoader(Main.class.getClassLoader());
        }
        connectorServer.stop();
        Main.getLog().info("Connector server stopped", new Object[0]);
        LogManager.getLogManager().reset();
    }

    private static void ensureLoggingNotInitialized() throws Exception {
        Field field = Log.class.getDeclaredField("cacheSPI");
        field.setAccessible(true);
        if (field.get(null) != null) {
            throw new IllegalStateException("Logging has already been initialized");
        }
    }

    private static List<URL> buildBundleURLs(Path dir) throws MalformedURLException {
        List<URL> rv = Main.getJarFiles(dir.toFile());
        if (rv.isEmpty()) {
            Main.getLog().warn("No bundles found in the bundles directory.", new Object[0]);
        }
        return rv;
    }

    private static ClassLoader buildLibClassLoader(Path dir) throws MalformedURLException {
        List<URL> jars = Main.getJarFiles(dir.toFile());
        if (!jars.isEmpty()) {
            return new URLClassLoader((URL[])jars.toArray(URL[]::new), ConnectorInfoManagerFactory.class.getClassLoader());
        }
        return null;
    }

    private static List<URL> getJarFiles(File dir) throws MalformedURLException {
        if (!dir.isDirectory()) {
            throw new ConnectorException(dir.getPath() + " does not exist");
        }
        ArrayList<URL> rv = new ArrayList<URL>();
        for (File bundle : dir.listFiles()) {
            if (!bundle.getName().endsWith(".jar")) continue;
            rv.add(bundle.toURI().toURL());
        }
        return rv;
    }

    private static synchronized Log getLog() {
        if (log == null) {
            log = Log.getLog(Main.class);
        }
        return log;
    }
}

