/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigHandler;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ZkConfigManager;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=100L)
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015BQ\u0001\u000b\u0001\u0005\u0002%BQa\u000e\u0001\u0005\u0002aBQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\u0002-DQ\u0001\u001d\u0001\u0005\nEDq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002D\u0002!I!!2\u0003/\u0011Kh.Y7jG\u000e{gNZ5h\u0007\"\fgnZ3UKN$(BA\r\u001b\u0003\u0019\u0019XM\u001d<fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u001b\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005\r\u0002#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005A\u0012aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003)\u00022a\u000b\u001a5\u001b\u0005a#BA\u0017/\u0003%IW.\\;uC\ndWM\u0003\u00020a\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003E\nQa]2bY\u0006L!a\r\u0017\u0003\t1K7\u000f\u001e\t\u0003OUJ!A\u000e\r\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011i\u0016\u001cHoQ8oM&<7\t[1oO\u0016$\"!O\u001f\u0011\u0005iZT\"\u0001\u0019\n\u0005q\u0002$\u0001B+oSRDQAP\u0002A\u0002}\na!];peVl\u0007C\u0001!H\u001d\t\tU\t\u0005\u0002Ca5\t1I\u0003\u0002E9\u00051AH]8pizJ!A\u0012\u0019\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rBB#aA&\u0011\u00051+V\"A'\u000b\u00059{\u0015A\u00029be\u0006l7O\u0003\u0002Q#\u00069!.\u001e9ji\u0016\u0014(B\u0001*T\u0003\u0015QWO\\5u\u0015\u0005!\u0016aA8sO&\u0011a+\u0014\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006B\u0002Y=~\u0003\"!\u0017/\u000e\u0003iS!aW'\u0002\u0011A\u0014xN^5eKJL!!\u0018.\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\u0001'-I\u0001b\u0003\tQ8.I\u0001d\u0003\u0015Y'/\u00194u\u0003q!Xm\u001d;Es:\fW.[2U_BL7mQ8oM&<7\t[1oO\u0016$\"!\u000f4\t\u000by\"\u0001\u0019A )\u0005\u0011Y\u0005\u0006\u0002\u0003Y=&d#\u0001\u00192\u0002=Q,7\u000f^'fgN\fw-\u001a$pe6\fGOV3sg&|gn\u00115b]\u001e,GCA\u001dm\u0011\u0015qT\u00011\u0001@Q\t)1\n\u000b\u0003\u00061z{G&\u00011\u0002+Q,7\u000f^)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR)\u0011H]@\u0002\u0014!)1O\u0002a\u0001i\u00061QM\u001c;jif\u0004\"!^?\u000e\u0003YT!a\u001e=\u0002\u000bE,x\u000e^1\u000b\u0005eT\u0018AB2p[6|gN\u0003\u0002\u001cw*\u0011ApU\u0001\u0007CB\f7\r[3\n\u0005y4(!E\"mS\u0016tG/U;pi\u0006,e\u000e^5us\"9\u0011\u0011\u0001\u0004A\u0002\u0005\r\u0011\u0001B;tKJ\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003bkRD'bAA\u0007q\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002\u0012\u0005\u001d!AD&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0005\u0007\u0003+1\u0001\u0019A \u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\fQ\u0004^3ti\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0004s\u0005m\u0001\"\u0002 \b\u0001\u0004y\u0004FA\u0004LQ\u00159\u0001LXA\u0011Y\t\u0001'-A\ruKN$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,GcA\u001d\u0002(!)a\b\u0003a\u0001\u007f!\u0012\u0001b\u0013\u0015\u0006\u0011as\u0016Q\u0006\u0017\u0003A\n\f1\u0004^3tiV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018m\u00115b]\u001e,GcA\u001d\u00024!)a(\u0003a\u0001\u007f!\u0012\u0011b\u0013\u0015\u0006\u0013as\u0016\u0011\b\u0017\u0003A\n\fA\u0005^3ti\u0012+g-Y;mi\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0004s\u0005}\u0002\"\u0002 \u000b\u0001\u0004y\u0004F\u0001\u0006LQ\u0015Q\u0001LXA#Y\t\u0001'-\u0001\u0011uKN$H)\u001a4bk2$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,GcA\u001d\u0002L!)ah\u0003a\u0001\u007f!\u00121b\u0013\u0015\u0006\u0017as\u0016\u0011\u000b\u0017\u0003A\n\f\u0001\u0006^3ti\u0012+g-Y;miV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2!OA,\u0011\u0015qD\u00021\u0001@Q\ta1\nK\u0003\r1z\u000bi\u0006\f\u0002aE\u00069B/Z:u#V|G/Y%oSRL\u0017\r\\5{CRLwN\u001c\u000b\u0004s\u0005\r\u0004\"\u0002 \u000e\u0001\u0004y\u0004FA\u0007LQ\u0015i\u0001LXA5Y\u0005\u0001\u0017!\u0007;fgRL\u0005/U;pi\u0006Le.\u001b;jC2L'0\u0019;j_:$2!OA8\u0011\u0015qd\u00021\u0001@Q\tq1\nK\u0003\u000f1z\u000b)\b\f\u0002aE\u00069B/Z:u\u0013B\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0004s\u0005m\u0004\"\u0002 \u0010\u0001\u0004y\u0004FA\bLQ\u0015y\u0001LXAAY\t\u0001'-\u0001\u0012uKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK>sgj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018n\u0019\u000b\u0004s\u0005\u001d\u0005\"\u0002 \u0011\u0001\u0004y\u0004F\u0001\tLQ\u0015\u0001\u0002LXAGY\u0005\u0001\u0017!\u0003;f[B$v\u000e]5d)\u0005y\u0014!\r;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f\u001f:tuN\\#ySN$\u0018N\\4U_BL7mV5uQ\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0004s\u0005]\u0005\"\u0002 \u0013\u0001\u0004y\u0004F\u0001\nLQ\u0015\u0011\u0002LXAOY\t\u0001'-A\fuKN$\bK]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]R\u0019\u0011(a)\t\u000by\u001a\u0002\u0019A )\u0005MY\u0005&B\nY=\u0006%F&\u00011\u0002MQ,7\u000f^%oGJ,W.\u001a8uC2\fE\u000e^3s\t\u00164\u0017-\u001e7u)>\u0004\u0018nY\"p]\u001aLw\rF\u0002:\u0003_CQA\u0010\u000bA\u0002}B#\u0001F&)\u000bQAf,!.-\u0005\u0001\u0014\u0017a\u0007;fgR\fE\u000e^3s\t\u00164\u0017-\u001e7u)>\u0004\u0018nY\"p]\u001aLw\rF\u0002:\u0003wCQAP\u000bA\u0002}B#!F&)\u000bUAf,!1-\u0005\u0001\u0014\u0017!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0011\u0011q\u0019\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003\u0015\tG-\\5o\u0015\r\t\tN_\u0001\bG2LWM\u001c;t\u0013\u0011\t).a3\u0003\u000b\u0005#W.\u001b8)\u000f\u0001\tI.!:\u0002hB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`>\u000b1!\u00199j\u0013\u0011\t\u0019/!8\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\tA\r")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChange(String quorum) {
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)"topics"), (String)"Should contain a ConfigHandler for topics");
        }
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("flush.messages", oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var25_12 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var13_7 = null;
        Object var18_11 = null;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", newVal.toString()), AlterConfigOp.OpType.SET);
                ConfigResource resource2 = new ConfigResource(ConfigResource.Type.BROKER, "");
                AlterConfigOp op2 = new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG, newVal.toString()), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource2), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op2, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.setProperty("flush.messages", newVal.toString());
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var26_25 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicTopicConfigChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var26_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var14_6 = null;
        Object var19_10 = null;
        int newSegmentSize = 2000;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("segment.bytes", Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.put("segment.bytes", Integer.toString(newSegmentSize));
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var27_27 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var20_22 = null;
        Object var25_26 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), (Long)null, 30000, 20000));
        Assertions.assertTrue((boolean)log.logSegments().stream().allMatch(x$1 -> x$1.size() > 1000), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testMessageFormatVersionChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("message.format.version", "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic metadata propagation failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        CompressionType compressionType = CompressionType.LZ4;
        logProps.put("message.format.version", "0.11.0");
        logProps.put("compression.type", compressionType.name);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Topic config change propagation failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0)))));
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            long l = 10000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var25_13 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var13_8 = null;
            Object var18_12 = null;
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<ClientQuotaAlteration> removals = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null))));
            admin.alterClientQuotas(removals).all().get();
            long l3 = 10000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l4 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                        Object var26_23 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l4);
                    l4 += package$.MODULE$.min(l4, 1000L);
                    continue;
                }
                break;
            }
            Object var19_18 = null;
            Object var24_22 = null;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClientIdQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUserQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUserClientIdQuotaChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testQuotaInitialization(String quorum) {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig("overriddenUser", userProps, x$3);
        AdminZkClient qual$2 = this.adminZkClient();
        boolean x$6 = qual$2.changeUserOrUserClientIdConfig$default$3();
        qual$2.changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps, x$6);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound3 = 10000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound3, true), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound4 = 20000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound4, true), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound5 = 100000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound5, true), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        double upperBound_upperBound6 = 200000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound6, true), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
                admin.alterClientQuotas(alterations).all().get();
            }
        } else {
            broker.shutdown();
            Properties ipDefaultProps = new Properties();
            ipDefaultProps.put("connection_creation_rate", "20");
            this.adminZkClient().changeIpConfig("<default>", ipDefaultProps);
            Properties ipOverrideProps = new Properties();
            ipOverrideProps.put("connection_creation_rate", "10");
            this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
            this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
                return BoxedUnit.UNIT;
            });
            broker.startup();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$2(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var14_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10));
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions1 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions2 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testConfigChangeOnNonExistingTopic(String quorum) {
        String topic = this.tempTopic();
        Properties logProps = new Properties();
        logProps.put("flush.messages", Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    private String tempTopic() {
        return new StringBuilder(9).append("testTopic").append(TestUtils$.MODULE$.random().nextInt(1000000)).toString();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChangeOnNonExistingTopicWithAdminClient(String quorum) {
        String topic = this.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testProcessNotification(String quorum) {
        new Properties().put("a.b", "10");
        ConfigHandler handler = (ConfigHandler)Mockito.mock(ConfigHandler.class);
        ZkConfigManager configManager = new ZkConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topics"), (Object)handler)})));
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"topics")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"topics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap.elem).asJava()));
        ((ConfigHandler)Mockito.verify((Object)handler)).processConfigChanges(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementalAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "200000"), AlterConfigOp.OpType.SET);
            KafkaFuture future = admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, InvalidRequestException.class, (Option<String>)None$.MODULE$);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            Config config = new Config(Collections.singleton(new ConfigEntry("flush.messages", "200000")));
            KafkaFuture future = admin.alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, InvalidRequestException.class, (Option<String>)None$.MODULE$);
        }
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (long)((UnifiedLog)logOpt.get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (long)((UnifiedLog)qual$2.getLog((TopicPartition)tp$1, (boolean)x$4).get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (int)((UnifiedLog)logOpt.get()).config().segmentSize);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, UnifiedLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (int)log$1.config().segmentSize);
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, CompressionType compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        if (((UnifiedLog)qual$3.getLog((TopicPartition)tp$3, (boolean)x$6).get()).config().compression.isPresent()) {
            LogManager qual$4 = server$1.logManager();
            boolean x$8 = qual$4.getLog$default$2();
            CompressionType compressionType = ((Compression)((UnifiedLog)qual$4.getLog((TopicPartition)tp$3, (boolean)x$8).get()).config().compression.get()).type();
            if (!(compressionType != null ? !compressionType.equals(compressionType$1) : compressionType$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$3 = $this.zkClient();
        String x$7 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$8 = qual$3.deletePath$default$2();
        boolean x$9 = qual$3.deletePath$default$3();
        qual$3.deletePath(x$7, x$8, x$9);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$2(KafkaBroker broker$1) {
        ConnectionQuotas connectionQuotas = broker$1.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota) {
        ConnectionQuotas connectionQuotas = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas();
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var10_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }
}

